/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import com.domochevsky.quiverbow.weapons._WeaponBase;
import cpw.mods.fml.common.Loader;
import java.util.Set;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackMeleeLongRange;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackNearest;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIHurt;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMedicBase;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedAlarmResponse;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedAttackRanged;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedCommander;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedFollowCommand;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedGetFood;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedIdleWhenHungry;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedPatrol;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedRideHorse;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.RangeAttackHelper;
import net.shadowmage.ancientwarfare.npc.item.ItemCombatOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;

public class NpcCombat
extends NpcPlayerOwned
implements IRangedAttackMob {
    private EntityAIBase collideAI = new NpcAIAttackMeleeLongRange(this);
    private EntityAIBase arrowAI = new NpcAIPlayerOwnedAttackRanged(this);
    private NpcAIPlayerOwnedPatrol patrolAI;

    public NpcCombat(World par1World) {
        super(par1World);
        IEntitySelector selector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return NpcCombat.this.isHostileTowards(entity);
            }
        };
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor((EntityLiving)this, true));
        this.horseAI = new NpcAIPlayerOwnedRideHorse(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.horseAI);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIPlayerOwnedFollowCommand(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIPlayerOwnedAlarmResponse(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new NpcAIPlayerOwnedGetFood(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new NpcAIPlayerOwnedIdleWhenHungry(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new NpcAIMedicBase(this));
        this.patrolAI = new NpcAIPlayerOwnedPatrol(this);
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)this.patrolAI);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 5.0f, 20.0f, 5.0f));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new NpcAIPlayerOwnedCommander(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new NpcAIHurt(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new NpcAIAttackNearest(this, selector));
    }

    public final boolean func_98052_bS() {
        return !"archer".equals(this.getSubtypeFromEquipment());
    }

    @Override
    public boolean isValidOrdersStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemCombatOrder;
    }

    @Override
    public void onOrdersInventoryChanged() {
        this.patrolAI.onOrdersInventoryChanged();
    }

    @Override
    public void onWeaponInventoryChanged() {
        super.onWeaponInventoryChanged();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.arrowAI);
            this.field_70714_bg.func_85156_a(this.collideAI);
            ItemStack stack = this.func_70694_bm();
            if (stack != null && this.isBow(stack.func_77973_b())) {
                this.field_70714_bg.func_75776_a(7, this.arrowAI);
            } else {
                this.field_70714_bg.func_75776_a(7, this.collideAI);
            }
        }
    }

    @Override
    public boolean func_70686_a(Class claz) {
        return this.func_70694_bm() != null && this.isBow(this.func_70694_bm().func_77973_b()) || super.func_70686_a(claz);
    }

    private boolean isBow(Item item) {
        if (Loader.isModLoaded((String)"quiverchevsky") && item instanceof _WeaponBase) {
            return true;
        }
        return item instanceof ItemBow;
    }

    @Override
    public String getNpcSubType() {
        return this.getSubtypeFromEquipment();
    }

    protected String getSubtypeFromEquipment() {
        ItemStack stack = this.func_70694_bm();
        if (stack != null && stack.func_77973_b() != null) {
            Item item = stack.func_77973_b();
            Set tools = item.getToolClasses(stack);
            if (tools.contains("axe")) {
                return "medic";
            }
            if (tools.contains("hammer")) {
                return "engineer";
            }
            if (this.isBow(item)) {
                return "archer";
            }
            if (item instanceof ItemCommandBaton) {
                return "commander";
            }
            if (item.func_77616_k(stack)) {
                return "soldier";
            }
        }
        return "";
    }

    @Override
    public String getNpcType() {
        return "combat";
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.onWeaponInventoryChanged();
        if (tag.func_74764_b("patrolAI")) {
            this.patrolAI.readFromNBT(tag.func_74775_l("patrolAI"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("patrolAI", (NBTBase)this.patrolAI.writeToNBT(new NBTTagCompound()));
    }

    public void func_82196_d(EntityLivingBase par1EntityLivingBase, float par2) {
        RangeAttackHelper.DEFAULT.doRangedAttack((EntityLivingBase)this, par1EntityLivingBase, par2);
    }
}

