/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;

public class InventoryTools {
    public static boolean canInventoryHold(IInventory inventory, int side, ItemStack stack) {
        return InventoryTools.canInventoryHold(inventory, InventoryTools.getSlotsForSide(inventory, side), stack);
    }

    public static boolean canInventoryHold(IInventory inventory, int[] slots, ItemStack stack) {
        int toMerge = stack.field_77994_a;
        for (int index : slots) {
            ItemStack existing = inventory.func_70301_a(index);
            if (existing == null) {
                return true;
            }
            if (InventoryTools.doItemStacksMatch(stack, existing)) {
                toMerge -= existing.func_77976_d() - existing.field_77994_a;
            }
            if (toMerge <= 0) break;
        }
        return toMerge <= 0;
    }

    public static boolean canInventoryHold(IInventory inventory, int side, List<ItemStack> stacks) {
        return InventoryTools.canInventoryHold(inventory, InventoryTools.getSlotsForSide(inventory, side), stacks);
    }

    public static boolean canInventoryHold(IInventory inventory, int[] slots, List<ItemStack> stacks) {
        int emptySlots = 0;
        ItemQuantityMap itemQuantities = new ItemQuantityMap();
        for (ItemStack stack : stacks) {
            itemQuantities.addCount(stack, stack.field_77994_a);
        }
        for (Object slot : (Object)slots) {
            ItemStack stack = inventory.func_70301_a((int)slot);
            if (stack == null) {
                ++emptySlots;
                continue;
            }
            if (!itemQuantities.contains(stack)) continue;
            itemQuantities.decreaseCount(stack, stack.func_77976_d() - stack.field_77994_a);
        }
        return emptySlots >= itemQuantities.keySet().size();
    }

    public static void updateCursorItem(EntityPlayerMP player, ItemStack stack, boolean shiftClick) {
        if (stack.field_77994_a > 0) {
            if (shiftClick) {
                stack = InventoryTools.mergeItemStack((IInventory)player.field_71071_by, stack, -1);
            }
            if (stack != null) {
                player.field_71071_by.func_70437_b(stack);
                player.func_71113_k();
            }
        }
    }

    public static ItemStack mergeItemStack(IInventory inventory, ItemStack stack, int side) {
        return InventoryTools.mergeItemStack(inventory, stack, InventoryTools.getSlotsForSide(inventory, side));
    }

    public static ItemStack mergeItemStack(IInventory inventory, ItemStack stack, int[] slotIndices) {
        ItemStack slotStack;
        if (slotIndices == null || slotIndices.length == 0) {
            return stack;
        }
        for (int index : slotIndices) {
            int toMove = stack.field_77994_a;
            slotStack = inventory.func_70301_a(index);
            if (InventoryTools.doItemStacksMatch(stack, slotStack)) {
                if (toMove > slotStack.func_77976_d() - slotStack.field_77994_a) {
                    toMove = slotStack.func_77976_d() - slotStack.field_77994_a;
                }
                stack.field_77994_a -= toMove;
                slotStack.field_77994_a += toMove;
                inventory.func_70299_a(index, slotStack);
                inventory.func_70296_d();
            }
            if (stack.field_77994_a > 0) continue;
            return null;
        }
        if (stack.field_77994_a > 0) {
            for (int index : slotIndices) {
                slotStack = inventory.func_70301_a(index);
                if (slotStack != null || !inventory.func_94041_b(index, stack)) continue;
                inventory.func_70299_a(index, stack);
                inventory.func_70296_d();
                return null;
            }
        } else {
            return null;
        }
        return stack;
    }

    public static ItemStack removeItems(IInventory inventory, int side, ItemStack filter, int quantity) {
        int[] slotIndices = InventoryTools.getSlotsForSide(inventory, side);
        if (slotIndices == null) {
            return null;
        }
        if (quantity > filter.func_77976_d()) {
            quantity = filter.func_77976_d();
        }
        ItemStack returnStack = null;
        for (int index : slotIndices) {
            int toMove;
            ItemStack slotStack = inventory.func_70301_a(index);
            if (slotStack == null || !InventoryTools.doItemStacksMatch(filter, slotStack)) continue;
            if (returnStack == null) {
                returnStack = filter.func_77946_l();
                returnStack.field_77994_a = 0;
            }
            if ((toMove = slotStack.field_77994_a) > quantity) {
                toMove = quantity;
            }
            if (toMove + returnStack.field_77994_a > returnStack.func_77976_d()) {
                toMove = returnStack.func_77976_d() - returnStack.field_77994_a;
            }
            returnStack.field_77994_a += toMove;
            slotStack.field_77994_a -= toMove;
            quantity -= toMove;
            if (slotStack.field_77994_a <= 0) {
                inventory.func_70299_a(index, null);
            }
            inventory.func_70296_d();
            if (quantity <= 0) break;
        }
        return returnStack;
    }

    public static ItemStack getConsumedItem(IInventory craft, IInventory storage, int index, ItemStack itemStack) {
        if (itemStack.func_77973_b().hasContainerItem(itemStack)) {
            ItemStack container = itemStack.func_77973_b().getContainerItem(itemStack);
            if (container == null || container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) {
                return null;
            }
            if (itemStack.func_77973_b().func_77630_h(itemStack) || craft.func_70301_a(index) != null) {
                return InventoryTools.mergeItemStack(storage, container, -1);
            }
            craft.func_70299_a(index, container);
        }
        return null;
    }

    public static int transferItems(IInventory from, IInventory to, ItemStack filter, int quantity, int fromSide, int toSide) {
        return InventoryTools.transferItems(from, to, filter, quantity, fromSide, toSide, false, false);
    }

    public static int transferItems(IInventory from, IInventory to, ItemStack filter, int quantity, int fromSide, int toSide, boolean ignoreDamage, boolean ignoreNBT) {
        int moved = 0;
        int[] fromIndices = InventoryTools.getSlotsForSide(from, fromSide);
        int toMove = quantity;
        for (int fromIndex : fromIndices) {
            ItemStack s1 = from.func_70301_a(fromIndex);
            if (s1 == null || !InventoryTools.doItemStacksMatch(filter, s1, ignoreDamage, ignoreNBT)) continue;
            int stackSize = s1.field_77994_a;
            if (s1.field_77994_a > toMove) {
                ItemStack s2 = s1.func_77946_l();
                s2.field_77994_a = toMove;
                s1.field_77994_a -= toMove;
                stackSize = s2.field_77994_a;
                if ((s2 = InventoryTools.mergeItemStack(to, s2, toSide)) != null) {
                    moved += stackSize - s2.field_77994_a;
                    toMove -= stackSize - s2.field_77994_a;
                    InventoryTools.mergeItemStack(from, s2, fromSide);
                    from.func_70296_d();
                    break;
                }
                moved += stackSize;
                toMove -= stackSize;
                from.func_70296_d();
            } else {
                if ((s1 = InventoryTools.mergeItemStack(to, s1, toSide)) != null) {
                    moved += stackSize - s1.field_77994_a;
                    toMove -= stackSize - s1.field_77994_a;
                    from.func_70296_d();
                    break;
                }
                moved += stackSize;
                toMove -= stackSize;
                from.func_70299_a(fromIndex, null);
                from.func_70296_d();
            }
            if (toMove <= 0) break;
        }
        return moved;
    }

    public static int getNumOfSlotsContaining(IInventory inv, int side, ItemStack filter) {
        if (inv.func_70302_i_() <= 0) {
            return 0;
        }
        int[] slotIndices = InventoryTools.getSlotsForSide(inv, side);
        if (slotIndices == null || slotIndices.length == 0) {
            return 0;
        }
        int count = 0;
        for (int slotIndice : slotIndices) {
            ItemStack stack = inv.func_70301_a(slotIndice);
            if (stack == null || !InventoryTools.doItemStacksMatch(filter, stack)) continue;
            ++count;
        }
        return count;
    }

    public static int getCountOf(IInventory inv, int side, ItemStack filter) {
        if (inv.func_70302_i_() <= 0) {
            return 0;
        }
        int[] slotIndices = InventoryTools.getSlotsForSide(inv, side);
        if (slotIndices == null || slotIndices.length == 0) {
            return 0;
        }
        int count = 0;
        for (int slotIndice : slotIndices) {
            ItemStack stack = inv.func_70301_a(slotIndice);
            if (stack == null || !InventoryTools.doItemStacksMatch(filter, stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static boolean doItemStacksMatch(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)stack1, (ItemStack)stack2, (stack1 != null && (stack1.func_77984_f() || stack1.func_77960_j() != Short.MAX_VALUE) ? 1 : 0) != 0) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean doItemStacksMatch(ItemStack stack1, ItemStack stack2, boolean ignoreDamage, boolean ignoreNBT) {
        if (!ignoreDamage && !ignoreNBT) {
            return InventoryTools.doItemStacksMatch(stack1, stack2);
        }
        if (stack1 == null) {
            return stack2 == null;
        }
        if (stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (!ignoreDamage && stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        return ignoreNBT || ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean doItemStacksMatch(ItemStack stack1, ItemStack stack2, boolean matchDamage, boolean matchNBT, boolean useOreDictionary) {
        if (!useOreDictionary) {
            return InventoryTools.doItemStacksMatch(stack1, stack2, !matchDamage, !matchNBT);
        }
        if (stack1 == null) {
            return stack2 == null;
        }
        if (stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() == stack2.func_77973_b()) {
            int[] id = OreDictionary.getOreIDs((ItemStack)stack1);
            if (id == null || id.length == 0) {
                return false;
            }
            int[] id2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (id2 == null || id2.length == 0) {
                return false;
            }
            for (int anId : id) {
                for (int anId2 : id2) {
                    if (anId != anId2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void dropItemInWorld(World world, ItemStack item, double x, double y, double z) {
        if (item == null || world == null || world.field_72995_K) {
            return;
        }
        EntityItem entityToSpawn = new EntityItem(world, x += (double)(world.field_73012_v.nextFloat() * 0.6f - 0.3f), y += (double)(world.field_73012_v.nextFloat() * 0.6f + 1.0f - 0.3f), z += (double)(world.field_73012_v.nextFloat() * 0.6f - 0.3f), item);
        world.func_72838_d((Entity)entityToSpawn);
    }

    public static void dropInventoryInWorld(World world, IInventory localInventory, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        if (localInventory != null) {
            for (int i = 0; i < localInventory.func_70302_i_(); ++i) {
                ItemStack stack = localInventory.func_70304_b(i);
                if (stack == null) continue;
                InventoryTools.dropItemInWorld(world, stack, x, y, z);
            }
        }
    }

    public static NBTTagCompound writeInventoryToNBT(IInventory inventory, NBTTagCompound tag) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null) continue;
            NBTTagCompound itemTag = InventoryTools.writeItemStack(item);
            itemTag.func_74777_a("slot", (short)i);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("itemList", (NBTBase)itemList);
        return tag;
    }

    public static void readInventoryFromNBT(IInventory inventory, NBTTagCompound tag) {
        NBTTagList itemList = tag.func_150295_c("itemList", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = itemList.func_150305_b(i);
            short slot = itemTag.func_74765_d("slot");
            ItemStack item = InventoryTools.readItemStack(itemTag);
            inventory.func_70299_a((int)slot, item);
        }
    }

    public static NBTTagCompound writeItemStack(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("item", Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        tag.func_74768_a("damage", stack.func_77960_j());
        tag.func_74768_a("quantity", stack.field_77994_a);
        if (stack.field_77990_d != null) {
            tag.func_74782_a("stackTag", stack.field_77990_d.func_74737_b());
        }
        return tag;
    }

    public static ItemStack readItemStack(NBTTagCompound tag) {
        Item item;
        if (tag.func_74764_b("item") && tag.func_74764_b("damage") && tag.func_74764_b("quantity") && (item = (Item)Item.field_150901_e.func_82594_a(tag.func_74779_i("item"))) != null) {
            int damage = tag.func_74762_e("damage");
            int quantity = tag.func_74762_e("quantity");
            NBTTagCompound stackTag = null;
            if (tag.func_74764_b("stackTag")) {
                stackTag = tag.func_74775_l("stackTag");
            }
            ItemStack stack = new ItemStack(item, quantity, damage);
            stack.field_77990_d = stackTag;
            return stack;
        }
        return null;
    }

    public static void compactStackList(List<ItemStack> in, List<ItemStack> out) {
        HashMap<ItemQuantityMap.ItemHashEntry, Integer> map = new HashMap<ItemQuantityMap.ItemHashEntry, Integer>();
        for (ItemStack stack : in) {
            int count = 0;
            ItemQuantityMap.ItemHashEntry wrap = new ItemQuantityMap.ItemHashEntry(stack);
            if (map.containsKey(wrap)) {
                count = (Integer)map.get(wrap);
            }
            map.put(wrap, count += stack.field_77994_a);
        }
        for (ItemQuantityMap.ItemHashEntry wrap1 : map.keySet()) {
            ItemStack outStack;
            for (int qty = ((Integer)map.get(wrap1)).intValue(); qty > 0; qty -= outStack.field_77994_a) {
                outStack = wrap1.getItemStack();
                outStack.field_77994_a = qty > outStack.func_77976_d() ? outStack.func_77976_d() : qty;
                out.add(outStack);
            }
        }
    }

    public static void compactStackList2(List<ItemStack> in, List<ItemStack> out) {
        int transfer = 0;
        for (ItemStack inStack : in) {
            int tmax = inStack.field_77994_a;
            for (ItemStack outStack : out) {
                if (!InventoryTools.doItemStacksMatch(inStack, outStack) || outStack.field_77994_a >= outStack.func_77976_d()) continue;
                transfer = outStack.func_77976_d() - outStack.field_77994_a;
                if (transfer > tmax) {
                    transfer = tmax;
                }
                outStack.field_77994_a += transfer;
                if ((tmax -= transfer) > 0) continue;
                break;
            }
            if (tmax <= 0) continue;
            ItemStack copy = inStack.func_77946_l();
            copy.field_77994_a = tmax;
            out.add(copy);
        }
    }

    public static List<ItemStack> compactStackList3(List<ItemStack> in) {
        ItemQuantityMap map = new ItemQuantityMap();
        for (ItemStack stack : in) {
            map.addCount(stack, stack.field_77994_a);
        }
        return map.getItems();
    }

    public static int[] getIndiceArrayForSpread(int len) {
        return new IndexHelper().getIndiceArrayForSpread(len);
    }

    public static int[] getSlotsForSide(IInventory inventory, int side) {
        if (side >= 0 && inventory instanceof ISidedInventory) {
            return ((ISidedInventory)inventory).func_94128_d(side);
        }
        return new IndexHelper().getIndiceArrayForSpread(inventory.func_70302_i_());
    }

    public static class IndexHelper {
        private int previousLength;

        public int[] getIndiceArrayForSpread(int length) {
            int[] array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.previousLength + i;
            }
            this.previousLength += length;
            return array;
        }
    }

    public static final class ComparatorItemStack
    implements Comparator<ItemStack> {
        private SortOrder sortOrder;
        private SortType sortType;
        private String textInput = "";

        public ComparatorItemStack(SortType type, SortOrder order) {
            this.sortOrder = order;
            this.sortType = type;
        }

        public void setTextInput(String text) {
            if (text == null) {
                text = "";
            }
            this.textInput = text;
        }

        public void setSortOrder(SortOrder order) {
            this.sortOrder = order;
        }

        public void setSortType(SortType type) {
            this.sortType = type;
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            int val = !this.textInput.isEmpty() ? this.compareViaTextInput(o1, o2) : this.sortType.compare(o1, o2);
            return val * this.sortOrder.mult;
        }

        private int compareViaTextInput(ItemStack o1, ItemStack o2) {
            String input = this.textInput.toLowerCase(Locale.ENGLISH);
            String n1 = o1.func_82833_r().toLowerCase(Locale.ENGLISH);
            String n2 = o2.func_82833_r().toLowerCase(Locale.ENGLISH);
            if (n1.startsWith(input)) {
                if (!n2.startsWith(input)) {
                    return 1;
                }
            } else {
                if (n2.startsWith(input)) {
                    return -1;
                }
                if (n1.contains(input)) {
                    if (!n2.contains(input)) {
                        return 1;
                    }
                } else if (n2.contains(input)) {
                    return -1;
                }
            }
            return this.sortType.compare(o1, o2);
        }

        public static enum SortOrder {
            ASCENDING(-1),
            DESCENDING(1);

            int mult;

            private SortOrder(int mult) {
                this.mult = mult;
            }
        }

        public static enum SortType {
            QUANTITY("sort_type_quantity"){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    int r = o1.field_77994_a - o2.field_77994_a;
                    if (r == 0) {
                        return super.compare(o1, o2);
                    }
                    return r;
                }
            }
            ,
            NAME("sort_type_name"){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    int r = o1.func_82833_r().compareTo(o2.func_82833_r());
                    if (r == 0) {
                        return super.compare(o1, o2);
                    }
                    return r;
                }
            }
            ,
            DAMAGE("sort_type_damage");

            public final String name;

            private SortType(String name) {
                this.name = name;
            }

            public SortType next() {
                if (this == QUANTITY) {
                    return NAME;
                }
                if (this == NAME) {
                    return DAMAGE;
                }
                return QUANTITY;
            }

            public String toString() {
                return this.name;
            }

            public int compare(ItemStack o1, ItemStack o2) {
                if (o1.func_77960_j() != o2.func_77960_j()) {
                    return o1.func_77960_j() - o2.func_77960_j();
                }
                if (o1.func_77942_o()) {
                    if (o2.func_77942_o()) {
                        return o1.func_77978_p().hashCode() - o2.func_77978_p().hashCode();
                    }
                    return 1;
                }
                if (o2.func_77942_o()) {
                    return -1;
                }
                return 0;
            }
        }
    }
}

