/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import org.apache.commons.lang3.tuple.Pair;

public class BlockFinder {
    private final World world;
    private final Block blockType;
    private final int metaValue;

    public BlockFinder(World worldIn, Block type, int meta) {
        this.world = worldIn;
        this.blockType = type;
        this.metaValue = meta;
    }

    public Pair<BlockPosition, BlockPosition> cross(BlockPosition center, BlockPosition max, List<BlockPosition> positions) {
        positions.add(center);
        int minX = center.x - 1;
        while (center.x - minX <= max.x && this.isTypeAt(minX, center.y, center.z)) {
            positions.add(new BlockPosition(minX, center.y, center.z));
            --minX;
        }
        ++minX;
        int maxX = center.x + 1;
        while (maxX - minX <= max.x && this.isTypeAt(maxX, center.y, center.z)) {
            positions.add(new BlockPosition(maxX, center.y, center.z));
            ++maxX;
        }
        --maxX;
        int minY = center.y - 1;
        while (center.y - minY <= max.y && this.isTypeAt(center.x, minY, center.z)) {
            positions.add(new BlockPosition(center.x, minY, center.z));
            --minY;
        }
        ++minY;
        int maxY = center.y + 1;
        while (maxY - minY <= max.y && this.isTypeAt(center.x, maxY, center.z)) {
            positions.add(new BlockPosition(center.x, maxY, center.z));
            ++maxY;
        }
        --maxY;
        int minZ = center.z - 1;
        while (center.z - minZ <= max.z && this.isTypeAt(center.x, center.y, minZ)) {
            positions.add(new BlockPosition(center.x, center.y, minZ));
            --minZ;
        }
        ++minZ;
        int maxZ = center.z + 1;
        while (maxZ - minZ <= max.z && this.isTypeAt(center.x, center.y, maxZ)) {
            positions.add(new BlockPosition(center.x, center.y, maxZ));
            ++maxZ;
        }
        return Pair.of((Object)new BlockPosition(minX, minY, minZ), (Object)new BlockPosition(maxX, maxY, --maxZ));
    }

    public boolean box(Pair<BlockPosition, BlockPosition> corners, List<BlockPosition> positions) {
        for (int x = ((BlockPosition)corners.getLeft()).x; x <= ((BlockPosition)corners.getRight()).x; ++x) {
            for (int y = ((BlockPosition)corners.getLeft()).y; y <= ((BlockPosition)corners.getRight()).y; ++y) {
                for (int z = ((BlockPosition)corners.getLeft()).z; z <= ((BlockPosition)corners.getRight()).z; ++z) {
                    BlockPosition temp = new BlockPosition(x, y, z);
                    if (positions.contains(temp)) continue;
                    if (this.isTypeAt(x, y, z)) {
                        positions.add(temp);
                        continue;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void connect(BlockPosition center, List<BlockPosition> positions, ForgeDirection ... directions) {
        if (this.isTypeAt(center.x, center.y, center.z)) {
            if (!positions.contains(center)) {
                positions.add(center);
            }
            for (ForgeDirection direction : directions) {
                this.connect(center.offset(direction.offsetX, direction.offsetY, direction.offsetZ), positions, directions);
            }
        }
    }

    public boolean isTypeAt(int x, int y, int z) {
        return this.world.func_147439_a(x, y, z) == this.blockType && this.world.func_72805_g(x, y, z) == this.metaValue;
    }
}

