/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import net.shadowmage.ancientwarfare.core.util.StringTools;

public class PacketResearchUpdate
extends PacketBase {
    String playerName;
    int toAdd;
    boolean add;
    boolean live;

    public PacketResearchUpdate(String playerName, int toAdd, boolean add, boolean live) {
        this.playerName = playerName;
        this.toAdd = toAdd;
        this.add = add;
        this.live = live;
    }

    public PacketResearchUpdate() {
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeInt(this.toAdd);
        data.writeBoolean(this.add);
        data.writeBoolean(this.live);
        StringTools.writeString(data, this.playerName);
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        this.toAdd = data.readInt();
        this.add = data.readBoolean();
        this.live = data.readBoolean();
        this.playerName = StringTools.readString(data);
    }

    @Override
    protected void execute(EntityPlayer player) {
        if (this.live) {
            if (this.add) {
                ResearchTracker.INSTANCE.addResearch(player.field_70170_p, this.playerName, this.toAdd);
            }
        } else if (this.add) {
            ResearchTracker.INSTANCE.addQueuedGoal(player.field_70170_p, this.playerName, this.toAdd);
        } else {
            ResearchTracker.INSTANCE.removeQueuedGoal(player.field_70170_p, this.playerName, this.toAdd);
        }
    }
}

