/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import net.shadowmage.ancientwarfare.core.model.Primitive;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import org.lwjgl.opengl.GL11;

public class PrimitiveBox
extends Primitive {
    float x1;
    float y1;
    float z1;
    float x2;
    float y2;
    float z2;

    public PrimitiveBox(ModelPiece parent) {
        super(parent);
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float z1() {
        return this.z1;
    }

    public float width() {
        return this.x2 - this.x1;
    }

    public float height() {
        return this.y2 - this.y1;
    }

    public float length() {
        return this.z2 - this.z1;
    }

    public PrimitiveBox(ModelPiece parent, float x1, float y1, float z1, float x2, float y2, float z2, float rx, float ry, float rz, float tx, float ty) {
        this(parent);
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.setTx(tx);
        this.setTy(ty);
    }

    public void setBounds(float x1, float y1, float z1, float width, float height, float length) {
        this.x1 = x1;
        this.x2 = x1 + width;
        this.y1 = y1;
        this.y2 = y1 + height;
        this.z1 = z1;
        this.z2 = z1 + length;
    }

    @Override
    public Primitive copy() {
        PrimitiveBox box = new PrimitiveBox(this.parent);
        box.setBounds(this.x1, this.y1, this.z1, this.x2 - this.x1, this.y2 - this.y1, this.z2 - this.z1);
        box.setOrigin(this.x, this.y, this.z);
        box.setRotation(this.rx, this.ry, this.rz);
        box.setTx(this.tx());
        box.setTy(this.ty());
        return box;
    }

    @Override
    protected void renderPrimitive(float tw, float th) {
        float px = 1.0f / tw;
        float py = 1.0f / th;
        float w = (float)Math.ceil((this.x2 - this.x1) * 16.0f);
        float h = (float)Math.ceil((this.y2 - this.y1) * 16.0f);
        float l = (float)Math.ceil((this.z2 - this.z1) * 16.0f);
        float ty = this.ty();
        float tx = this.tx();
        if (w < 1.0f) {
            w = 1.0f;
        }
        if (h < 1.0f) {
            h = 1.0f;
        }
        if (l < 1.0f) {
            l = 1.0f;
        }
        if (this.rx != 0.0f) {
            GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.ry != 0.0f) {
            GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rz != 0.0f) {
            GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glBegin((int)7);
        float tx1 = (tx + l) * px;
        float ty1 = (th - (ty + l + h)) * py;
        float tx2 = (tx + l + w) * px;
        float ty2 = (th - (ty + l)) * py;
        ty1 = 1.0f - ty1;
        ty2 = 1.0f - ty2;
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty1);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)this.z2);
        GL11.glTexCoord2f((float)tx2, (float)ty1);
        GL11.glVertex3f((float)this.x2, (float)this.y1, (float)this.z2);
        GL11.glTexCoord2f((float)tx2, (float)ty2);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)this.z2);
        GL11.glTexCoord2f((float)tx1, (float)ty2);
        GL11.glVertex3f((float)this.x1, (float)this.y2, (float)this.z2);
        tx1 = (tx + l + l + w) * px;
        ty1 = (th - (ty + l + h)) * py;
        tx2 = (tx + l + w + l + w) * px;
        ty2 = (th - (ty + l)) * py;
        ty1 = 1.0f - ty1;
        ty2 = 1.0f - ty2;
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty1);
        GL11.glVertex3f((float)this.x2, (float)this.y1, (float)this.z1);
        GL11.glTexCoord2f((float)tx2, (float)ty1);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)this.z1);
        GL11.glTexCoord2f((float)tx2, (float)ty2);
        GL11.glVertex3f((float)this.x1, (float)this.y2, (float)this.z1);
        GL11.glTexCoord2f((float)tx1, (float)ty2);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)this.z1);
        tx1 = (tx + l + w) * px;
        ty1 = (th - (ty + l + h)) * py;
        tx2 = (tx + l + w + l) * px;
        ty2 = (th - (ty + l)) * py;
        ty1 = 1.0f - ty1;
        ty2 = 1.0f - ty2;
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty1);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)this.z1);
        GL11.glTexCoord2f((float)tx2, (float)ty1);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)this.z2);
        GL11.glTexCoord2f((float)tx2, (float)ty2);
        GL11.glVertex3f((float)this.x1, (float)this.y2, (float)this.z2);
        GL11.glTexCoord2f((float)tx1, (float)ty2);
        GL11.glVertex3f((float)this.x1, (float)this.y2, (float)this.z1);
        tx1 = tx * px;
        ty1 = (th - (ty + l + h)) * py;
        tx2 = (tx + l) * px;
        ty2 = (th - (ty + l)) * py;
        ty1 = 1.0f - ty1;
        ty2 = 1.0f - ty2;
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty1);
        GL11.glVertex3f((float)this.x2, (float)this.y1, (float)this.z2);
        GL11.glTexCoord2f((float)tx2, (float)ty1);
        GL11.glVertex3f((float)this.x2, (float)this.y1, (float)this.z1);
        GL11.glTexCoord2f((float)tx2, (float)ty2);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)this.z1);
        GL11.glTexCoord2f((float)tx1, (float)ty2);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)this.z2);
        tx1 = (tx + l) * px;
        ty1 = (th - (ty + l)) * py;
        tx2 = (tx + l + w) * px;
        ty2 = (th - ty) * py;
        ty1 = 1.0f - ty1;
        ty2 = 1.0f - ty2;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty1);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)this.z1);
        GL11.glTexCoord2f((float)tx2, (float)ty1);
        GL11.glVertex3f((float)this.x1, (float)this.y2, (float)this.z1);
        GL11.glTexCoord2f((float)tx2, (float)ty2);
        GL11.glVertex3f((float)this.x1, (float)this.y2, (float)this.z2);
        GL11.glTexCoord2f((float)tx1, (float)ty2);
        GL11.glVertex3f((float)this.x2, (float)this.y2, (float)this.z2);
        tx1 = (tx + l + w) * px;
        ty1 = (th - (ty + l)) * py;
        tx2 = (tx + l + w + w) * px;
        ty2 = (th - ty) * py;
        ty1 = 1.0f - ty1;
        ty2 = 1.0f - ty2;
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)tx1, (float)ty1);
        GL11.glVertex3f((float)this.x2, (float)this.y1, (float)this.z2);
        GL11.glTexCoord2f((float)tx2, (float)ty1);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)this.z2);
        GL11.glTexCoord2f((float)tx2, (float)ty2);
        GL11.glVertex3f((float)this.x1, (float)this.y1, (float)this.z1);
        GL11.glTexCoord2f((float)tx1, (float)ty2);
        GL11.glVertex3f((float)this.x2, (float)this.y1, (float)this.z1);
        GL11.glEnd();
    }

    @Override
    public void addPrimitiveLines(ArrayList<String> lines) {
        StringBuilder b = new StringBuilder("box=").append(this.parent.getName()).append(",");
        b.append(this.x).append(",").append(this.y).append(",").append(this.z).append(",").append(this.rx).append(",").append(this.ry).append(",").append(this.rz).append(",").append(this.tx()).append(",").append(this.ty()).append(",");
        b.append(this.x1).append(",").append(this.y1).append(",").append(this.z1).append(",").append(this.x2).append(",").append(this.y2).append(",").append(this.z2);
        lines.add(b.toString());
    }

    @Override
    public void readFromLine(String[] lineBits) {
        this.x = StringTools.safeParseFloat(lineBits[1]);
        this.y = StringTools.safeParseFloat(lineBits[2]);
        this.z = StringTools.safeParseFloat(lineBits[3]);
        this.rx = StringTools.safeParseFloat(lineBits[4]);
        this.ry = StringTools.safeParseFloat(lineBits[5]);
        this.rz = StringTools.safeParseFloat(lineBits[6]);
        this.setTx(StringTools.safeParseFloat(lineBits[7]));
        this.setTy(StringTools.safeParseFloat(lineBits[8]));
        this.x1 = StringTools.safeParseFloat(lineBits[9]);
        this.y1 = StringTools.safeParseFloat(lineBits[10]);
        this.z1 = StringTools.safeParseFloat(lineBits[11]);
        this.x2 = StringTools.safeParseFloat(lineBits[12]);
        this.y2 = StringTools.safeParseFloat(lineBits[13]);
        this.z2 = StringTools.safeParseFloat(lineBits[14]);
    }

    @Override
    public void addUVMapToImage(BufferedImage image) {
        int y;
        int x;
        int u = (int)this.tx();
        int v = (int)this.ty();
        int w = (int)Math.ceil(this.x2 * 16.0f - this.x1 * 16.0f);
        int h = (int)Math.ceil(this.y2 * 16.0f - this.y1 * 16.0f);
        int l = (int)Math.ceil(this.z2 * 16.0f - this.z1 * 16.0f);
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        if (l < 1) {
            l = 1;
        }
        for (x = u + l; x < u + l + w; ++x) {
            for (y = v + l; y < v + l + h; ++y) {
                this.setImagePixel(image, x, y, -65536);
            }
        }
        for (x = u; x < u + l; ++x) {
            for (y = v + l; y < v + l + h; ++y) {
                this.setImagePixel(image, x, y, -16733696);
            }
        }
        for (x = u + l + w; x < u + l + w + l; ++x) {
            for (y = v + l; y < v + l + h; ++y) {
                this.setImagePixel(image, x, y, -16711936);
            }
        }
        for (x = u + l + w + l; x < u + l + w + l + w; ++x) {
            for (y = v + l; y < v + l + h; ++y) {
                this.setImagePixel(image, x, y, -5636096);
            }
        }
        for (x = u + l; x < u + l + w; ++x) {
            for (y = v; y < v + l; ++y) {
                this.setImagePixel(image, x, y, -16776961);
            }
        }
        for (x = u + l + w; x < u + l + w + w; ++x) {
            for (y = v; y < v + l; ++y) {
                this.setImagePixel(image, x, y, -16777046);
            }
        }
    }
}

