/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.shadowmage.ancientwarfare.core.interfaces.IResearchRecipe;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;

public class RecipeResearched
extends ShapedOreRecipe
implements IResearchRecipe {
    private final Set<Integer> neededResearch = new HashSet<Integer>();
    private int recipeWidth;
    private int recipeHeight;

    public RecipeResearched(ItemStack output, Object ... input) {
        super(output, input);
        this.setMirrored(false);
    }

    @Override
    public final IResearchRecipe addResearch(String ... names) {
        for (String name : names) {
            name = name.startsWith("research.") ? name : "research." + name;
            ResearchGoal g = ResearchGoal.getGoal(name);
            if (g == null) {
                throw new IllegalArgumentException("COULD NOT LOCATE RESEARCH GOAL FOR NAME: " + name);
            }
            this.neededResearch.add(g.getId());
        }
        return this;
    }

    @Override
    public Object[] getInputs() {
        return this.getInput();
    }

    @Override
    public Set<Integer> getNeededResearch() {
        return this.neededResearch;
    }

    @Override
    public int getRecipeWidth() {
        if (this.recipeWidth == 0) {
            this.recipeWidth = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)this, (String[])new String[]{"width"});
        }
        return this.recipeWidth;
    }

    @Override
    public int getRecipeHeight() {
        if (this.recipeHeight == 0) {
            this.recipeHeight = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)this, (String[])new String[]{"height"});
        }
        return this.recipeHeight;
    }
}

