/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.shadowmage.ancientwarfare.automation.AncientWarfareAutomation;
import net.shadowmage.ancientwarfare.automation.chunkloader.AWChunkLoader;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBase;
import net.shadowmage.ancientwarfare.core.interfaces.IBoundedSite;
import net.shadowmage.ancientwarfare.core.interfaces.IChunkLoaderTile;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public abstract class TileWorksiteBounded
extends TileWorksiteBase
implements IBoundedSite,
IChunkLoaderTile {
    private BlockPosition bbMin;
    private BlockPosition bbMax;
    private ForgeChunkManager.Ticket chunkTicket = null;

    @Override
    public EnumSet<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.of(WorksiteUpgrade.ENCHANTED_TOOLS_1, new WorksiteUpgrade[]{WorksiteUpgrade.ENCHANTED_TOOLS_2, WorksiteUpgrade.SIZE_MEDIUM, WorksiteUpgrade.SIZE_LARGE, WorksiteUpgrade.TOOL_QUALITY_1, WorksiteUpgrade.TOOL_QUALITY_2, WorksiteUpgrade.TOOL_QUALITY_3, WorksiteUpgrade.BASIC_CHUNK_LOADER});
    }

    @Override
    public final void onBlockBroken() {
        super.onBlockBroken();
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
        super.addUpgrade(upgrade);
        if (upgrade == WorksiteUpgrade.BASIC_CHUNK_LOADER || upgrade == WorksiteUpgrade.QUARRY_CHUNK_LOADER) {
            this.setupInitialTicket();
        }
    }

    @Override
    public final void removeUpgrade(WorksiteUpgrade upgrade) {
        super.removeUpgrade(upgrade);
        if (upgrade == WorksiteUpgrade.BASIC_CHUNK_LOADER || upgrade == WorksiteUpgrade.QUARRY_CHUNK_LOADER) {
            this.setTicket(null);
        }
    }

    @Override
    public final boolean hasWorkBounds() {
        return this.getWorkBoundsMin() != null && this.getWorkBoundsMax() != null;
    }

    @Override
    public final BlockPosition getWorkBoundsMin() {
        return this.bbMin;
    }

    @Override
    public final BlockPosition getWorkBoundsMax() {
        return this.bbMax;
    }

    @Override
    public final void setBounds(BlockPosition min, BlockPosition max) {
        this.setWorkBoundsMin(BlockTools.getMin(min, max));
        this.setWorkBoundsMax(BlockTools.getMax(min, max));
        this.onBoundsSet();
    }

    @Override
    public int getBoundsMaxWidth() {
        return this.getUpgrades().contains((Object)WorksiteUpgrade.SIZE_LARGE) ? 16 : (this.getUpgrades().contains((Object)WorksiteUpgrade.SIZE_MEDIUM) ? 9 : 5);
    }

    @Override
    public int getBoundsMaxHeight() {
        return 1;
    }

    @Override
    public final void setTicket(ForgeChunkManager.Ticket tk) {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
        this.chunkTicket = tk;
        if (this.chunkTicket == null) {
            return;
        }
        AWChunkLoader.INSTANCE.writeDataToTicket(this.chunkTicket, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ChunkCoordIntPair ccip = new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)ccip);
        if (this.hasWorkBounds()) {
            int minX = this.getWorkBoundsMin().x >> 4;
            int minZ = this.getWorkBoundsMin().z >> 4;
            int maxX = this.getWorkBoundsMax().x >> 4;
            int maxZ = this.getWorkBoundsMax().z >> 4;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ccip = new ChunkCoordIntPair(x, z);
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)ccip);
                }
            }
        }
    }

    public final void setupInitialTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        if (this.getUpgrades().contains((Object)WorksiteUpgrade.BASIC_CHUNK_LOADER) || this.getUpgrades().contains((Object)WorksiteUpgrade.QUARRY_CHUNK_LOADER)) {
            this.setTicket(ForgeChunkManager.requestTicket((Object)AncientWarfareAutomation.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL));
        }
    }

    protected void onBoundsSet() {
    }

    @Override
    public void onBoundsAdjusted() {
    }

    @Override
    public void onPostBoundsAdjusted() {
        this.setupInitialTicket();
    }

    public boolean isInBounds(BlockPosition pos) {
        return pos.x >= this.bbMin.x && pos.x <= this.bbMax.x && pos.z >= this.bbMin.z && pos.z <= this.bbMax.z;
    }

    protected void validateCollection(Collection<BlockPosition> blocks) {
        BlockPosition pos;
        if (!this.hasWorkBounds()) {
            blocks.clear();
            return;
        }
        Iterator<BlockPosition> it = blocks.iterator();
        while (it.hasNext() && (pos = it.next()) != null) {
            if (this.isInBounds(pos)) continue;
            it.remove();
        }
    }

    @Override
    public final void setWorkBoundsMin(BlockPosition min) {
        if (min != this.bbMin) {
            this.bbMin = min;
            this.func_70296_d();
        }
    }

    @Override
    public final void setWorkBoundsMax(BlockPosition max) {
        if (max != this.bbMax) {
            this.bbMax = max;
            this.func_70296_d();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.hasWorkBounds()) {
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            BlockPosition min = this.getWorkBoundsMin();
            bb.field_72340_a = (double)min.x < bb.field_72340_a ? (double)min.x : bb.field_72340_a;
            bb.field_72338_b = (double)min.y < bb.field_72338_b ? (double)min.y : bb.field_72338_b;
            bb.field_72339_c = (double)min.z < bb.field_72339_c ? (double)min.z : bb.field_72339_c;
            BlockPosition max = this.getWorkBoundsMax();
            bb.field_72336_d = (double)(max.x + 1) > bb.field_72336_d ? (double)(max.x + 1) : bb.field_72336_d;
            bb.field_72337_e = (double)(max.y + 1) > bb.field_72337_e ? (double)(max.y + 1) : bb.field_72337_e;
            bb.field_72334_f = (double)(max.z + 1) > bb.field_72334_f ? (double)(max.z + 1) : bb.field_72334_f;
            return bb;
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("bbMin")) {
            this.bbMin = new BlockPosition(tag.func_74775_l("bbMin"));
        }
        if (tag.func_74764_b("bbMax")) {
            this.bbMax = new BlockPosition(tag.func_74775_l("bbMax"));
        }
        if (this.bbMax == null) {
            this.setWorkBoundsMax(new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1));
        }
        if (this.bbMin == null) {
            this.setWorkBoundsMin(new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.bbMin != null) {
            tag.func_74782_a("bbMin", (NBTBase)this.bbMin.writeToNBT(new NBTTagCompound()));
        }
        if (this.bbMax != null) {
            tag.func_74782_a("bbMax", (NBTBase)this.bbMax.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound tag) {
        super.getDescriptionPacketTag(tag);
        if (this.bbMin != null) {
            tag.func_74782_a("bbMin", (NBTBase)this.bbMin.writeToNBT(new NBTTagCompound()));
        }
        if (this.bbMax != null) {
            tag.func_74782_a("bbMax", (NBTBase)this.bbMax.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    @Override
    public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        if (tag.func_74764_b("bbMin")) {
            this.bbMin = new BlockPosition(tag.func_74775_l("bbMin"));
        }
        if (tag.func_74764_b("bbMax")) {
            this.bbMax = new BlockPosition(tag.func_74775_l("bbMax"));
        }
    }
}

