/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileFlywheelStorage;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public abstract class TileFlywheelControl
extends TileTorqueSingleCell {
    private boolean powered;
    private final ITorque.TorqueCell inputCell;

    public TileFlywheelControl() {
        double max = this.getMaxTransfer();
        double eff = this.getEfficiency();
        this.inputCell = new ITorque.TorqueCell(max, max, max, eff);
        this.torqueCell = new ITorque.TorqueCell(max, max, max, eff);
    }

    protected abstract double getEfficiency();

    protected abstract double getMaxTransfer();

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.torqueCell.getEnergy() - this.prevEnergy;
            this.torqueLoss = this.applyPowerDrain(this.torqueCell);
            this.torqueLoss += this.applyPowerDrain(this.inputCell);
            this.torqueLoss += this.applyDrainToStorage();
            this.torqueOut = this.transferPowerTo(this.getPrimaryFacing());
            this.balancePower();
            this.prevEnergy = this.torqueCell.getEnergy();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    protected double applyDrainToStorage() {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        if (storage == null) {
            return 0.0;
        }
        return storage.torqueLoss;
    }

    protected void balancePower() {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        double in = this.inputCell.getEnergy();
        double out = this.torqueCell.getEnergy();
        double transfer = this.torqueCell.getMaxEnergy() - out;
        transfer = Math.min(in, transfer);
        in -= transfer;
        out += transfer;
        if (storage != null) {
            double store = storage.storedEnergy;
            transfer = Math.min(store, this.torqueCell.getMaxEnergy() - out);
            store -= transfer;
            out += transfer;
            transfer = Math.min(in, storage.maxEnergyStored - store);
            in -= transfer;
            storage.storedEnergy = store += transfer;
            this.torqueLoss += storage.torqueLoss;
        }
        this.torqueCell.setEnergy(out);
        this.inputCell.setEnergy(in);
    }

    @Override
    protected void updateRotation() {
        this.prevRotation = this.rotation;
        if (!this.powered) {
            super.updateRotation();
        }
    }

    public TileFlywheelStorage getControlledFlywheel() {
        int x = this.field_145851_c;
        int y = this.field_145848_d - 1;
        int z = this.field_145849_e;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileFlywheelStorage) {
            TileFlywheelStorage fs = (TileFlywheelStorage)te;
            if (fs.controllerPos != null && (te = this.field_145850_b.func_147438_o(x = fs.controllerPos.x, y = fs.controllerPos.y, z = fs.controllerPos.z)) instanceof TileFlywheelStorage) {
                return (TileFlywheelStorage)te;
            }
        }
        return null;
    }

    public float getFlywheelRotation(float delta) {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        return storage == null ? 0.0f : this.getRotation(storage.rotation, storage.prevRotation, delta);
    }

    protected double getFlywheelEnergy() {
        TileFlywheelStorage storage = this.getControlledFlywheel();
        return storage == null ? 0.0 : storage.storedEnergy;
    }

    @Override
    protected double getTotalTorque() {
        return this.inputCell.getEnergy() + this.torqueCell.getEnergy() + this.getFlywheelEnergy();
    }

    @Override
    public void onNeighborTileChanged() {
        super.onNeighborTileChanged();
        if (!this.field_145850_b.field_72995_K) {
            boolean p;
            boolean bl = p = this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
            if (p != this.powered) {
                this.powered = p;
                this.sendDataToClient(7, this.powered ? 1 : 0);
            }
        }
    }

    @Override
    public boolean func_145842_c(int a, int b) {
        if (this.field_145850_b.field_72995_K && a == 7) {
            this.powered = b == 1;
        }
        return super.func_145842_c(a, b);
    }

    @Override
    public double getMaxTorqueOutput(ForgeDirection from) {
        if (this.powered) {
            return 0.0;
        }
        return this.torqueCell.getMaxTickOutput();
    }

    @Override
    public double getMaxTorque(ForgeDirection from) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.getMaxEnergy();
    }

    @Override
    public double getTorqueStored(ForgeDirection from) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.getEnergy();
    }

    @Override
    public double addTorque(ForgeDirection from, double energy) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.addEnergy(energy);
    }

    @Override
    public double drainTorque(ForgeDirection from, double energy) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.drainEnergy(energy);
    }

    @Override
    public double getMaxTorqueInput(ForgeDirection from) {
        ITorque.TorqueCell cell = this.getCell(from);
        return cell == null ? 0.0 : cell.getMaxTickInput();
    }

    private ITorque.TorqueCell getCell(ForgeDirection from) {
        if (from == this.orientation) {
            return this.torqueCell;
        }
        if (from == this.orientation.getOpposite()) {
            return this.inputCell;
        }
        return null;
    }

    @Override
    public NBTTagCompound getDescriptionTag() {
        NBTTagCompound tag = super.getDescriptionTag();
        tag.func_74757_a("powered", this.powered);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.powered = tag.func_74767_n("powered");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("powered", this.powered);
        tag.func_74780_a("torqueEnergyIn", this.inputCell.getEnergy());
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.powered = tag.func_74767_n("powered");
        this.inputCell.setEnergy(tag.func_74769_h("torqueEnergyIn"));
    }
}

