/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileWindmillBlade;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public class RenderWindmillBlades
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private final ResourceLocation texture;
    private final ResourceLocation cubeTexture;
    private final ModelBaseAW model;
    private final ModelBaseAW cube;
    private final ModelPiece windmillShaft;
    private final ModelPiece blade;
    private final ModelPiece bladeJoint;
    private final ModelPiece bladeShaft;

    public RenderWindmillBlades() {
        ModelLoader loader = new ModelLoader();
        this.model = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/windmill_blade.m2f"));
        this.cube = loader.loadModel(((Object)((Object)this)).getClass().getResourceAsStream("/assets/ancientwarfare/models/automation/cube.m2f"));
        this.windmillShaft = this.model.getPiece("windmillShaft");
        this.blade = this.model.getPiece("blade");
        this.bladeJoint = this.model.getPiece("bladeJoint");
        this.bladeShaft = this.model.getPiece("bladeShaft");
        this.texture = new ResourceLocation("ancientwarfare", "textures/model/automation/windmill_blade.png");
        this.cubeTexture = new ResourceLocation("ancientwarfare", "textures/model/automation/windmill_blade_block.png");
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float delta) {
        TileWindmillBlade blade = (TileWindmillBlade)te;
        if (blade.isControl) {
            GL11.glPushMatrix();
            this.func_147499_a(this.texture);
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            this.renderModel(-blade.getRotation(delta), blade.windmillDirection, (blade.windmillSize - 1) / 2);
            GL11.glPopMatrix();
        } else if (blade.controlPos == null) {
            GL11.glPushMatrix();
            this.func_147499_a(this.cubeTexture);
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            this.cube.renderModel();
            GL11.glPopMatrix();
        }
    }

    protected void renderModel(float bladeRotatation, int face, int height) {
        float[] rot = ITorque.forgeDiretctionToRotationMatrix[face];
        if (rot[0] != 0.0f) {
            GL11.glRotatef((float)rot[0], (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (rot[1] != 0.0f) {
            GL11.glRotatef((float)rot[1], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        float textureWidth = this.model.textureWidth();
        float textureHeight = this.model.textureHeight();
        GL11.glRotatef((float)bladeRotatation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.windmillShaft.render(this.model.textureWidth(), this.model.textureHeight());
        for (int i = 0; i < 4; ++i) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.bladeShaft.render(textureWidth, textureHeight);
            for (int k = 1; k < height; ++k) {
                this.blade.render(textureWidth, textureHeight);
                if (k == height - 1) {
                    this.bladeJoint.render(textureWidth, textureHeight);
                    continue;
                }
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)(2 - height), (float)0.0f);
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        this.func_147499_a(this.texture);
        GL11.glTranslatef((float)0.5f, (float)-0.25f, (float)0.5f);
        GL11.glEnable((int)32826);
        GL11.glScalef((float)0.35f, (float)0.35f, (float)0.35f);
        float textureWidth = this.model.textureWidth();
        float textureHeight = this.model.textureHeight();
        this.windmillShaft.setRotation(0.0f, 0.0f, 0.0f);
        this.windmillShaft.render(textureWidth, textureHeight);
        int height = 5;
        this.bladeShaft.render(textureWidth, textureHeight);
        for (int k = 1; k < height; ++k) {
            this.blade.render(textureWidth, textureHeight);
            if (k == height - 1) {
                this.bladeJoint.render(textureWidth, textureHeight);
                continue;
            }
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

