/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;

public class ContainerWorksiteInventorySideSelection
extends ContainerTileBase<TileWorksiteBoundedInventory> {
    public final HashMap<BlockRotationHandler.RelativeSide, BlockRotationHandler.RelativeSide> sideMap = new HashMap();

    public ContainerWorksiteInventorySideSelection(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        BlockRotationHandler.InventorySided inventory = ((TileWorksiteBoundedInventory)this.tileEntity).inventory;
        for (BlockRotationHandler.RelativeSide rSide : inventory.rType.getValidSides()) {
            this.sideMap.put(rSide, inventory.getRemappedSide(rSide));
        }
    }

    @Override
    public void sendInitData() {
        this.sendAccessMap();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        this.handleAccessMapTag(tag);
        if (tag.func_74764_b("closeGUI")) {
            ((TileWorksiteBoundedInventory)this.tileEntity).onBlockClicked(this.player);
        }
        this.refreshGui();
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.synchAccessMap();
    }

    private void handleAccessMapTag(NBTTagCompound tag) {
        if (tag.func_74764_b("accessMap")) {
            NBTTagCompound accessTag = tag.func_74775_l("accessMap");
            int[] rMap = accessTag.func_74759_k("rMap");
            int[] rMap2 = accessTag.func_74759_k("iMap");
            for (int i = 0; i < rMap.length && i < rMap2.length; ++i) {
                BlockRotationHandler.RelativeSide rSide = BlockRotationHandler.RelativeSide.values()[rMap[i]];
                BlockRotationHandler.RelativeSide iSide = BlockRotationHandler.RelativeSide.values()[rMap2[i]];
                this.sideMap.put(rSide, iSide);
            }
        } else if (tag.func_74764_b("accessChange")) {
            NBTTagCompound slotTag = tag.func_74775_l("accessChange");
            BlockRotationHandler.RelativeSide base = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e("baseSide")];
            BlockRotationHandler.RelativeSide access = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e("accessSide")];
            this.sideMap.put(base, access);
            if (!this.player.field_70170_p.field_72995_K) {
                ((TileWorksiteBoundedInventory)this.tileEntity).inventory.remapSideAccess(base, access);
            }
        }
    }

    private void sendAccessMap() {
        int l = this.sideMap.size();
        int[] rMap = new int[l];
        int[] iMap = new int[l];
        int index = 0;
        for (BlockRotationHandler.RelativeSide rSide : this.sideMap.keySet()) {
            rMap[index] = rSide.ordinal();
            iMap[index] = this.sideMap.get((Object)rSide).ordinal();
            ++index;
        }
        NBTTagCompound accessTag = new NBTTagCompound();
        accessTag.func_74783_a("rMap", rMap);
        accessTag.func_74783_a("iMap", iMap);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("accessMap", (NBTBase)accessTag);
        this.sendDataToClient(tag);
    }

    private void synchAccessMap() {
        for (BlockRotationHandler.RelativeSide rSide : ((TileWorksiteBoundedInventory)this.tileEntity).inventory.rType.getValidSides()) {
            BlockRotationHandler.RelativeSide rSide3;
            BlockRotationHandler.RelativeSide rSide2 = ((TileWorksiteBoundedInventory)this.tileEntity).inventory.getRemappedSide(rSide);
            if (rSide2 == (rSide3 = this.sideMap.get((Object)rSide))) continue;
            this.sideMap.put(rSide, rSide2);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74768_a("baseSide", rSide.ordinal());
            slotTag.func_74768_a("accessSide", rSide2.ordinal());
            tag.func_74782_a("accessChange", (NBTBase)slotTag);
            this.sendDataToClient(tag);
        }
    }

    public void sendSlotChange(BlockRotationHandler.RelativeSide base, BlockRotationHandler.RelativeSide access) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound slotTag = new NBTTagCompound();
        slotTag.func_74768_a("baseSide", base.ordinal());
        slotTag.func_74768_a("accessSide", access.ordinal());
        tag.func_74782_a("accessChange", (NBTBase)slotTag);
        this.sendDataToServer(tag);
    }

    public void close() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("closeGUI", true);
        this.sendDataToServer(tag);
    }
}

