/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.item.AWAutomationItemLoader;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.block.IconRotationMap;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class BlockWorksiteBase
extends Block
implements BlockRotationHandler.IRotatableBlock {
    IconRotationMap iconMap = new IconRotationMap();
    public int maxWorkSize = 16;
    public int maxWorkSizeVertical = 1;
    private Constructor<? extends TileEntity> tile;

    public BlockWorksiteBase(String regName) {
        super(Material.field_151576_e);
        this.func_149647_a(AWAutomationItemLoader.automationTab);
        this.func_149663_c(regName);
        this.func_149711_c(2.0f);
    }

    @Override
    public BlockWorksiteBase setIcon(BlockRotationHandler.RelativeSide relativeSide, String texName) {
        this.iconMap.setIcon(this, relativeSide, texName);
        return this;
    }

    public BlockWorksiteBase setWorkSize(int size) {
        this.maxWorkSize = size;
        return this;
    }

    public BlockWorksiteBase setWorkVerticalSize(int size) {
        this.maxWorkSizeVertical = size;
        return this;
    }

    public BlockWorksiteBase setTileEntity(Class<? extends TileEntity> clzz) {
        try {
            this.tile = clzz.getConstructor(new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        try {
            return this.tile.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.tile != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.iconMap.registerIcons(p_149651_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconMap.getIcon(this, meta, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof BlockRotationHandler.IRotatableTile) {
            return this.func_149691_a(side, ((BlockRotationHandler.IRotatableTile)te).getPrimaryFacing().ordinal());
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInteractableTile) {
            boolean canClick = false;
            if (te instanceof IOwnable && ((IOwnable)te).isOwner(player)) {
                canClick = true;
            } else if (te instanceof IWorkSite) {
                Team t1 = ((IWorkSite)te).getTeam();
                if (player.func_96124_cp() == t1) {
                    canClick = true;
                }
            }
            if (canClick) {
                return ((IInteractableTile)te).onBlockClicked(player);
            }
        }
        return false;
    }

    @Override
    public final BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    public final boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileEntity te;
        if ((axis == ForgeDirection.DOWN || axis == ForgeDirection.UP) && (te = worldObj.func_147438_o(x, y, z)) instanceof BlockRotationHandler.IRotatableTile) {
            if (!worldObj.field_72995_K) {
                ForgeDirection o = ((BlockRotationHandler.IRotatableTile)te).getPrimaryFacing().getRotation(axis);
                ((BlockRotationHandler.IRotatableTile)te).setPrimaryFacing(o);
            }
            return true;
        }
        return false;
    }

    public final ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP};
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            InventoryTools.dropInventoryInWorld(world, (IInventory)te, x, y, z);
        }
        if (te instanceof IWorkSite) {
            ((IWorkSite)te).onBlockBroken();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

