/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.item.AWAutomationItemLoader;
import net.shadowmage.ancientwarfare.automation.tile.TileMailbox;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.block.IconRotationMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class BlockMailbox
extends Block
implements BlockRotationHandler.IRotatableBlock {
    IconRotationMap iconMap = new IconRotationMap();

    public BlockMailbox(String regName) {
        super(Material.field_151576_e);
        this.func_149663_c(regName);
        this.func_149647_a(AWAutomationItemLoader.automationTab);
        this.func_149711_c(2.0f);
        String icon = "ancientwarfare:automation/" + regName;
        this.setIcon(BlockRotationHandler.RelativeSide.TOP, icon);
        this.setIcon(BlockRotationHandler.RelativeSide.FRONT, icon);
        this.setIcon(BlockRotationHandler.RelativeSide.REAR, icon);
        this.setIcon(BlockRotationHandler.RelativeSide.BOTTOM, icon);
        this.setIcon(BlockRotationHandler.RelativeSide.LEFT, icon);
        this.setIcon(BlockRotationHandler.RelativeSide.RIGHT, icon);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileMailbox();
    }

    @Override
    public BlockMailbox setIcon(BlockRotationHandler.RelativeSide relativeSide, String texName) {
        this.iconMap.setIcon(this, relativeSide, texName + "_" + (Object)((Object)relativeSide));
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.iconMap.registerIcons(p_149651_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconMap.getIcon(this, meta, side);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 17, x, y, z);
        }
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        int meta = worldObj.func_72805_g(x, y, z);
        int rMeta = BlockRotationHandler.getRotatedMeta(this, meta, axis);
        if (rMeta != meta) {
            worldObj.func_72921_c(x, y, z, rMeta, 3);
            return true;
        }
        return false;
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            InventoryTools.dropInventoryInWorld(world, (IInventory)te, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

