/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.CraneRegistry;
import openblocks.common.entity.EntityMagnet;
import openblocks.common.item.ItemCraneBackpack;
import openmods.OpenMods;

public class ItemCraneControl
extends Item {
    private IIcon iconDown;
    private IIcon iconUp;
    private IIcon iconLocked;
    private IIcon iconDetected;
    private static final Map<EntityLivingBase, Long> debouncerTime = new MapMaker().weakKeys().makeMap();

    public ItemCraneControl() {
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77625_d(1);
    }

    private static boolean hasClicked(EntityLivingBase entity) {
        long currentTime = OpenMods.proxy.getTicks(entity.field_70170_p);
        Long lastClick = debouncerTime.get(entity);
        if (lastClick == null || currentTime - lastClick > 5L) {
            debouncerTime.put(entity, currentTime);
            return true;
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        EntityPlayer player;
        EntityMagnet magnet;
        if (entityLiving instanceof EntityPlayer && ItemCraneControl.hasClicked(entityLiving) && (magnet = CraneRegistry.instance.getMagnetForPlayer(player = (EntityPlayer)entityLiving)) != null) {
            magnet.toggleMagnet();
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        CraneRegistry.Data data = CraneRegistry.instance.getData(player, false);
        if (data != null) {
            data.isExtending = Config.craneShiftControl ? player.func_70093_af() : !data.isExtending;
        }
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (player instanceof EntityPlayerMP && ItemCraneBackpack.isWearingCrane(player)) {
            CraneRegistry.Data data = CraneRegistry.instance.getData(player, true);
            data.updateLength();
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.field_77791_bV = registry.func_94245_a("openblocks:manipulator_idle");
        this.iconLocked = registry.func_94245_a("openblocks:manipulator_locked");
        this.iconDetected = registry.func_94245_a("openblocks:manipulator_detected");
        this.iconDown = registry.func_94245_a("openblocks:manipulator_down");
        this.iconUp = registry.func_94245_a("openblocks:manipulator_up");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        CraneRegistry.Data data;
        if (player != null && ItemCraneBackpack.isWearingCrane(player) && (data = CraneRegistry.instance.getData(player, false)) != null) {
            if (usingItem == stack) {
                return data.isExtending ? this.iconDown : this.iconUp;
            }
            EntityMagnet magnet = CraneRegistry.instance.getMagnetForPlayer(player);
            if (magnet != null) {
                if (magnet.isLocked()) {
                    return this.iconLocked;
                }
                if (magnet.isAboveTarget()) {
                    return this.iconDetected;
                }
            }
        }
        return this.field_77791_bV;
    }

    public boolean func_150897_b(Block block) {
        return false;
    }
}

