/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import openblocks.common.item.ItemHangGlider;
import openmods.Log;

public class EntityHangGlider
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int PROPERTY_ON_GROUND = 17;
    private static Map<EntityPlayer, EntityHangGlider> gliderMap = new MapMaker().weakKeys().weakValues().makeMap();
    private EntityPlayer player;

    public static boolean isEntityHoldingGlider(Entity player) {
        EntityHangGlider glider = gliderMap.get(player);
        return glider != null;
    }

    public static boolean isPlayerOnGround(Entity player) {
        EntityHangGlider glider = gliderMap.get(player);
        return glider == null || glider.isPlayerOnGround();
    }

    private static boolean isGliderValid(EntityPlayer player, EntityHangGlider glider) {
        if (player == null || player.field_70128_L || glider == null || glider.field_70128_L) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null || !(held.func_77973_b() instanceof ItemHangGlider)) {
            return false;
        }
        return player.field_70170_p.field_73011_w.field_76574_g == glider.field_70170_p.field_73011_w.field_76574_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateGliders(World worldObj) {
        for (Map.Entry<EntityPlayer, EntityHangGlider> e : gliderMap.entrySet()) {
            EntityHangGlider glider;
            EntityPlayer player = e.getKey();
            if (EntityHangGlider.isGliderValid(player, glider = e.getValue())) {
                glider.fixPositions(player, player instanceof EntityPlayerSP);
                continue;
            }
            glider.func_70106_y();
        }
    }

    public EntityHangGlider(World world) {
        super(world);
    }

    public EntityHangGlider(World world, EntityPlayer player) {
        this(world);
        this.player = player;
    }

    public void readSpawnData(ByteBuf data) {
        int playerId = data.readInt();
        Entity e = this.field_70170_p.func_73045_a(playerId);
        if (e instanceof EntityPlayer) {
            this.player = (EntityPlayer)e;
            gliderMap.put(this.player, this);
        } else {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.player == null) {
            Log.warn((String)"Got glider without player id (%s)", (Object[])new Object[]{this});
            data.writeInt(-42);
        } else {
            data.writeInt(this.player.func_145782_y());
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)1);
    }

    public boolean isPlayerOnGround() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public void func_70071_h_() {
        if (!EntityHangGlider.isGliderValid(this.player, this)) {
            this.func_70106_y();
        }
        if (this.field_70128_L) {
            gliderMap.remove(this.player);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(17, (Object)((byte)(this.player.field_70122_E ? 1 : 0)));
            this.fixPositions(this.player, false);
        }
        double horizontalSpeed = 0.03;
        double verticalSpeed = 0.4;
        if (this.player.func_70093_af()) {
            horizontalSpeed = 0.1;
            verticalSpeed = 0.7;
        }
        if (!this.player.field_70122_E && this.player.field_70181_x < 0.0) {
            this.player.field_70181_x *= verticalSpeed;
            this.field_70181_x *= verticalSpeed;
            double x = Math.cos(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
            double z = Math.sin(Math.toRadians(this.player.field_70759_as + 90.0f)) * horizontalSpeed;
            this.player.field_70159_w += x;
            this.player.field_70179_y += z;
            this.player.field_70143_R = 0.0f;
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void func_70106_y() {
        super.func_70106_y();
        gliderMap.remove(this.player);
    }

    private void fixPositions(EntityPlayer thePlayer, boolean localPlayer) {
        this.field_70142_S = this.field_70169_q = this.player.field_70169_q;
        this.field_70137_T = this.field_70167_r = this.player.field_70167_r;
        this.field_70136_U = this.field_70166_s = this.player.field_70166_s;
        this.field_70165_t = this.player.field_70165_t;
        this.field_70163_u = this.player.field_70163_u;
        this.field_70161_v = this.player.field_70161_v;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70126_B = this.player.field_70760_ar;
        this.field_70177_z = this.player.field_70761_aq;
        this.field_70127_C = this.player.field_70127_C;
        this.field_70125_A = this.player.field_70125_A;
        if (!localPlayer) {
            this.field_70163_u += 1.2;
            this.field_70167_r += 1.2;
            this.field_70137_T += 1.2;
        }
        this.field_70159_w = this.field_70165_t - this.field_70169_q;
        this.field_70181_x = this.field_70163_u - this.field_70167_r;
        this.field_70179_y = this.field_70161_v - this.field_70166_s;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public boolean func_70039_c(NBTTagCompound p_70039_1_) {
        return false;
    }
}

