/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.inventory.Container;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openblocks.OpenBlocks;
import openblocks.client.ChangelogBuilder;
import openblocks.client.gui.ChangelogPage;
import openblocks.client.gui.page.IntroPage;
import openblocks.common.PlayerInventoryStore;
import openmods.Log;
import openmods.gui.ComponentGui;
import openmods.gui.DummyContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.page.PageBase;
import openmods.gui.component.page.SectionPage;
import openmods.gui.component.page.TitledPage;
import openmods.infobook.PageBuilder;
import org.lwjgl.opengl.GL11;

public class GuiInfoBook
extends ComponentGui
implements GuiYesNoCallback {
    public GuiInfoBook() {
        super((Container)new DummyContainer(), 0, 0);
    }

    private static void setupBookmark(GuiComponentLabel label, GuiComponentBook book, int index) {
        label.setListener(book.createBookmarkListener(index));
    }

    private static int alignToEven(GuiComponentBook book) {
        int index = book.getNumberOfPages();
        if (index % 2 == 1) {
            book.addPage((BaseComponent)PageBase.BLANK_PAGE);
            ++index;
        }
        return index;
    }

    private static int tocLine(int index) {
        int tocStartHeight = 80;
        int tocLineHeight = 15;
        return 80 + index * 15;
    }

    protected BaseComposite createRoot() {
        GuiComponentBook book = new GuiComponentBook();
        TitledPage contentsPage = new TitledPage("openblocks.gui.welcome.title", "openblocks.gui.welcome.content");
        GuiComponentLabel lblBlocks = new GuiComponentLabel(27, GuiInfoBook.tocLine(0), "- " + StatCollector.func_74838_a((String)"openblocks.gui.blocks"));
        contentsPage.addComponent((BaseComponent)lblBlocks);
        GuiComponentLabel lblItems = new GuiComponentLabel(27, GuiInfoBook.tocLine(1), "- " + StatCollector.func_74838_a((String)"openblocks.gui.items"));
        contentsPage.addComponent((BaseComponent)lblItems);
        GuiComponentLabel lblMisc = new GuiComponentLabel(27, GuiInfoBook.tocLine(2), "- " + StatCollector.func_74838_a((String)"openblocks.gui.misc"));
        contentsPage.addComponent((BaseComponent)lblMisc);
        GuiComponentLabel lblChangelogs = new GuiComponentLabel(27, GuiInfoBook.tocLine(3), "- " + StatCollector.func_74838_a((String)"openblocks.gui.changelogs"));
        contentsPage.addComponent((BaseComponent)lblChangelogs);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new IntroPage());
        book.addPage((BaseComponent)new TitledPage("openblocks.gui.credits.title", "openblocks.gui.credits.content"));
        book.addPage((BaseComponent)contentsPage);
        PageBuilder builder = new PageBuilder();
        int blocksIndex = GuiInfoBook.alignToEven(book);
        GuiInfoBook.setupBookmark(lblBlocks, book, blocksIndex);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.blocks"));
        builder.addBlockPages("OpenBlocks");
        builder.addPages(book);
        int itemsIndex = GuiInfoBook.alignToEven(book);
        GuiInfoBook.setupBookmark(lblItems, book, itemsIndex);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.items"));
        builder.addItemPages("OpenBlocks");
        builder.addPages(book);
        int miscIndex = GuiInfoBook.alignToEven(book);
        GuiInfoBook.setupBookmark(lblMisc, book, miscIndex);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.misc"));
        book.addPage((BaseComponent)new TitledPage("openblocks.gui.config.title", "openblocks.gui.config.content"));
        book.addPage((BaseComponent)new TitledPage("openblocks.gui.restore_inv.title", "openblocks.gui.restore_inv.content").addActionButton(25, 146, GuiInfoBook.getSavePath(), PageBase.ActionIcon.FOLDER.icon, "openblocks.gui.save_folder"));
        book.addPage((BaseComponent)new TitledPage("openblocks.gui.bkey.title", "openblocks.gui.bkey.content"));
        if (OpenBlocks.Enchantments.explosive != null) {
            book.addPage((BaseComponent)new TitledPage("openblocks.gui.unstable.title", "openblocks.gui.unstable.content"));
        }
        if (OpenBlocks.Enchantments.lastStand != null) {
            book.addPage((BaseComponent)new TitledPage("openblocks.gui.laststand.title", "openblocks.gui.laststand.content"));
        }
        if (OpenBlocks.Enchantments.flimFlam != null) {
            book.addPage((BaseComponent)new TitledPage("openblocks.gui.flimflam.title", "openblocks.gui.flimflam.content"));
        }
        int changelogsIndex = GuiInfoBook.alignToEven(book);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        GuiInfoBook.setupBookmark(lblChangelogs, book, changelogsIndex);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.changelogs"));
        GuiInfoBook.createChangelogPages(book);
        book.enablePages();
        this.field_146999_f = book.getWidth();
        this.field_147000_g = book.getHeight();
        return book;
    }

    private static File getSavePath() {
        try {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server != null) {
                WorldServer world = server.func_71218_a(0);
                File saveFolder = PlayerInventoryStore.getSaveFolder((World)world);
                return saveFolder;
            }
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to get save folder from local server", (Object[])new Object[0]);
        }
        try {
            return Minecraft.func_71410_x().field_71412_D;
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to get save folder from MC data dir", (Object[])new Object[0]);
            return new File("invalid.path");
        }
    }

    private static void createChangelogPages(GuiComponentBook book) {
        String prevVersion = null;
        int prevIndex = 0;
        ArrayList prevPages = Lists.newArrayList();
        List<ChangelogBuilder.Changelog> changelogs = ChangelogBuilder.readChangeLogs();
        for (int i = 0; i < changelogs.size(); ++i) {
            ChangelogBuilder.Changelog changelog = changelogs.get(i);
            String currentVersion = changelog.version;
            int currentPage = book.getNumberOfPages();
            for (ChangelogPage prevPage : prevPages) {
                prevPage.addNextVersionBookmark(book, currentVersion, currentPage);
            }
            prevPages.clear();
            for (ChangelogBuilder.ChangelogSection section : changelog.sections) {
                ChangelogPage page = new ChangelogPage(currentVersion, section.title, section.lines);
                book.addPage((BaseComponent)page);
                prevPages.add(page);
                if (i <= 0) continue;
                page.addPrevVersionBookmark(book, prevVersion, prevIndex);
            }
            GuiInfoBook.alignToEven(book);
            prevVersion = currentVersion;
            prevIndex = currentPage;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.prepareRenderState();
        GL11.glPushMatrix();
        this.root.renderOverlay(this.field_146297_k, this.field_147003_i, this.field_147009_r, par1 - this.field_147003_i, par2 - this.field_147009_r);
        GL11.glPopMatrix();
        this.restoreRenderState();
    }
}

