/*
 * Decompiled with CFR 0.152.
 */
package openblocks;

import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import openblocks.client.gui.GuiDevNull;
import openblocks.client.gui.GuiInfoBook;
import openblocks.client.gui.GuiLuggage;
import openblocks.common.container.ContainerDevNull;
import openblocks.common.container.ContainerLuggage;
import openblocks.common.entity.EntityLuggage;
import openmods.Log;
import openmods.gui.DummyContainer;
import openmods.inventory.PlayerItemInventory;

public class OpenBlocksGuiHandler
implements IGuiHandler {
    private static ContainerDevNull createDevNullContainer(EntityPlayer player) {
        return new ContainerDevNull((IInventory)player.field_71071_by, (IInventory)new PlayerItemInventory(player, 1));
    }

    private static ContainerLuggage createLuggageContainer(EntityPlayer player, World world, int entityId) {
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof EntityLuggage) {
            return new ContainerLuggage((IInventory)player.field_71071_by, (EntityLuggage)entity);
        }
        Log.warn((String)"Trying to open luggage container for invalid entity %d:%s", (Object[])new Object[]{entityId, entity});
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        GuiId guiId = OpenBlocksGuiHandler.getGuiId(id);
        if (guiId == null) {
            return null;
        }
        switch (guiId) {
            case luggage: {
                return OpenBlocksGuiHandler.createLuggageContainer(player, world, x);
            }
            case devNull: {
                if (player.field_71071_by.func_70448_g() == null) {
                    return null;
                }
                return OpenBlocksGuiHandler.createDevNullContainer(player);
            }
            case infoBook: {
                return new DummyContainer();
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        GuiId guiId = OpenBlocksGuiHandler.getGuiId(id);
        if (guiId == null) {
            return null;
        }
        switch (guiId) {
            case luggage: {
                ContainerLuggage container = OpenBlocksGuiHandler.createLuggageContainer(player, world, x);
                return container != null ? new GuiLuggage(container) : null;
            }
            case infoBook: {
                return new GuiInfoBook();
            }
            case devNull: {
                return new GuiDevNull(OpenBlocksGuiHandler.createDevNullContainer(player));
            }
        }
        return null;
    }

    private static GuiId getGuiId(int id) {
        try {
            return GuiId.VALUES[id];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.warn((String)"Invalid GUI id: %d", (Object[])new Object[]{id});
            return null;
        }
    }

    public static enum GuiId {
        luggage,
        infoBook,
        devNull;

        public static final GuiId[] VALUES;

        static {
            VALUES = GuiId.values();
        }
    }
}

