/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.ComparableItem;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.api.crafting.recipes.IFurnaceRecipe;
import cofh.thermalfoundation.item.TFItems;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class FurnaceManager {
    private static Map<ComparableItemStackFurnace, RecipeFurnace> recipeMap = new THashMap();
    private static Set<ComparableItemStackFurnace> foodSet = new THashSet();
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 1600;
    private static Set<Block> handledBlocks = new THashSet();

    public static RecipeFurnace getRecipe(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ComparableItemStackFurnace comparableItemStackFurnace = new ComparableItemStackFurnace(itemStack);
        RecipeFurnace recipeFurnace = recipeMap.get((Object)comparableItemStackFurnace);
        if (recipeFurnace == null) {
            ((ComparableItem)comparableItemStackFurnace).metadata = Short.MAX_VALUE;
            recipeFurnace = recipeMap.get((Object)comparableItemStackFurnace);
        }
        return recipeFurnace;
    }

    public static boolean recipeExists(ItemStack itemStack) {
        return FurnaceManager.getRecipe(itemStack) != null;
    }

    public static RecipeFurnace[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeFurnace[0]);
    }

    public static boolean isFoodItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ComparableItemStackFurnace comparableItemStackFurnace = new ComparableItemStackFurnace(itemStack);
        if (foodSet.contains((Object)comparableItemStackFurnace)) {
            return true;
        }
        ((ComparableItem)comparableItemStackFurnace).metadata = Short.MAX_VALUE;
        return foodSet.contains((Object)comparableItemStackFurnace);
    }

    public static void addDefaultRecipes() {
        int n;
        FurnaceManager.addTERecipe(800, new ItemStack(Blocks.field_150434_aF), new ItemStack(Items.field_151100_aR, 1, 2));
        FurnaceManager.addTERecipe(3200, new ItemStack(Blocks.field_150407_cf), new ItemStack(Items.field_151044_h, 1, 1));
        FurnaceManager.addTERecipe(800, new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151157_am));
        FurnaceManager.addTERecipe(800, new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be));
        FurnaceManager.addTERecipe(800, new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151077_bg));
        FurnaceManager.addTERecipe(800, new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151168_bH));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151147_al)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151082_bd)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151076_bf)));
        foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151174_bG)));
        for (n = 0; n < 2; ++n) {
            FurnaceManager.addTERecipe(800, new ItemStack(Items.field_151115_aP, 1, n), new ItemStack(Items.field_151101_aQ, 1, n));
            foodSet.add(new ComparableItemStackFurnace(new ItemStack(Items.field_151115_aP, 1, n)));
        }
        n = 1600;
        FurnaceManager.addOreDictRecipe("oreIron", TFItems.ingotIron);
        FurnaceManager.addOreDictRecipe("oreGold", TFItems.ingotGold);
        FurnaceManager.addOreDictRecipe("oreCopper", TFItems.ingotCopper);
        FurnaceManager.addOreDictRecipe("oreTin", TFItems.ingotTin);
        FurnaceManager.addOreDictRecipe("oreSilver", TFItems.ingotSilver);
        FurnaceManager.addOreDictRecipe("oreLead", TFItems.ingotLead);
        FurnaceManager.addOreDictRecipe("oreNickel", TFItems.ingotNickel);
        FurnaceManager.addOreDictRecipe("orePlatinum", TFItems.ingotPlatinum);
        FurnaceManager.addOreDictRecipe("oreCoal", new ItemStack(Items.field_151044_h, 1, 0));
        FurnaceManager.addOreDictRecipe("oreDiamond", new ItemStack(Items.field_151045_i, 1, 0));
        FurnaceManager.addOreDictRecipe("oreEmerald", new ItemStack(Items.field_151166_bC, 1, 0));
        FurnaceManager.addOreDictRecipe("oreLapis", new ItemStack(Items.field_151100_aR, 6, 4));
        FurnaceManager.addOreDictRecipe("oreRedstone", new ItemStack(Items.field_151137_ax, 4, 0));
        FurnaceManager.addOreDictRecipe("oreQuartz", new ItemStack(Items.field_151128_bU, 1, 0));
        n = 1000;
        FurnaceManager.addOreDictRecipe(n, "dustIron", TFItems.ingotIron);
        FurnaceManager.addOreDictRecipe(n, "dustGold", TFItems.ingotGold);
        FurnaceManager.addOreDictRecipe(n, "dustCopper", TFItems.ingotCopper);
        FurnaceManager.addOreDictRecipe(n, "dustTin", TFItems.ingotTin);
        FurnaceManager.addOreDictRecipe(n, "dustSilver", TFItems.ingotSilver);
        FurnaceManager.addOreDictRecipe(n, "dustLead", TFItems.ingotLead);
        FurnaceManager.addOreDictRecipe(n, "dustNickel", TFItems.ingotNickel);
        FurnaceManager.addOreDictRecipe(n, "dustPlatinum", TFItems.ingotPlatinum);
        FurnaceManager.addOreDictRecipe(n, "dustElectrum", TFItems.ingotElectrum);
        FurnaceManager.addOreDictRecipe(n, "dustInvar", TFItems.ingotInvar);
        FurnaceManager.addOreDictRecipe(n, "dustBronze", TFItems.ingotBronze);
        n = 600;
        FurnaceManager.addOreDictRecipe(n, "oreberryIron", TFItems.nuggetIron);
        FurnaceManager.addOreDictRecipe(n, "oreberryGold", TFItems.nuggetGold);
        FurnaceManager.addOreDictRecipe(n, "oreberryCopper", TFItems.nuggetCopper);
        FurnaceManager.addOreDictRecipe(n, "oreberryTin", TFItems.nuggetTin);
        FurnaceManager.addOreDictRecipe(n, "oreberrySilver", TFItems.nuggetSilver);
        FurnaceManager.addOreDictRecipe(n, "oreberryLead", TFItems.nuggetLead);
        FurnaceManager.addOreDictRecipe(n, "oreberryNickel", TFItems.nuggetNickel);
        FurnaceManager.addOreDictRecipe(n, "oreberryPlatinum", TFItems.nuggetPlatinum);
    }

    public static void loadRecipes() {
        Map map = FurnaceRecipes.func_77602_a().func_77599_b();
        for (ItemStack itemStack : map.keySet()) {
            ItemStack itemStack2;
            if (itemStack == null || itemStack.func_77973_b() == null || FurnaceManager.recipeExists(itemStack) || (itemStack2 = (ItemStack)map.get(itemStack)) == null || handledBlocks.contains(Block.func_149634_a((Item)itemStack.func_77973_b()))) continue;
            int n = 1600;
            if (itemStack2.func_77973_b() instanceof ItemFood) {
                foodSet.add(new ComparableItemStackFurnace(itemStack));
                n /= 2;
            }
            if (ItemHelper.isDust((ItemStack)itemStack) && ItemHelper.isIngot((ItemStack)itemStack2)) {
                FurnaceManager.addRecipe(n * 10 / 16, itemStack, itemStack2, false);
                continue;
            }
            if (ItemHelper.getItemDamage((ItemStack)itemStack) == Short.MAX_VALUE) {
                ItemStack itemStack3 = ItemHelper.cloneStack((ItemStack)itemStack);
                itemStack3.func_77964_b(0);
                if (ItemHelper.hasOreName((ItemStack)itemStack3) && ComparableItemStackFurnace.safeOreType(ItemHelper.getOreName((ItemStack)itemStack3))) {
                    FurnaceManager.addRecipe(n, itemStack3, itemStack2, false);
                    continue;
                }
            }
            FurnaceManager.addRecipe(n, itemStack, itemStack2, false);
        }
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        THashSet tHashSet = new THashSet();
        for (Map.Entry<ComparableItemStackFurnace, RecipeFurnace> entry : recipeMap.entrySet()) {
            RecipeFurnace recipeFurnace = entry.getValue();
            tHashMap.put(new ComparableItemStackFurnace(recipeFurnace.input), recipeFurnace);
            if (!recipeFurnace.isOutputFood()) continue;
            tHashSet.add(new ComparableItemStackFurnace(recipeFurnace.input));
        }
        recipeMap.clear();
        recipeMap = tHashMap;
        foodSet.clear();
        foodSet = tHashSet;
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeFurnace recipeFurnace = new RecipeFurnace(itemStack, itemStack2, n);
        recipeMap.put(new ComparableItemStackFurnace(itemStack), recipeFurnace);
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && recipeMap.get((Object)new ComparableItemStackFurnace(itemStack)) != null) {
            return false;
        }
        RecipeFurnace recipeFurnace = new RecipeFurnace(itemStack, itemStack2, n);
        recipeMap.put(new ComparableItemStackFurnace(itemStack), recipeFurnace);
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack) {
        return recipeMap.remove((Object)new ComparableItemStackFurnace(itemStack)) != null;
    }

    public static void addOreDictRecipe(String string, ItemStack itemStack) {
        FurnaceManager.addOreDictRecipe(1600, string, itemStack);
    }

    public static void addOreDictRecipe(int n, String string, ItemStack itemStack) {
        if (ItemHelper.oreNameExists((String)string)) {
            FurnaceManager.addRecipe(n, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionaryArbiter.getOres((String)string).get(0)), (int)1), itemStack, false);
        }
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Furnace", "AllowRecipeOverwrite", false);
        handledBlocks.add(Blocks.field_150434_aF);
        handledBlocks.add(Blocks.field_150352_o);
        handledBlocks.add(Blocks.field_150366_p);
        handledBlocks.add(Blocks.field_150365_q);
        handledBlocks.add(Blocks.field_150482_ag);
        handledBlocks.add(Blocks.field_150412_bA);
        handledBlocks.add(Blocks.field_150369_x);
        handledBlocks.add(Blocks.field_150450_ax);
        handledBlocks.add(Blocks.field_150449_bY);
    }

    public static class ComparableItemStackFurnace
    extends ComparableItemStack {
        static final String ORE = "ore";
        static final String DUST = "dust";

        public static boolean safeOreType(String string) {
            return string.startsWith(ORE) || string.startsWith(DUST);
        }

        public static int getOreID(ItemStack itemStack) {
            int n = ItemHelper.oreProxy.getOreID(itemStack);
            if (n == -1 || !ComparableItemStackFurnace.safeOreType(ItemHelper.oreProxy.getOreName(n))) {
                return -1;
            }
            return n;
        }

        public ComparableItemStackFurnace(ItemStack itemStack) {
            super(itemStack);
            this.oreID = ComparableItemStackFurnace.getOreID(itemStack);
        }

        public ComparableItemStackFurnace(Item item, int n, int n2) {
            super(item, n, n2);
            this.oreID = ComparableItemStackFurnace.getOreID(this.toItemStack());
        }

        public ComparableItemStackFurnace set(ItemStack itemStack) {
            super.set(itemStack);
            this.oreID = ComparableItemStackFurnace.getOreID(itemStack);
            return this;
        }
    }

    public static class RecipeFurnace
    implements IFurnaceRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;
        boolean isOutputFood;

        RecipeFurnace(ItemStack itemStack, ItemStack itemStack2, int n) {
            this.input = itemStack;
            this.output = itemStack2;
            this.energy = n;
            if (itemStack.field_77994_a <= 0) {
                itemStack.field_77994_a = 1;
            }
            if (itemStack2.field_77994_a <= 0) {
                itemStack2.field_77994_a = 1;
            }
            if (itemStack2.func_77973_b() instanceof ItemFood) {
                this.isOutputFood = true;
            }
        }

        @Override
        public boolean isOutputFood() {
            return this.isOutputFood;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

