/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.TransformationList;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermalexpansion.block.TEBlocks;
import cofh.thermalexpansion.block.light.BlockLight;
import cofh.thermalexpansion.block.light.TileLight;
import cofh.thermalexpansion.core.TEProps;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderLight
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderLight instance = new RenderLight();
    static final int NUM_RENDERS = 2;
    static IIcon[] textureFrame = new IIcon[2];
    static IIcon[] textureCenter = new IIcon[2];
    static IIcon textureHalo;
    static final int NUM_STYLES = 16;
    static CCModel[] modelFrame;
    static CCModel[] modelCenter;
    static CCModel[] modelHalo;

    public static void initialize() {
        for (int i = 0; i < 2; ++i) {
            RenderLight.textureFrame[i] = IconRegistry.getIcon((String)"Light", (int)i);
        }
        RenderLight.textureCenter[0] = IconRegistry.getIcon((String)"FluidGlowstone");
        RenderLight.textureCenter[1] = IconRegistry.getIcon((String)"LightEffect");
        textureHalo = IconRegistry.getIcon((String)"LightHalo");
    }

    private static void generateModels() {
        double d = 9.765625E-4;
        double d2 = 2.0 * d;
        double d3 = 0.0625 - d;
        int n = 0;
        RenderLight.modelCenter[n] = CCModel.quadModel((int)24).generateBlock(0, d2, d2, d2, 1.0 - d2, 1.0 - d2, 1.0 - d2);
        RenderLight.modelHalo[n] = CCModel.quadModel((int)24).generateBlock(0, -d3, -d3, -d3, 1.0 + d3, 1.0 + d3, 1.0 + d3);
        double d4 = 0.0625;
        double d5 = 0.9375;
        double d6 = 0.125;
        RenderLight.modelCenter[++n] = CCModel.quadModel((int)24).generateBlock(0, d4 + d2, d2, d4 + d2, d5 - d2, d6 - d2, d5 - d2);
        RenderLight.modelHalo[n] = CCModel.quadModel((int)24).generateBlock(0, d4 - d3, -d3, d4 - d3, d5 + d3, d6 + d3, d5 + d3);
        d4 = 0.375;
        d5 = 0.625;
        d6 = 0.125;
        RenderLight.modelCenter[++n] = CCModel.quadModel((int)24).generateBlock(0, d4 + d2, d2, d4 + d2, d5 - d2, d6 - d2, d5 - d2);
        RenderLight.modelHalo[n] = CCModel.quadModel((int)24).generateBlock(0, d4 - d3, -d3, d4 - d3, d5 + d3, d6 + d3, d5 + d3);
        d4 = 0.3125;
        d5 = 0.6875;
        d6 = 0.4375;
        RenderLight.modelCenter[++n] = CCModel.quadModel((int)24).generateBlock(0, d4 + d2, d2, d4 + d2, d5 - d2, d6 - d2, d5 - d2);
        RenderLight.modelHalo[n] = CCModel.quadModel((int)24).generateBlock(0, d4 - d3, -d3, d4 - d3, d5 + d3, d6 + d3, d5 + d3);
        d4 = 0.375;
        d5 = 0.625;
        d6 = 0.125;
        RenderLight.modelCenter[++n] = CCModel.quadModel((int)24).generateBlock(0, d4 + d2, d2, d2, d5 - d2, d6 - d2, 1.0 - d2);
        RenderLight.modelHalo[n] = CCModel.quadModel((int)24).generateBlock(0, d4 - d3, -d3, -d3, d5 + d3, d6 + d3, 1.0 + d3);
        d4 = 0.4375;
        d5 = 0.5625;
        d6 = 0.625;
        RenderLight.modelCenter[++n] = CCModel.quadModel((int)24).generateBlock(0, d4 + d2, d2, d4 + d2, d5 - d2, d6 - d2, d5 - d2);
        RenderLight.modelHalo[n] = CCModel.quadModel((int)24).generateBlock(0, d4 - d3, -d3, d4 - d3, d5 + d3, d6 + d3, d5 + d3);
        while (n >= 0) {
            RenderLight.modelFrame[n] = CCModel.quadModel((int)24).generateBlock(0, BlockLight.models[n]);
            modelFrame[n].computeNormals().shrinkUVs(0.00390625);
            modelCenter[n].computeNormals();
            modelHalo[n].computeNormals().shrinkUVs(d3);
            --n;
        }
    }

    public void renderCenter(int n, int n2, boolean bl, Transformation transformation) {
        modelCenter[n].setColour(n2);
        modelCenter[n].render(new CCRenderState.IVertexOperation[]{transformation, RenderUtils.getIconTransformation((IIcon)textureCenter[bl ? 1 : 0])});
        modelCenter[n].setColour(-1);
    }

    public void renderFrame(int n, int n2, int n3, Transformation transformation) {
        modelFrame[n].setColour(n2);
        modelFrame[n].render(new CCRenderState.IVertexOperation[]{transformation, RenderUtils.getIconTransformation((IIcon)textureFrame[n3])});
        modelFrame[n].setColour(-1);
    }

    public void renderHalo(int n, int n2, Transformation transformation) {
        modelHalo[n].setColour(n2 & 0xFFFFFF7F);
        modelHalo[n].render(new CCRenderState.IVertexOperation[]{transformation, RenderUtils.getIconTransformation((IIcon)textureHalo)});
        modelHalo[n].setColour(-1);
    }

    public boolean renderWorldIlluminator(int n, int n2, int n3, boolean bl, Transformation transformation) {
        if (n == 0) {
            this.renderFrame(n2, -1, 0, transformation);
            return true;
        }
        this.renderCenter(n2, n3, bl, transformation);
        return true;
    }

    public boolean renderWorldLampLumium(int n, int n2, int n3, boolean bl, Transformation transformation) {
        if (n == 0) {
            this.renderFrame(n2, n3, 1, transformation);
            return true;
        }
        if (bl) {
            this.renderHalo(n2, n3, transformation);
        }
        return bl;
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileLight)) {
            return false;
        }
        TileLight tileLight = (TileLight)tileEntity;
        int n5 = iBlockAccess.func_72805_g(n, n2, n3);
        RenderUtils.preWorldRender((IBlockAccess)iBlockAccess, (int)n, (int)n2, (int)n3);
        int n6 = BlockCoFHBase.renderPass;
        int n7 = tileLight.getColorMultiplier();
        boolean bl = false;
        byte by = tileLight.style;
        byte by2 = tileLight.alignment;
        TransformationList transformationList = BlockLight.getTransformation(by, by2).with((Transformation)new Vector3((double)n, (double)n2, (double)n3).translation());
        switch (BlockLight.Types.getType(n5)) {
            case ILLUMINATOR: {
                return this.renderWorldIlluminator(n6, by, n7, tileLight.modified, (Transformation)transformationList);
            }
            case LAMP_LUMIUM_RADIANT: {
                bl = tileLight.getInternalLight() > 0;
            }
            case LAMP_LUMIUM: {
                return this.renderWorldLampLumium(n6, by, n7, bl, (Transformation)transformationList);
            }
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int n) {
        return false;
    }

    public int getRenderId() {
        return TEProps.renderIdLight;
    }

    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType itemRenderType) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, IItemRenderer.ItemRendererHelper itemRendererHelper) {
        return true;
    }

    public void renderItemIlluminator(int n, int n2, boolean bl, Transformation transformation) {
        this.renderCenter(n, n2, bl, transformation);
        CCRenderState.draw();
        CCRenderState.startDrawing();
        this.renderFrame(n, -1, 0, transformation);
    }

    public void renderItem(IItemRenderer.ItemRenderType itemRenderType, ItemStack itemStack, Object ... objectArray) {
        GL11.glPushMatrix();
        double d = -0.5;
        if (itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED || itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            d = 0.0;
        }
        int n = itemStack.func_77960_j();
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        if (itemStack.func_77942_o()) {
            if (itemStack.field_77990_d.func_74764_b("Color")) {
                n2 = itemStack.func_77978_p().func_74762_e("Color");
                n2 = (n2 << 8) + 255;
                bl = true;
            }
            n3 = itemStack.field_77990_d.func_74771_c("Style");
        }
        RenderUtils.preItemRender();
        RenderHelper.setBlockTextureSheet();
        TransformationList transformationList = BlockLight.getTransformation(n3, n4).with((Transformation)new Vector3(d, d, d).translation());
        CCRenderState.startDrawing();
        switch (BlockLight.Types.getType(n)) {
            case ILLUMINATOR: {
                this.renderItemIlluminator(n3, n2, bl, (Transformation)transformationList);
                break;
            }
            case LAMP_LUMIUM_RADIANT: 
            case LAMP_LUMIUM: {
                this.renderWorldLampLumium(0, n3, n2, false, (Transformation)transformationList);
            }
        }
        CCRenderState.draw();
        RenderUtils.postItemRender();
        GL11.glPopMatrix();
    }

    static {
        modelFrame = new CCModel[16];
        modelCenter = new CCModel[16];
        modelHalo = new CCModel[16];
        TEProps.renderIdLight = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)TEBlocks.blockLight), (IItemRenderer)instance);
        RenderLight.generateModels();
    }
}

