/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.plate;

import cofh.api.tileentity.ITileInfo;
import cofh.core.network.PacketCoFHBase;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.plate.BlockPlate;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePlateBase
extends TileInventory
implements ITileInfo {
    public static boolean enableSecurity = true;
    byte alignment;
    byte direction;
    protected final byte type;

    public static void initialize() {
        GameRegistry.registerTileEntity(TilePlateBase.class, (String)"cofh.thermalexpansion.PlateFrame");
    }

    public static void configure() {
        String string = "Enable this to allow for Plates to be securable.";
        enableSecurity = ThermalExpansion.config.get("Security", "Plate.Securable", enableSecurity, string);
    }

    public TilePlateBase() {
        this(BlockPlate.Types.FRAME);
        if (((Object)((Object)this)).getClass() != TilePlateBase.class) {
            throw new IllegalArgumentException();
        }
    }

    protected TilePlateBase(BlockPlate.Types types) {
        this.type = (byte)types.ordinal();
    }

    public int getType() {
        return this.type;
    }

    public boolean canUpdate() {
        return false;
    }

    public String getName() {
        return "tile.thermalexpansion.plate." + BlockPlate.NAMES[this.getType()] + ".name";
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    public boolean canRotate() {
        return true;
    }

    public void rotated() {
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, Random random) {
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getFacing() {
        return this.direction;
    }

    public boolean setFacing(int n) {
        if (n != this.direction && n >= 0 && n < 6) {
            this.direction = (byte)n;
            return true;
        }
        return false;
    }

    void setAlignment(int n, float f, float f2, float f3) {
        this.alignment = (byte)n;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (n >> 1) {
            case 0: {
                f4 = f;
                f5 = f3;
                break;
            }
            case 1: {
                f4 = f;
                f5 = f2;
                break;
            }
            case 2: {
                f4 = f2;
                f5 = f3;
            }
        }
        float f6 = 0.16f;
        if (f4 * f4 + f5 * f5 < f6 * f6) {
            this.direction = 1;
        } else {
            int n2 = (int)((Math.atan2(f4, f5) + Math.PI) * 4.0 / Math.PI);
            ++n2;
            switch ((n2 &= 7) >> 1) {
                case 0: 
                case 4: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)4;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)5;
                }
            }
        }
    }

    protected int[] getVector(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if ((this.direction & 1) == 0) {
            n = -n;
        }
        switch (this.direction >> 1) {
            case 0: 
            case 3: {
                n3 = n;
                break;
            }
            case 1: {
                n4 = n;
                break;
            }
            case 2: {
                n2 = n;
            }
        }
        return this.fixVector(n2, n3, n4);
    }

    protected int[] getVector(int n, int n2, int n3) {
        switch (this.direction) {
            case 0: {
                n2 = -n;
                n = 0;
                n3 = 0;
                break;
            }
            case 1: {
                n2 = n;
                n = 0;
                n3 = 0;
                break;
            }
            case 2: {
                n = -n;
                n3 = -n3;
            }
            case 3: {
                int n4 = n;
                n = n3;
                n3 = n4;
                break;
            }
            case 4: {
                n = -n;
                n3 = -n3;
            }
        }
        return this.fixVector(n, n2, n3);
    }

    protected int[] fixVector(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        switch (this.alignment) {
            case 0: {
                break;
            }
            case 1: {
                nArray[1] = -nArray[1];
                break;
            }
            case 2: {
                nArray[1] = -nArray[1];
            }
            case 3: {
                int n4 = nArray[2];
                nArray[2] = -nArray[1];
                nArray[1] = n4;
                break;
            }
            case 4: {
                nArray[1] = -nArray[1];
            }
            case 5: {
                int n5 = nArray[0];
                nArray[0] = -nArray[1];
                nArray[1] = n5;
            }
        }
        return nArray;
    }

    protected double[] getVector(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if ((this.direction & 1) == 0) {
            d = -d;
        }
        switch (this.direction >> 1) {
            case 0: 
            case 3: {
                d3 = d;
                break;
            }
            case 1: {
                d4 = d;
                break;
            }
            case 2: {
                d2 = d;
            }
        }
        return this.fixVector(d2, d3, d4);
    }

    protected double[] getVector(double d, double d2, double d3) {
        switch (this.direction) {
            case 0: {
                d2 = -d;
                d = 0.0;
                d3 = 0.0;
                break;
            }
            case 1: {
                d2 = d;
                d = 0.0;
                d3 = 0.0;
                break;
            }
            case 2: {
                d = -d;
                d3 = -d3;
            }
            case 3: {
                double d4 = d;
                d = d3;
                d3 = d4;
                break;
            }
            case 4: {
                d = -d;
                d3 = -d3;
            }
        }
        return this.fixVector(d, d2, d3);
    }

    protected double[] fixVector(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        switch (this.alignment) {
            case 0: {
                break;
            }
            case 1: {
                dArray[1] = -dArray[1];
                break;
            }
            case 2: {
                dArray[1] = -dArray[1];
            }
            case 3: {
                double d4 = dArray[2];
                dArray[2] = -dArray[1];
                dArray[1] = d4;
                break;
            }
            case 4: {
                dArray[1] = -dArray[1];
            }
            case 5: {
                double d5 = dArray[0];
                dArray[0] = -dArray[1];
                dArray[1] = d5;
            }
        }
        return dArray;
    }

    protected double[] fixPosition(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        switch (this.alignment) {
            case 0: {
                break;
            }
            case 1: {
                dArray[1] = 1.0 - dArray[1];
                break;
            }
            case 2: {
                dArray[1] = 1.0 - dArray[1];
            }
            case 3: {
                double d4 = dArray[2];
                dArray[2] = 1.0 - dArray[1];
                dArray[1] = d4;
                break;
            }
            case 4: {
                dArray[1] = 1.0 - dArray[1];
            }
            case 5: {
                double d5 = dArray[0];
                dArray[0] = 1.0 - dArray[1];
                dArray[1] = d5;
            }
        }
        return dArray;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.alignment = nBTTagCompound.func_74771_c("Align");
        this.direction = nBTTagCompound.func_74771_c("Dir");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Align", this.alignment);
        nBTTagCompound.func_74774_a("Dir", this.direction);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.alignment);
        packetCoFHBase.addByte(this.direction);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addByte(this.direction);
        return packetCoFHBase;
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        byte by = packetCoFHBase.getByte();
        if (by != this.direction) {
            this.rotated();
            this.direction = by;
            ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.alignment = packetCoFHBase.getByte();
            this.direction = packetCoFHBase.getByte();
        } else {
            packetCoFHBase.getByte();
            packetCoFHBase.getByte();
        }
    }

    public boolean shouldRefresh(Block block, Block block2, int n, int n2, World world, int n3, int n4, int n5) {
        return block != block2 || n2 != this.type;
    }

    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            list.add((IChatComponent)new ChatComponentText("Alignment: " + this.alignment + ":" + ForgeDirection.getOrientation((int)this.alignment)));
            list.add((IChatComponent)new ChatComponentText("Direction: " + this.direction + ":" + ForgeDirection.getOrientation((int)this.direction)));
        }
    }
}

