/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Event.LightBridgePowerLossEvent;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityBeamMachine;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PowerReceivers;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityLightBridge
extends TileEntityBeamMachine
implements RangedEffect,
BreakAction {
    private int animtick = 0;
    public static final int distancelimit = Math.max(64, ConfigRegistry.BRIDGERANGE.getValue());

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.animtick;
        this.power = (long)this.omega * (long)this.torque;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (!world.field_72995_K) {
            this.makeBeam(world, x, y, z, meta);
        }
    }

    @Override
    protected void makeBeam(World world, int x, int y, int z, int metadata) {
        boolean animstep = false;
        boolean blocked = false;
        int dir = 0;
        switch (metadata) {
            case 0: {
                dir = 3;
                break;
            }
            case 1: {
                dir = 1;
                break;
            }
            case 2: {
                dir = 2;
                break;
            }
            case 3: {
                dir = 0;
            }
        }
        int range = this.getRange();
        if (range > 0 && world.func_72957_l(x, y + 1, z) >= 13) {
            if (!world.field_72995_K) {
                for (int i = 1; !(i > range && range != -1 || i > this.animtick || blocked || !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(x + this.facing.offsetX), (int)(y + this.facing.offsetY), (int)(z + this.facing.offsetZ)) && world.func_147439_a(x + this.facing.offsetX, y + this.facing.offsetY, z + this.facing.offsetZ) != Blocks.field_150350_a && world.func_147439_a(x + this.facing.offsetX, y + this.facing.offsetY, z + this.facing.offsetZ) != BlockRegistry.BRIDGE.getBlockInstance()); ++i) {
                    Block idview = world.func_147439_a(x + this.facing.offsetX * i, y + this.facing.offsetY * i, z + this.facing.offsetZ * i);
                    int metaview = world.func_72805_g(x + this.facing.offsetX * i, y + this.facing.offsetY * i, z + this.facing.offsetZ * i);
                    if (idview == Blocks.field_150350_a || ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(x + this.facing.offsetX * i), (int)(y + this.facing.offsetY * i), (int)(z + this.facing.offsetZ * i)) || idview == BlockRegistry.LIGHT.getBlockInstance() || idview == BlockRegistry.BEAM.getBlockInstance() || idview == BlockRegistry.BRIDGE.getBlockInstance()) {
                        world.func_147465_d(x + this.facing.offsetX * i, y + this.facing.offsetY * i, z + this.facing.offsetZ * i, BlockRegistry.BRIDGE.getBlockInstance(), dir, 3);
                    }
                    if ((idview == Blocks.field_150350_a || ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(x + this.facing.offsetX * i), (int)(y + this.facing.offsetY * i), (int)(z + this.facing.offsetZ * i)) || idview == BlockRegistry.LIGHT.getBlockInstance() || idview == BlockRegistry.BEAM.getBlockInstance() || idview == BlockRegistry.BRIDGE.getBlockInstance()) && this.animtick <= range + 1) continue;
                    --this.animtick;
                    blocked = true;
                }
            }
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new LightBridgePowerLossEvent((TileEntity)this));
            this.lightsOut(world, x, y, z);
        }
    }

    private void lightsOut(World world, int x, int y, int z) {
        this.animtick = 0;
        int dir = 0;
        switch (this.func_145832_p()) {
            case 0: {
                dir = 3;
                break;
            }
            case 1: {
                dir = 1;
                break;
            }
            case 2: {
                dir = 2;
                break;
            }
            case 3: {
                dir = 0;
            }
        }
        for (int i = 1; i < this.getMaxRange(); ++i) {
            Block idview = world.func_147439_a(x + this.facing.offsetX * i, y + this.facing.offsetY * i, z + this.facing.offsetZ * i);
            int metaview = world.func_72805_g(x + this.facing.offsetX * i, y + this.facing.offsetY * i, z + this.facing.offsetZ * i);
            if (idview == BlockRegistry.BRIDGE.getBlockInstance() && metaview == dir) {
                world.func_147468_f(x + this.facing.offsetX * i, y + this.facing.offsetY * i, z + this.facing.offsetZ * i);
            }
            world.func_147471_g(x + this.facing.offsetX * i, y + this.facing.offsetY * i, z + this.facing.offsetZ * i);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("tick", this.animtick);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.animtick = NBT.func_74762_e("tick");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getRange() {
        return (int)Math.min((long)distancelimit, this.power * (long)distancelimit / PowerReceivers.LIGHTBRIDGE.getMinPower());
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.LIGHTBRIDGE;
    }

    @Override
    public int getMaxRange() {
        return distancelimit;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void breakBlock() {
        this.lightsOut(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

