/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.SemiTransparent;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBeamMirror
extends RotaryCraftTileEntity
implements RangedEffect,
BreakAction {
    public float theta;
    private BlockArray light = new BlockArray();
    private int lastRange = 0;
    private ForgeDirection facingDir;

    @Override
    public void onEMP() {
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BEAMMIRROR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getDirection(meta);
        this.adjustAim(world, x, y, z);
        this.setLight(world, x, y, z);
        this.burnMobs(world, x, y, z);
    }

    private void getDirection(int meta) {
        switch (meta) {
            case 0: {
                this.facingDir = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.facingDir = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.facingDir = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.facingDir = ForgeDirection.NORTH;
            }
        }
    }

    private void burnMobs(World world, int x, int y, int z) {
        AxisAlignedBB box = this.getBurningBox(world, x, y, z);
        List inbox = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : inbox) {
            if (!ReikaEntityHelper.burnsInSun((EntityLivingBase)e)) continue;
            e.func_70015_d(10);
        }
    }

    private AxisAlignedBB getBurningBox(World world, int x, int y, int z) {
        int r = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        switch (this.facingDir) {
            case EAST: {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1 + r), (double)(y + 1), (double)(z + 1));
            }
            case NORTH: {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)(z - r), (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case SOUTH: {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1 + r));
            }
            case WEST: {
                return AxisAlignedBB.func_72330_a((double)(x - r), (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
        }
        return box;
    }

    private void setLight(World world, int x, int y, int z) {
        Coordinate c;
        int i;
        int r = this.getRange();
        if (this.lastRange != r) {
            for (i = 0; i < this.light.getSize(); ++i) {
                c = this.light.getNthBlock(i);
                Block b = c.getBlock(world);
                if (b != BlockRegistry.LIGHT.getBlockInstance()) continue;
                c.setBlock(world, Blocks.field_150350_a);
                world.func_147479_m(c.xCoord, c.yCoord, c.zCoord);
            }
            this.light.clear();
            if (r > 0 && world.func_72937_j(x, y + 1, z)) {
                this.light.addLineOfClear(world, x + this.facingDir.offsetX, y, z + this.facingDir.offsetZ, r, this.facingDir.offsetX, 0, this.facingDir.offsetZ);
            }
            this.lastRange = r;
        }
        for (i = 0; i < this.light.getSize(); ++i) {
            c = this.light.getNthBlock(i);
            if (c.getBlock(world) == Blocks.field_150350_a) {
                c.setBlock(world, BlockRegistry.LIGHT.getBlockInstance(), 15);
            }
            world.func_147479_m(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    private void adjustAim(World world, int x, int y, int z) {
        float suntheta = ReikaWorldHelper.getSunAngle((World)world) / 2.0f + 12.5f;
        float movespeed = 0.5f;
        if (this.theta < suntheta) {
            this.theta += movespeed;
        }
        if (this.theta > suntheta) {
            this.theta -= movespeed;
        }
    }

    @Override
    public int getRange() {
        if (!this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            return 0;
        }
        int time = (int)(this.field_145850_b.func_72820_D() % 24000L);
        if (time > 13500 && time < 22500) {
            return 0;
        }
        double r = ReikaMathLibrary.doubpow((double)2.0, (double)(7.0f * ReikaWorldHelper.getSunIntensity((World)this.field_145850_b, (boolean)true, (float)0.0f)));
        int ir = (int)r;
        if (ir > this.getMaxRange()) {
            ir = this.getMaxRange();
        }
        for (int i = 1; i < ir; ++i) {
            int dx = this.field_145851_c + i * this.facingDir.offsetX;
            int dy = this.field_145848_d + i * this.facingDir.offsetY;
            int dz = this.field_145849_e + i * this.facingDir.offsetZ;
            Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
            if (b == Blocks.field_150350_a || !(b instanceof SemiTransparent ? ((SemiTransparent)b).isOpaque(this.field_145850_b.func_72805_g(dx, dy, dz)) : b.func_149662_c())) continue;
            return i;
        }
        return ir;
    }

    @Override
    public int getMaxRange() {
        return Math.max(ConfigRegistry.FLOODLIGHTRANGE.getValue(), 64);
    }

    private void lightsOut() {
        World world = this.field_145850_b;
        for (int i = 0; i < this.light.getSize(); ++i) {
            Coordinate c = this.light.getNthBlock(i);
            Block b = c.getBlock(world);
            if (b != BlockRegistry.LIGHT.getBlockInstance()) continue;
            c.setBlock(world, Blocks.field_150350_a);
            world.func_147479_m(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public void breakBlock() {
        this.lightsOut();
    }
}

