/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.API.Power.PowerTracker;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySplitter
extends TileEntityTransmissionMachine
implements GuiController,
ShaftMerger,
NBTMachine {
    private int torquein2;
    private int omegain2;
    private int splitmode = 1;
    private boolean processingSecondary;
    public boolean failed;
    private boolean bedrock;
    private int overloadTick = 0;
    private int pow2;

    public int getRatioFromMode() {
        return this.splitmode;
    }

    public void setMode(int mode) {
        this.splitmode = mode;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        if (this.failed) {
            this.torque = 0;
            this.omega = 0;
        } else {
            this.transferPower(world, x, y, z, meta, true, true);
        }
        this.power = (long)this.omega * (long)this.torque;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.NORTH;
                this.write = ForgeDirection.WEST;
                this.write2 = null;
                break;
            }
            case 1: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.SOUTH;
                this.write = ForgeDirection.NORTH;
                this.write2 = null;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                this.read2 = ForgeDirection.WEST;
                this.write = ForgeDirection.EAST;
                this.write2 = null;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                this.read2 = ForgeDirection.WEST;
                this.write = ForgeDirection.SOUTH;
                this.write2 = null;
                break;
            }
            case 4: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.SOUTH;
                this.write = ForgeDirection.WEST;
                this.write2 = null;
                break;
            }
            case 5: {
                this.read = ForgeDirection.WEST;
                this.read2 = ForgeDirection.SOUTH;
                this.write = ForgeDirection.NORTH;
                this.write2 = null;
                break;
            }
            case 6: {
                this.read = ForgeDirection.NORTH;
                this.read2 = ForgeDirection.WEST;
                this.write = ForgeDirection.EAST;
                this.write2 = null;
                break;
            }
            case 7: {
                this.read = ForgeDirection.NORTH;
                this.read2 = ForgeDirection.EAST;
                this.write = ForgeDirection.SOUTH;
                this.write2 = null;
                break;
            }
            case 8: {
                this.read2 = null;
                this.read = ForgeDirection.WEST;
                this.write = ForgeDirection.EAST;
                this.write2 = ForgeDirection.NORTH;
                break;
            }
            case 9: {
                this.read = ForgeDirection.NORTH;
                this.read2 = null;
                this.write = ForgeDirection.SOUTH;
                this.write2 = ForgeDirection.EAST;
                break;
            }
            case 10: {
                this.read = ForgeDirection.EAST;
                this.read2 = null;
                this.write = ForgeDirection.WEST;
                this.write2 = ForgeDirection.SOUTH;
                break;
            }
            case 11: {
                this.read = ForgeDirection.SOUTH;
                this.read2 = null;
                this.write = ForgeDirection.NORTH;
                this.write2 = ForgeDirection.WEST;
                break;
            }
            case 12: {
                this.read = ForgeDirection.WEST;
                this.read2 = null;
                this.write = ForgeDirection.EAST;
                this.write2 = ForgeDirection.SOUTH;
                break;
            }
            case 13: {
                this.read = ForgeDirection.NORTH;
                this.read2 = null;
                this.write = ForgeDirection.SOUTH;
                this.write2 = ForgeDirection.WEST;
                break;
            }
            case 14: {
                this.read = ForgeDirection.EAST;
                this.read2 = null;
                this.write = ForgeDirection.WEST;
                this.write2 = ForgeDirection.NORTH;
                break;
            }
            case 15: {
                this.read = ForgeDirection.SOUTH;
                this.read2 = null;
                this.write = ForgeDirection.NORTH;
                this.write2 = ForgeDirection.EAST;
            }
        }
    }

    protected void readFromCross(TileEntityShaft cross) {
        if (cross.isWritingTo(this)) {
            this.omega = cross.readomega[0];
            this.torque = cross.readtorque[0];
        } else if (cross.isWritingTo2(this)) {
            this.omega = cross.readomega[1];
            this.torque = cross.readtorque[1];
        } else {
            return;
        }
    }

    private void mergeReadFromCross(TileEntityShaft cross, int side) {
        if (cross.isWritingTo(this)) {
            if (side == 0) {
                this.omegain = cross.readomega[0];
                this.torquein = cross.readtorque[0];
            }
            if (side == 1) {
                this.omegain2 = cross.readomega[0];
                this.torquein2 = cross.readtorque[0];
            }
        } else if (cross.isWritingTo2(this)) {
            if (side == 0) {
                this.omegain = cross.readomega[1];
                this.torquein = cross.readtorque[1];
            }
            if (side == 1) {
                this.omegain2 = cross.readomega[1];
                this.torquein2 = cross.readtorque[1];
            }
        } else {
            return;
        }
    }

    protected void transferPower(World world, int x, int y, int z, int meta, boolean check1, boolean check2) {
        boolean isCentered;
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        if (check1 && check2) {
            this.torquein = 0;
            this.omegain = 0;
        }
        boolean bl = isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        if (!this.isSplitting()) {
            WorldLocation loc;
            WorldRift sr;
            ShaftPowerEmitter sp;
            ForgeDirection dir;
            TileEntityPowerBus pwr;
            TileEntityIOMachine devicein;
            TileEntity te2;
            int dx = x + this.read.offsetX;
            int dy = y + this.read.offsetY;
            int dz = z + this.read.offsetZ;
            int dx2 = x + this.read2.offsetX;
            int dy2 = y + this.read2.offsetY;
            int dz2 = z + this.read2.offsetZ;
            MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            TileEntity te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
            MachineRegistry m2 = isCentered ? this.getMachine(this.read2) : MachineRegistry.getMachine((IBlockAccess)world, dx2, dy2, dz2);
            TileEntity tileEntity = te2 = isCentered ? this.getAdjacentTileEntity(this.read2) : world.func_147438_o(dx2, dy2, dz2);
            if (check1) {
                if (this.isProvider(te)) {
                    if (m == MachineRegistry.SHAFT) {
                        devicein = (TileEntityShaft)te;
                        if (((TileEntityShaft)devicein).isCross()) {
                            this.mergeReadFromCross((TileEntityShaft)devicein, 0);
                        } else if (devicein.isWritingTo(this)) {
                            this.torquein = ((TileEntityShaft)devicein).torque;
                            this.omegain = ((TileEntityShaft)devicein).omega;
                        }
                    }
                    if (te instanceof SimpleProvider) {
                        devicein = (TileEntityIOMachine)te;
                        if (devicein.isWritingTo(this)) {
                            this.torquein = devicein.torque;
                            this.omegain = devicein.omega;
                        } else if (devicein.isWritingTo2(this)) {
                            this.torquein = devicein.torque;
                            this.omegain = devicein.omega;
                        } else {
                            this.omegain = 0;
                            this.torquein = 0;
                        }
                    }
                    if (m == MachineRegistry.POWERBUS) {
                        pwr = (TileEntityPowerBus)te;
                        dir = this.getInputForgeDirection().getOpposite();
                        this.omegain = pwr.getSpeedToSide(dir);
                        this.torquein = pwr.getTorqueToSide(dir);
                    }
                    if (te instanceof ShaftPowerEmitter) {
                        sp = (ShaftPowerEmitter)te;
                        if (sp.isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                            this.torquein = sp.getTorque();
                            this.omegain = sp.getOmega();
                        } else {
                            this.omegain = 0;
                            this.torquein = 0;
                        }
                    }
                    if (m == MachineRegistry.SPLITTER) {
                        devicein = (TileEntitySplitter)te;
                        if (((TileEntitySplitter)devicein).isSplitting()) {
                            this.processingSecondary = false;
                            this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                        } else if (devicein.isWritingTo(this)) {
                            this.torquein = ((TileEntitySplitter)devicein).torque;
                            this.omegain = ((TileEntitySplitter)devicein).omega;
                        }
                    }
                } else if (te instanceof WorldRift) {
                    sr = (WorldRift)te;
                    loc = sr.getLinkTarget();
                    if (loc != null) {
                        this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta, true, false);
                    }
                } else {
                    this.omegain = 0;
                    this.torquein = 0;
                }
            }
            if (check2) {
                if (this.isProvider(te2)) {
                    TileEntityTransmissionMachine devicein2;
                    if (m2 == MachineRegistry.SHAFT) {
                        devicein2 = (TileEntityShaft)te2;
                        if (((TileEntityShaft)devicein2).isCross()) {
                            this.mergeReadFromCross((TileEntityShaft)devicein2, 1);
                        } else if (devicein2.isWritingTo(this)) {
                            this.torquein2 = ((TileEntityShaft)devicein2).torque;
                            this.omegain2 = ((TileEntityShaft)devicein2).omega;
                        }
                    }
                    if (te2 instanceof SimpleProvider) {
                        devicein = (TileEntityIOMachine)te2;
                        if (devicein.isWritingTo(this)) {
                            this.torquein2 = devicein.torque;
                            this.omegain2 = devicein.omega;
                        } else {
                            this.omegain2 = 0;
                            this.torquein2 = 0;
                        }
                    }
                    if (m2 == MachineRegistry.POWERBUS) {
                        pwr = (TileEntityPowerBus)te2;
                        dir = this.getInputForgeDirection().getOpposite();
                        this.omegain2 = pwr.getSpeedToSide(dir);
                        this.torquein2 = pwr.getTorqueToSide(dir);
                    }
                    if (te2 instanceof ShaftPowerEmitter) {
                        sp = (ShaftPowerEmitter)te2;
                        if (sp.isEmitting() && sp.canWriteTo(this.read2.getOpposite())) {
                            this.torquein2 = sp.getTorque();
                            this.omegain2 = sp.getOmega();
                        } else {
                            this.omegain2 = 0;
                            this.torquein2 = 0;
                        }
                    }
                    if (m2 == MachineRegistry.SPLITTER) {
                        devicein2 = (TileEntitySplitter)te2;
                        if (((TileEntitySplitter)devicein2).isSplitting()) {
                            this.processingSecondary = true;
                            this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein2);
                        } else if (devicein2.isWritingTo(this)) {
                            this.torquein2 = ((TileEntitySplitter)devicein2).torque;
                            this.omegain2 = ((TileEntitySplitter)devicein2).omega;
                        }
                    }
                } else if (te2 instanceof WorldRift) {
                    sr = (WorldRift)te2;
                    loc = sr.getLinkTarget();
                    if (loc != null) {
                        this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta, false, true);
                    }
                } else {
                    this.omegain2 = 0;
                    this.torquein2 = 0;
                }
            }
            if (!check1 || !check2) {
                return;
            }
            PowerSourceList in1 = null;
            PowerSourceList in2 = null;
            if (this.read != null && this.read2 != null && this.isLoopingPower(in1 = PowerSourceList.getAllFrom(world, this.read, x + this.read.offsetX, y + this.read.offsetY, z + this.read.offsetZ, this, this), in2 = PowerSourceList.getAllFrom(world, this.read2, x + this.read2.offsetX, y + this.read2.offsetY, z + this.read2.offsetZ, this, this))) {
                this.torque = 0;
                this.omega = 0;
                this.power = 0L;
                this.fail();
            }
            boolean overload = false;
            if (!this.canCombine(in1, in2, this.torquein, this.torquein2)) {
                ++this.overloadTick;
                overload = true;
                if (this.overloadTick > 20) {
                    this.fail();
                    this.overloadTick = 0;
                } else {
                    world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.1f, 1.0f);
                }
            } else if (this.omegain == this.omegain2) {
                this.omega = this.omegain;
                this.torque = this.torquein + this.torquein2;
            } else {
                int n = this.omega = this.omegain == 0 || this.omegain2 == 0 ? Math.max(this.omegain, this.omegain2) : rand.nextInt(Math.max(1 + this.omegain, 1 + this.omegain2));
                this.torque = this.omegain == 0 || this.omegain2 == 0 ? (this.omega == this.omegain ? this.torquein : this.torquein2) : rand.nextInt(Math.min(1 + this.torquein, 1 + this.torquein2));
                if (this.omegain != 0 && this.omegain2 != 0) {
                    world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.1f, 1.0f);
                }
            }
            if (!overload) {
                this.overloadTick = 0;
            }
            this.basicPowerReceiver();
        } else {
            TileEntity te;
            int dx = x + this.read.offsetX;
            int dy = y + this.read.offsetY;
            int dz = z + this.read.offsetZ;
            MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
            if (this.isProvider(te)) {
                TileEntityIOMachine devicein;
                if (m == MachineRegistry.SHAFT) {
                    devicein = (TileEntityShaft)te;
                    if (((TileEntityShaft)devicein).isCross()) {
                        this.readFromCross((TileEntityShaft)devicein);
                        return;
                    }
                    if (devicein.isWritingTo(this)) {
                        this.torque = ((TileEntityShaft)devicein).torque;
                        this.omega = ((TileEntityShaft)devicein).omega;
                    } else {
                        this.omega = 0;
                        this.torque = 0;
                    }
                }
                if (te instanceof SimpleProvider) {
                    devicein = (TileEntityIOMachine)te;
                    if (devicein.isWritingTo(this)) {
                        this.torque = devicein.torque;
                        this.omega = devicein.omega;
                    } else {
                        this.omega = 0;
                        this.torque = 0;
                    }
                }
                if (te instanceof ShaftPowerEmitter) {
                    ShaftPowerEmitter sp = (ShaftPowerEmitter)te;
                    if (sp.isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                        this.torque = sp.getTorque();
                        this.omega = sp.getOmega();
                    } else {
                        this.omega = 0;
                        this.torque = 0;
                    }
                }
                if (m == MachineRegistry.POWERBUS) {
                    TileEntityPowerBus pwr = (TileEntityPowerBus)te;
                    ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                    this.omegain = pwr.getSpeedToSide(dir);
                    this.torquein = pwr.getTorqueToSide(dir);
                }
                if (m == MachineRegistry.SPLITTER) {
                    devicein = (TileEntitySplitter)te;
                    if (((TileEntitySplitter)devicein).isSplitting()) {
                        this.processingSecondary = false;
                        this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                        this.torque = this.torquein;
                        this.omega = this.omegain;
                    } else if (devicein.isWritingTo(this)) {
                        this.torque = ((TileEntitySplitter)devicein).torque;
                        this.omega = ((TileEntitySplitter)devicein).omega;
                    } else {
                        this.omega = 0;
                        this.torque = 0;
                    }
                }
            } else if (te instanceof WorldRift) {
                WorldRift sr = (WorldRift)te;
                WorldLocation loc = sr.getLinkTarget();
                if (loc != null) {
                    this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta, false, false);
                }
            } else {
                this.omega = 0;
                this.torque = 0;
            }
            this.power = (long)this.torque * (long)this.omega;
            this.writeToReceiver();
        }
    }

    private boolean canCombine(PowerSourceList in1, PowerSourceList in2, int t1, int t2) {
        PowerSourceList combo = PowerSourceList.combine(in1, in2, this);
        if (combo.isLooping()) {
            return false;
        }
        if (t1 == 0 || t2 == 0) {
            return true;
        }
        return this.bedrock || !combo.isEngineSpam();
    }

    @Override
    public void fail() {
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 4.0f, false);
        this.failed = true;
    }

    public boolean isSplitting() {
        return this.func_145832_p() >= 8;
    }

    public boolean isBedrock() {
        return this.bedrock;
    }

    private boolean isLoopingPower(PowerSourceList in1, PowerSourceList in2) {
        int st = this.torquein + this.torquein2;
        int so = this.omegain + this.omegain2;
        return st > 0 && so > 0 && (in1.passesThrough(this) || in2.passesThrough(this));
    }

    private void writeToReceiver() {
        int t1 = 0;
        int t2 = 0;
        int y = this.field_145848_d;
        World world = this.field_145850_b;
        int ratio = this.getRatioFromMode();
        if (ratio == 0) {
            return;
        }
        boolean favorbent = false;
        if (ratio < 0) {
            favorbent = true;
            ratio = -ratio;
        }
        t1 = ratio == 1 ? this.torque / 2 : (favorbent ? this.torque / ratio : (int)((double)this.torque * (((double)ratio - 1.0) / (double)ratio)));
        t2 = ratio == 1 ? this.torque / 2 : (favorbent ? (int)((double)this.torque * (((double)ratio - 1.0) / (double)ratio)) : this.torque / ratio);
        this.writeToPowerReceiver(this.write, this.omega, t1);
        this.writeToPowerReceiver(this.write2, this.omega, t2);
    }

    @Override
    protected void readFromSplitter(World world, int x, int y, int z, TileEntitySplitter spl) {
        this.assignOmega(spl.omega);
        int ratio = spl.getRatioFromMode();
        if (ratio == 0) {
            return;
        }
        boolean favorbent = false;
        if (ratio < 0) {
            favorbent = true;
            ratio = -ratio;
        }
        if (x == spl.getWriteX() && z == spl.getWriteZ()) {
            if (ratio == 1) {
                this.assignTorque(spl.torque / 2);
                return;
            }
            if (favorbent) {
                this.assignTorque(spl.torque / ratio);
            } else {
                this.assignTorque((int)((double)spl.torque * (((double)ratio - 1.0) / (double)ratio)));
            }
        } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
            this.assignOmega(spl.omega);
            if (ratio == 1) {
                this.assignTorque(spl.torque / 2);
                return;
            }
            if (favorbent) {
                this.assignTorque((int)((double)spl.torque * (((double)ratio - 1.0) / (double)ratio)));
            } else {
                this.assignTorque(spl.torque / ratio);
            }
        } else {
            this.assignTorque(0);
            this.assignOmega(0);
            return;
        }
    }

    private void assignTorque(int val) {
        if (this.processingSecondary) {
            this.torquein2 = val;
        } else {
            this.torquein = val;
        }
    }

    private void assignOmega(int val) {
        if (this.processingSecondary) {
            this.omegain2 = val;
        } else {
            this.omegain = val;
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("mode", this.splitmode);
        NBT.func_74757_a("fail", this.failed);
        NBT.func_74757_a("bedrock", this.bedrock);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.splitmode = NBT.func_74762_e("mode");
        this.failed = NBT.func_74767_n("fail");
        this.bedrock = NBT.func_74767_n("bedrock");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SPLITTER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        PowerSourceList pwr = new PowerSourceList();
        if (caller == null) {
            caller = this;
        }
        if (!this.isSplitting()) {
            PowerSourceList in;
            if (this.read != null) {
                in = PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX, this.field_145848_d + this.read.offsetY, this.field_145849_e + this.read.offsetZ, this, caller);
                pwr.addAll(in);
            }
            if (this.read2 != null) {
                in = PowerSourceList.getAllFrom(this.field_145850_b, this.read2, this.field_145851_c + this.read2.offsetX, this.field_145848_d + this.read2.offsetY, this.field_145849_e + this.read2.offsetZ, this, caller);
                pwr.addAll(in);
            }
            return pwr;
        }
        return PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX, this.field_145848_d + this.read.offsetY, this.field_145849_e + this.read.offsetZ, this, caller);
    }

    public String getRatioForDisplay() {
        switch (this.splitmode) {
            case 32: {
                return "31:1 Inline";
            }
            case -32: {
                return "1:31 Bend";
            }
            case 16: {
                return "15:1 Inline";
            }
            case -16: {
                return "1:15 Bend";
            }
            case 8: {
                return "7:1 Inline";
            }
            case -8: {
                return "1:7 Bend";
            }
            case 4: {
                return "3:1 Inline";
            }
            case -4: {
                return "1:3 Bend";
            }
            case 1: {
                return "1:1 Even";
            }
        }
        return "ERROR";
    }

    @Override
    public int getWriteX() {
        return this.write != null ? this.field_145851_c + this.write.offsetX : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteY() {
        return this.field_145848_d;
    }

    @Override
    public int getWriteZ() {
        return this.write != null ? this.field_145849_e + this.write.offsetZ : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteX2() {
        return this.write2 != null ? this.field_145851_c + this.write2.offsetX : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteY2() {
        return this.field_145848_d;
    }

    @Override
    public int getWriteZ2() {
        return this.write2 != null ? this.field_145849_e + this.write2.offsetZ : Integer.MIN_VALUE;
    }

    @Override
    public NBTTagCompound getTagsToWriteToStack() {
        NBTTagCompound NBT = new NBTTagCompound();
        NBT.func_74757_a("bedrock", this.bedrock);
        return NBT;
    }

    @Override
    public void setDataFromItemStackTag(NBTTagCompound NBT) {
        this.bedrock = NBT != null && NBT.func_74767_n("bedrock");
    }

    @Override
    public ArrayList<NBTTagCompound> getCreativeModeVariants() {
        ArrayList<NBTTagCompound> li = new ArrayList<NBTTagCompound>();
        li.add(new NBTTagCompound());
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("bedrock", true);
        li.add(nbt);
        return li;
    }

    @Override
    public ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        ArrayList<String> li = new ArrayList<String>();
        li.add(NBT != null && NBT.func_74767_n("bedrock") ? "Bedrock" : "Steel");
        return li;
    }

    public void setBedrock() {
        this.bedrock = true;
    }

    @Override
    public void onPowerLooped(PowerTracker pwr) {
        if (this.power > 0L) {
            this.fail();
        }
    }

    @Override
    public final void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        c.add(this.getAdjacentTileEntity(this.write));
        if (this.isSplitting()) {
            c.add(this.getAdjacentTileEntity(this.write2));
        }
    }
}

