/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.RotaryCraft.Base.TileEntity.SprinklerBlock;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.RotaryCraft;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySprinkler
extends SprinklerBlock {
    private static final String LOGGER_ID = "sprinkler_apple";

    @Override
    public void performEffects(World world, int x, int y, int z) {
        RotaryAchievements.SPRINKLER.triggerAchievement(this.getPlacer());
        this.spawnParticles(world, x, y, z);
        this.hydrate(world, x, y, z);
        if (ModList.REACTORCRAFT.isLoaded() && rand.nextInt(2400) == 0) {
            this.clearRadiation(world, x, y, z);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.REACTORCRAFT)
    private void clearRadiation(World world, int x, int y, int z) {
        int r = this.getRange();
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72317_d(0.0, -4.0, 0.0).func_72314_b((double)r, 4.0, (double)r);
        List li = world.func_72872_a(EntityRadiation.class, box);
        for (EntityRadiation e : li) {
            e.clean();
            if (!rand.nextBoolean()) continue;
            break;
        }
    }

    public void hydrate(World world, int x, int y, int z) {
        int range = this.getRange();
        for (int i = -range; i <= range; ++i) {
            for (int k = -range; k <= range; ++k) {
                int dx = x + i;
                int dz = z + k;
                int dy = y;
                boolean flag = false;
                boolean drip = false;
                float f = 0.5f + 1.5f * (float)(i * i + k * k) / (float)(range * range);
                while (dy > 0 && y - dy < 12 && !flag) {
                    Block b = world.func_147439_a(dx, dy, dz);
                    if (!b.isAir((IBlockAccess)world, dx, dy, dz)) {
                        String n;
                        boolean flag2 = false;
                        if (b == Blocks.field_150480_ab) {
                            if (!world.field_72995_K && Effects.FIREEXTINGUISH.doChance(rand, f)) {
                                world.func_72908_a((double)dx, (double)dy, (double)dz, "random.fizz", 0.6f + 0.4f * rand.nextFloat(), 0.5f + 0.5f * rand.nextFloat());
                                world.func_147468_f(dx, dy, dz);
                            }
                            flag2 = true;
                        } else if (b == Blocks.field_150458_ak) {
                            if (!world.field_72995_K && Effects.HYDRATEFARMLAND.doChance(rand, f)) {
                                ReikaWorldHelper.hydrateFarmland((World)world, (int)dx, (int)dy, (int)dz, (boolean)false);
                            }
                            flag2 = true;
                        }
                        if (!flag2 && !world.field_72995_K && Effects.CROPTICK.doChance(rand, f)) {
                            ReikaCropHelper crop = ReikaCropHelper.getCrop((Block)b);
                            if (crop == null) {
                                crop = ModCropList.getModCrop((Block)b, (int)world.func_72805_g(dx, dy, dz));
                            }
                            if (crop != null) {
                                b.func_149674_a(world, dx, dy, dz, rand);
                                BlockTickEvent.fire((World)world, (int)dx, (int)dy, (int)dz, (Block)b, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                            } else {
                                ReikaPlantHelper p = ReikaPlantHelper.getPlant((Block)b);
                                if (p != null && p.grows()) {
                                    b.func_149674_a(world, dx, dy, dz, rand);
                                    BlockTickEvent.fire((World)world, (int)dx, (int)dy, (int)dz, (Block)b, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                                    boolean bl = flag2 = p == ReikaPlantHelper.CACTUS || p == ReikaPlantHelper.SUGARCANE;
                                }
                            }
                        }
                        if (!flag2 && Effects.APPLETICK.doChance(rand, f) && (n = b.getClass().getName().toLowerCase(Locale.ENGLISH)).startsWith("growthcraft.apples")) {
                            if (n.endsWith("leaves")) {
                                Block b2;
                                if (ModularLogger.instance.isEnabled(LOGGER_ID)) {
                                    ModularLogger.instance.log(LOGGER_ID, "Found leaf @ " + dx + ", " + dy + ", " + dz);
                                }
                                if (this.isOpaque(b2 = world.func_147439_a(dx, dy - 1, dz))) {
                                    flag2 = true;
                                } else if (b2.isAir((IBlockAccess)world, dx, dy - 1, dz)) {
                                    if (!world.field_72995_K) {
                                        b.func_149674_a(world, dx, dy, dz, rand);
                                        BlockTickEvent.fire((World)world, (int)dx, (int)dy, (int)dz, (Block)b, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                                        if (ModularLogger.instance.isEnabled(LOGGER_ID)) {
                                            ModularLogger.instance.log(LOGGER_ID, "Ticked apple leaf @ " + dx + ", " + dy + ", " + dz);
                                        }
                                    }
                                    flag2 = true;
                                }
                                drip = b2 != b && !this.isOpaque(b2);
                            } else if (n.endsWith("apple") && !world.field_72995_K) {
                                b.func_149674_a(world, dx, dy, dz, rand);
                                BlockTickEvent.fire((World)world, (int)dx, (int)dy, (int)dz, (Block)b, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                                flag2 = true;
                                if (ModularLogger.instance.isEnabled(LOGGER_ID)) {
                                    ModularLogger.instance.log(LOGGER_ID, "Ticked apple block @ " + dx + ", " + dy + ", " + dz);
                                }
                            }
                            if (ModularLogger.instance.isEnabled(LOGGER_ID)) {
                                ModularLogger.instance.log(LOGGER_ID, "Read GC block '" + n + "', flag2=" + flag2);
                            }
                        }
                        boolean bl = flag = this.isOpaque(b) || flag2;
                    }
                    if (flag) continue;
                    --dy;
                }
                if (!world.field_72995_K) continue;
                int d = Math.max(1, 5 - ConfigRegistry.SPRINKLER.getValue());
                if (rand.nextInt(d) == 0) {
                    world.func_72869_a("splash", (double)dx + rand.nextDouble(), (double)(dy + 1), (double)dz + rand.nextDouble(), 0.0, 0.0, 0.0);
                }
                if (!drip) continue;
                world.func_72869_a("dripWater", (double)dx + rand.nextDouble(), (double)dy, (double)dz + rand.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean isOpaque(Block b) {
        return b.func_149662_c() && !(b instanceof BlockLeavesBase);
    }

    public void spawnParticles(World world, int x, int y, int z) {
        int i;
        int d = Math.max(0, ConfigRegistry.SPRINKLER.getValue());
        double ypos = (double)y + 0.125;
        double r = (double)this.getRange() / 10.0;
        double py = (double)y - 0.1875 + 0.5;
        int n = (rand.nextInt(2) == 0 ? 1 : 0) + rand.nextInt(1 + d);
        for (i = 0; i < n; ++i) {
            double px = (float)(x - 1) + 2.0f * rand.nextFloat();
            double pz = (float)(z - 1) + 2.0f * rand.nextFloat();
            world.func_72869_a("splash", px + 0.5, py, pz + 0.5, 0.0, 0.0, 0.0);
        }
        for (double vel = 0.0; vel < r; vel += 0.1) {
            py = (double)y - 0.1875 + 0.5;
            n = (rand.nextInt(2) == 0 ? 1 : 0) + rand.nextInt(1 + d * 4);
            for (i = 0; i < n; ++i) {
                double vx = vel * (double)(-1.0f + rand.nextFloat() * 2.0f);
                double vz = vel * (double)(-1.0f + rand.nextFloat() * 2.0f);
                double px = (float)(x - 1) + 2.0f * rand.nextFloat();
                double pz = (float)(z - 1) + 2.0f * rand.nextFloat();
                world.func_72869_a("splash", px + 0.5, py, pz + 0.5, vx *= 1.05, 0.0, vz *= 1.05);
            }
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SPRINKLER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getCapacity() {
        return 180;
    }

    @Override
    public int getWaterConsumption() {
        return 3;
    }

    @Override
    public ForgeDirection getPipeDirection() {
        return ForgeDirection.UP;
    }

    static {
        ModularLogger.instance.addLogger((DragonAPIMod)RotaryCraft.instance, LOGGER_ID);
    }

    protected static enum Effects {
        FIREEXTINGUISH(20),
        CROPTICK(80),
        HYDRATEFARMLAND(15),
        APPLETICK(40);

        private final int randomChance;

        private Effects(int c) {
            this.randomChance = c;
        }

        protected boolean doChance(Random rand, float factor) {
            return rand.nextInt(Math.max(1, (int)((float)this.randomChance * factor))) == 0;
        }
    }
}

