/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Auxiliary;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityCoolingFin
extends RotaryCraftTileEntity
implements TemperatureTE {
    private int targetx;
    private int targety;
    private int targetz;
    private int temperature;
    public int ticks = 512;
    public FinSettings setting = FinSettings.FULL;

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h) != null) {
            Tamb -= 5;
        }
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i) != null) {
            Tamb = 2600;
        }
        if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151588_w) != null) {
            Tamb -= 15;
        }
        this.temperature = Tamb > this.temperature ? ++this.temperature : --this.temperature;
    }

    public int[] getTarget() {
        return new int[]{this.targetx, this.targety, this.targetz};
    }

    @Override
    public int getThermalDamage() {
        return this.temperature / 200;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.COOLINGFIN;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int temp;
        TemperatureTE tr;
        ++this.tickcount;
        if (this.ticks > 0) {
            this.ticks -= 8;
        }
        this.getTargetSide(world, x, y, z, meta);
        if (this.tickcount < this.setting.tickRate) {
            return;
        }
        this.tickcount = 0;
        this.updateTemperature(world, x, y, z, meta);
        TileEntity te = world.func_147438_o(this.targetx, this.targety, this.targetz);
        if (te instanceof TemperatureTE && (tr = (TemperatureTE)te).canBeCooledWithFins() && (temp = tr.getTemperature()) > this.temperature) {
            ++this.temperature;
            tr.addTemperature(-1);
        }
    }

    private void getTargetSide(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.targetx = x;
                this.targety = y - 1;
                this.targetz = z;
                break;
            }
            case 1: {
                this.targetx = x;
                this.targety = y + 1;
                this.targetz = z;
                break;
            }
            case 2: {
                this.targetx = x;
                this.targety = y;
                this.targetz = z - 1;
                break;
            }
            case 3: {
                this.targetx = x - 1;
                this.targety = y;
                this.targetz = z;
                break;
            }
            case 4: {
                this.targetx = x;
                this.targety = y;
                this.targetz = z + 1;
                break;
            }
            case 5: {
                this.targetx = x + 1;
                this.targety = y;
                this.targetz = z;
            }
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("tick", this.ticks);
        NBT.func_74768_a("setting", this.setting.ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.ticks = NBT.func_74762_e("tick");
        this.setting = FinSettings.list[NBT.func_74762_e("setting")];
    }

    @Override
    public void onEMP() {
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 2500;
    }

    public static enum FinSettings {
        FULL(20),
        HALF(40),
        QUARTER(80);

        public final int tickRate;
        private static final FinSettings[] list;

        private FinSettings(int n2) {
            this.tickRate = n2;
        }

        public FinSettings next() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        static {
            list = FinSettings.values();
        }
    }
}

