/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.ModInteract.PositionedStackWithTooltip;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCentrifuge;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiCentrifuge;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CentrifugeHandler
extends TemplateRecipeHandler {
    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (stack != null) {
            for (PositionedStack is : ((CentrifugeRecipe)((Object)this.arecipes.get(recipe))).getOtherStacks()) {
                if (!(is instanceof PositionedStackWithTooltip) || !gui.isMouseOver(is, recipe)) continue;
                currenttip.add(((PositionedStackWithTooltip)is).tooltip);
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public String getRecipeName() {
        return "Centrifuge";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/centrifugegui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 1, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(39, 16, 40, 40), "rccentri", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rccentri")) {
            Collection<ItemStack> li = RecipesCentrifuge.getRecipes().getAllCentrifugables();
            for (ItemStack is : li) {
                this.arecipes.add(new CentrifugeRecipe(is));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rccentri")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        int i;
        ArrayList<ItemStack> li;
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
        if (fs != null) {
            li = RecipesCentrifuge.getRecipes().getSources(fs.getFluid());
            for (i = 0; i < li.size(); ++i) {
                this.arecipes.add(new CentrifugeRecipe(li.get(i)));
            }
        }
        li = RecipesCentrifuge.getRecipes().getSources(result);
        for (i = 0; i < li.size(); ++i) {
            this.arecipes.add(new CentrifugeRecipe(li.get(i)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (RecipesCentrifuge.getRecipes().isCentrifugable(ingredient)) {
            this.arecipes.add(new CentrifugeRecipe(ingredient));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCentrifuge.class;
    }

    public void drawExtras(int recipe) {
        this.drawFluids(recipe);
    }

    private void drawFluids(int recipe) {
        CentrifugeRecipe r = (CentrifugeRecipe)((Object)this.arecipes.get(recipe));
        ItemStack in = r.input;
        FluidStack fs = RecipesCentrifuge.getRecipes().getFluidResult(in);
        if (fs != null) {
            Fluid f = fs.getFluid();
            IIcon ico = f.getIcon();
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            ReikaTextureHelper.bindTerrainTexture();
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            int x = 147;
            for (int i = 0; i < 4; ++i) {
                int y = 1 + i * 16;
                v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
                v5.func_78374_a((double)x, (double)(y + 16), 0.0, (double)u, (double)dv);
                v5.func_78374_a((double)(x + 16), (double)(y + 16), 0.0, (double)du, (double)dv);
                v5.func_78374_a((double)(x + 16), (double)y, 0.0, (double)du, (double)v);
            }
            v5.func_78374_a((double)x, 65.0, 0.0, (double)u, (double)v);
            v5.func_78374_a((double)x, 68.0, 0.0, (double)u, (double)dv);
            v5.func_78374_a((double)(x + 16), 68.0, 0.0, (double)du, (double)dv);
            v5.func_78374_a((double)(x + 16), 65.0, 0.0, (double)du, (double)v);
            v5.func_78381_a();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String s = f.getLocalizedName() + " (" + fs.amount + " mB) (" + RecipesCentrifuge.getRecipes().getFluidChance(in) + "%)";
            int l = fr.func_78256_a(s);
            fr.func_78276_b(s, 166 - l, 70, 0);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class CentrifugeRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ItemStack input;

        private CentrifugeRecipe(ItemStack in) {
            super((TemplateRecipeHandler)CentrifugeHandler.this);
            this.input = in;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> pos = new ArrayList<PositionedStack>();
            ChancedOutputList c = RecipesCentrifuge.getRecipes().getRecipeResult(this.input);
            Collection li = c.keySet();
            int dx = 80;
            int dy = 10;
            int i = 0;
            for (ItemStack is : li) {
                int x = dx + i % 3 * 18;
                int y = dy + i / 3 * 18;
                String tip = String.format("%.2f%s chance", Float.valueOf(c.getItemChance(is)), "%");
                pos.add((PositionedStack)new PositionedStackWithTooltip((Object)is, x, y, tip));
                ++i;
            }
            return pos;
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)ReikaItemHelper.getSizedItemStack((ItemStack)this.input, (int)1), 21, 28);
        }
    }
}

