/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.CachedConnection;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeRenderConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Auxiliary.Interfaces.RenderableDuct;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileEntityPiping
extends RotaryCraftTileEntity
implements RenderableDuct,
CachedConnection,
BreakAction,
PumpablePipe {
    private static final HashSet<Class> nonInteractableClasses = new HashSet();
    private static final HashSet<Class> interactableClasses = new HashSet();
    private static final int CAPACITY_LIMIT = 1000000000;
    public static final int UPPRESSURE = 40;
    public static final int HORIZPRESSURE = 20;
    public static final int DOWNPRESSURE = 0;
    private static final int MAXPRESSURE = 2400000;
    private boolean[] connections = new boolean[6];
    private boolean[] interaction = new boolean[6];
    private StepTimer flowTimer = new StepTimer(this.getTickDelay());

    public final int getPressure() {
        Fluid f = this.getFluidType();
        int amt = this.getFluidLevel();
        if (f == null || amt <= 0) {
            return 101300;
        }
        if (f.isGaseous()) {
            return 101300 + 128 * (int)((double)amt / 1000.0 * (double)f.getTemperature() * (double)Math.abs(f.getDensity()) / 1000.0);
        }
        return 101300 + amt * 24;
    }

    public int getMaxPressure() {
        return 2400000;
    }

    private void overpressure(World world, int x, int y, int z) {
        Fluid f = this.getFluidType();
        if (f.canBePlacedInWorld()) {
            world.func_147449_b(x, y, z, f.getBlock());
        } else {
            world.func_147468_f(x, y, z);
        }
        world.func_147471_g(x, y, z);
        world.func_147460_e(x, y, z, f.getBlock());
    }

    @Override
    public abstract int getFluidLevel();

    public abstract boolean canConnectToPipe(MachineRegistry var1);

    protected abstract void setFluid(Fluid var1);

    protected abstract void setLevel(int var1);

    protected abstract boolean interactsWithMachines();

    protected abstract void onIntake(TileEntity var1);

    public abstract boolean canReceiveFromPipeOn(ForgeDirection var1);

    public abstract boolean canEmitToPipeOn(ForgeDirection var1);

    public abstract boolean canIntakeFromIFluidHandler(ForgeDirection var1);

    public abstract boolean canOutputToIFluidHandler(ForgeDirection var1);

    public final boolean canIntakeFluid(Fluid f) {
        if (f == null) {
            return false;
        }
        return this.isValidFluid(f) && (this.getFluidType() == null || this.getFluidLevel() == 0 || this.getFluidType().equals(f));
    }

    public abstract boolean isValidFluid(Fluid var1);

    public static int getTickDelay() {
        int cfg = Math.max(ConfigRegistry.FLOWSPEED.getValue(), 1);
        if (cfg > 5) {
            cfg = 5;
        }
        return 6 - cfg;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        Fluid f2;
        if (this.getTicksExisted() < 5) {
            this.syncAllData(true);
            world.func_147471_g(x, y, z);
        }
        Fluid f = this.getFluidType();
        this.flowTimer.update();
        if (this.flowTimer.checkCap()) {
            this.intakeFluid(world, x, y, z);
            this.dumpContents(world, x, y, z);
        }
        if (this.getFluidLevel() <= 0) {
            this.setLevel(0);
            this.setFluid(null);
        }
        if (f != (f2 = this.getFluidType())) {
            this.syncAllData(true);
            world.func_147471_g(x, y, z);
        }
        if (this.getPressure() > this.getMaxPressure()) {
            if (world.field_72995_K) {
                ReikaPacketHelper.sendUpdatePacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.EXPLODE.ordinal(), (TileEntity)this, (PacketTarget)PacketTarget.server);
            } else {
                this.overpressure(world, x, y, z);
            }
        }
    }

    protected final void onFirstTick(World world, int x, int y, int z) {
        this.recomputeConnections(world, x, y, z);
    }

    public int getPacketDelay() {
        return 4 * super.getPacketDelay();
    }

    public final int getRedstoneOverride() {
        return 0;
    }

    protected final boolean canInteractWith(World world, int x, int y, int z, ForgeDirection side) {
        if (!this.connections[side.ordinal()]) {
            return false;
        }
        int dx = x + side.offsetX;
        int dy = y + side.offsetY;
        int dz = z + side.offsetZ;
        Block id = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        if (m != null && m.isPipe()) {
            return this.canConnectToPipe(m);
        }
        TileEntity te = this.getAdjacentTileEntity(side);
        if (te instanceof WorldRift) {
            return true;
        }
        return this.interactsWithMachines() && this.isInteractableTile(te, side);
    }

    private boolean isInteractableTile(TileEntity te, ForgeDirection side) {
        if (te == null) {
            return false;
        }
        if (te instanceof PipeRenderConnector) {
            return ((PipeRenderConnector)te).canConnectToPipeOnSide(side);
        }
        if (te instanceof IFluidHandler) {
            Class<?> c = te.getClass();
            if (interactableClasses.contains(c)) {
                return true;
            }
            if (nonInteractableClasses.contains(c)) {
                return false;
            }
            String name = c.getSimpleName().toLowerCase(Locale.ENGLISH);
            if (name.contains("conduit") || name.contains("fluidduct") || name.contains("pipe") || name.contains("multipart")) {
                nonInteractableClasses.add(c);
                return false;
            }
            interactableClasses.add(c);
            return true;
        }
        return false;
    }

    public final int getPipeIntake(int otherlevel) {
        return Math.min(1000000000 - this.getFluidLevel(), TransferAmount.QUARTER.getTransferred(otherlevel));
    }

    public final int getPipeOutput(int max) {
        return Math.min(TransferAmount.QUARTER.getTransferred(max), this.getFluidLevel() - 5);
    }

    private final void dumpContents(World world, int x, int y, int z) {
        Fluid f = this.getFluidType();
        if (this.getFluidLevel() <= 1 || f == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int added;
            int toadd;
            IFluidHandler fl;
            int level = this.getFluidLevel();
            if (level <= 0) {
                this.setFluid(null);
                return;
            }
            ForgeDirection dir = this.dirs[i];
            if (!this.interaction[i]) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te instanceof WorldRift) {
                if (world.field_72995_K) continue;
                WorldLocation loc = ((WorldRift)te).getLinkTarget();
                if (loc != null) {
                    if ((te = ((WorldRift)te).getTileEntityFrom(dir)) == null) continue;
                    dx = te.field_145851_c;
                    dy = te.field_145848_d;
                    dz = te.field_145849_e;
                    world = te.field_145850_b;
                }
            }
            if (te instanceof TileEntityPiping) {
                int otherlevel;
                int dL;
                int toadd2;
                TileEntityPiping tp = (TileEntityPiping)te;
                if (!this.canConnectToPipe(tp.getMachine()) || !this.canEmitToPipeOn(dir) || !tp.canReceiveFromPipeOn(dir.getOpposite()) || !tp.canIntakeFluid(f) || (toadd2 = this.getPipeOutput(dL = level - (otherlevel = tp.getFluidLevel()))) <= 0) continue;
                tp.addFluid(toadd2);
                this.removeLiquid(toadd2);
                continue;
            }
            if (te instanceof PipeConnector) {
                int toadd3;
                PipeConnector pc = (PipeConnector)te;
                Flow flow = pc.getFlowForSide(dir.getOpposite());
                if (!flow.canIntake || (toadd3 = this.getPipeOutput(this.getFluidLevel())) <= 0) continue;
                FluidStack fs = new FluidStack(f, toadd3);
                int added2 = pc.fill(dir.getOpposite(), fs, true);
                if (added2 <= 0) continue;
                this.removeLiquid(added2);
                continue;
            }
            if (!(te instanceof IFluidHandler) || !this.canOutputToIFluidHandler(dir) || !(fl = (IFluidHandler)te).canFill(dir.getOpposite(), f) || (toadd = this.getPipeOutput(this.getFluidLevel())) <= 0 || (added = fl.fill(dir.getOpposite(), new FluidStack(f, toadd), true)) <= 0) continue;
            this.removeLiquid(added);
        }
    }

    public final void removeLiquid(int toremove) {
        this.setLevel(this.getFluidLevel() - toremove);
    }

    public final void addFluid(int toadd) {
        this.setLevel(this.getFluidLevel() + toadd);
    }

    private final void intakeFluid(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            int level;
            int todrain;
            int todrain2;
            ForgeDirection dir = this.dirs[i];
            if (!this.interaction[i]) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te instanceof WorldRift) {
                if (world.field_72995_K) continue;
                WorldLocation loc = ((WorldRift)te).getLinkTarget();
                if (loc != null) {
                    if ((te = ((WorldRift)te).getTileEntityFrom(dir)) == null) continue;
                    dx = te.field_145851_c;
                    dy = te.field_145848_d;
                    dz = te.field_145849_e;
                    world = te.field_145850_b;
                }
            }
            if (te instanceof TileEntityPiping) {
                TileEntityPiping tp = (TileEntityPiping)te;
                if (!this.canConnectToPipe(tp.getMachine()) || !this.canReceiveFromPipeOn(dir) || !tp.canEmitToPipeOn(dir.getOpposite())) continue;
                Fluid f = tp.getFluidType();
                int amt = tp.getFluidLevel();
                int dL = amt - this.getFluidLevel();
                todrain2 = this.getPipeIntake(dL);
                if (todrain2 <= 0 || !this.canIntakeFluid(f)) continue;
                this.setFluid(f);
                this.addFluid(todrain2);
                tp.removeLiquid(todrain2);
                this.onIntake(te);
                continue;
            }
            if (te instanceof PipeConnector) {
                int level2;
                FluidStack fs;
                PipeConnector pc = (PipeConnector)te;
                Flow flow = pc.getFlowForSide(dir.getOpposite());
                if (!flow.canOutput || (fs = pc.drain(dir.getOpposite(), Integer.MAX_VALUE, false)) == null || (todrain2 = this.getPipeIntake(fs.amount - (level2 = this.getFluidLevel()))) <= 0 || !this.canIntakeFluid(fs.getFluid())) continue;
                this.addFluid(todrain2);
                this.setFluid(fs.getFluid());
                pc.drain(dir.getOpposite(), todrain2, true);
                this.onIntake(te);
                continue;
            }
            if (!(te instanceof IFluidHandler) || !this.canIntakeFromIFluidHandler(dir)) continue;
            IFluidHandler fl = (IFluidHandler)te;
            FluidStack fs = fl.drain(ForgeDirection.UNKNOWN, Integer.MAX_VALUE, false);
            if (fs == null || (todrain = this.getPipeIntake(fs.amount - (level = this.getFluidLevel()))) <= 0 || !this.canIntakeFluid(fs.getFluid())) continue;
            this.setFluid(fs.getFluid());
            this.onIntake(te);
            int drained = fl.drain((ForgeDirection)ForgeDirection.UNKNOWN, (int)todrain, (boolean)true).amount;
            this.addFluid(drained);
        }
    }

    @Override
    public final void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public final boolean hasModelTransparency() {
        return false;
    }

    @Override
    public boolean isConnectionValidForSide(ForgeDirection dir) {
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        return this.connections[dir.ordinal()];
    }

    public boolean isConnectedDirectly(ForgeDirection dir) {
        return this.connections[dir.ordinal()];
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public final void onEMP() {
    }

    @Override
    public abstract IIcon getBlockIcon();

    public abstract boolean hasLiquid();

    @Override
    public abstract Fluid getFluidType();

    @Override
    public void recomputeConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = this.shouldTryToConnect(this.dirs[i]);
            this.interaction[i] = this.canInteractWith(world, x, y, z, this.dirs[i]);
            world.func_147479_m(x + this.dirs[i].offsetX, y + this.dirs[i].offsetY, z + this.dirs[i].offsetZ);
        }
        this.syncAllData(true);
        world.func_147471_g(x, y, z);
        world.func_147479_m(x, y, z);
    }

    @Override
    public void deleteFromAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            if (m != this.getMachine()) continue;
            TileEntityPiping te = (TileEntityPiping)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = false;
            world.func_147479_m(dx, dy, dz);
        }
    }

    @Override
    public void addToAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
            if (m != this.getMachine()) continue;
            TileEntityPiping te = (TileEntityPiping)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = true;
            world.func_147479_m(dx, dy, dz);
        }
    }

    @Override
    public boolean shouldTryToConnect(ForgeDirection dir) {
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        MachineRegistry m = this.getMachine();
        MachineRegistry m2 = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, x, y, z);
        if (m != null && !m.isPipe() && m == m2) {
            return true;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile instanceof WorldRift) {
            return true;
        }
        if (tile instanceof TileEntityPiping) {
            return ((TileEntityPiping)tile).canConnectToPipe(m);
        }
        if (tile instanceof PipeConnector) {
            PipeConnector pc = (PipeConnector)tile;
            return pc.canConnectToPipe(this.getMachine()) && pc.canConnectToPipeOnSide(this.getMachine(), dir.getOpposite());
        }
        return this.isInteractableTile(tile, dir);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74774_a("conn", ReikaArrayHelper.booleanToByteBitflags((boolean[])this.connections));
        ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)NBT, (Fluid)this.getFluidType());
        NBT.func_74768_a("level", this.getFluidLevel());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        boolean update = false;
        boolean[] old = new boolean[this.connections.length];
        System.arraycopy(this.connections, 0, old, 0, old.length);
        this.connections = ReikaArrayHelper.booleanFromByteBitflags((byte)NBT.func_74771_c("conn"), (int)6);
        update = !Arrays.equals(old, this.connections);
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)NBT);
        update = update || f != this.getFluidType();
        this.setFluid(f);
        this.setLevel(NBT.func_74762_e("level"));
        if (this.field_145850_b != null && update) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean isConnectedToNonSelf(ForgeDirection dir) {
        if (!this.isConnectionValidForSide(dir)) {
            return false;
        }
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        int dx = this.field_145851_c + dir.offsetX;
        int dy = this.field_145848_d + dir.offsetY;
        int dz = this.field_145849_e + dir.offsetZ;
        World world = this.field_145850_b;
        Block b = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        return b != this.getMachine().getBlock() || meta != this.getMachine().getBlockMetadata();
    }

    @Override
    public IIcon getGlassIcon() {
        return Blocks.field_150359_w.func_149691_a(0, 0);
    }

    @Override
    public final boolean isFluidPipe() {
        return true;
    }

    @Override
    public IIcon getOverlayIcon() {
        return null;
    }

    public void breakBlock() {
        this.deleteFromAdjacentConnections(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public final boolean canTransferTo(PumpablePipe p, ForgeDirection dir) {
        return p instanceof TileEntityPiping && this.canConnectToPipe(((TileEntityPiping)p).getMachine());
    }

    @Override
    public final void transferFrom(PumpablePipe from, int amt) {
        TileEntityPiping te = (TileEntityPiping)from;
        this.setLevel(this.getFluidLevel() + amt);
        this.setFluid(te.getFluidType());
        te.setLevel(te.getFluidLevel() - amt);
        if (te.getFluidLevel() == 0) {
            te.setFluid(null);
        }
    }

    public static enum Flow {
        INPUT(true, false),
        OUTPUT(false, true),
        DUAL(true, true),
        NONE(false, false);

        public final boolean canIntake;
        public final boolean canOutput;
        public static final Flow[] list;

        private Flow(boolean in, boolean out) {
            this.canIntake = in;
            this.canOutput = out;
        }

        static {
            list = Flow.values();
        }
    }

    public static enum TransferAmount {
        UNITY,
        BUCKET,
        QUARTER,
        FORCEDQUARTER,
        ALL;


        public int getTransferred(int max) {
            if (max <= 0) {
                return 0;
            }
            switch (this) {
                case ALL: {
                    return max;
                }
                case FORCEDQUARTER: {
                    return max / 4 + 1;
                }
                case QUARTER: {
                    return max / 4;
                }
                case UNITY: {
                    return 1;
                }
                case BUCKET: {
                    return max > 1000 ? 1000 : max;
                }
            }
            return 1;
        }
    }
}

