/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidBase;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public abstract class PoweredLiquidProducer
extends PoweredLiquidBase
implements IFluidHandler,
PipeConnector,
IPipeConnection {
    protected final HybridTank tank = new HybridTank(ReikaStringParser.stripSpaces((String)this.getTEName().toLowerCase(Locale.ENGLISH)), this.getCapacity());

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public final boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canOutputTo(from) && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public final int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getContainedFluid() {
        return this.tank.getActualFluid();
    }

    public final void removeLiquid(int amt) {
        this.tank.removeLiquid(amt);
    }

    public final boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public abstract boolean canOutputTo(ForgeDirection var1);

    @Override
    public final boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canOutputTo(side) && this.canConnectToPipe(p);
    }

    public final IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        return type == IPipeTile.PipeType.FLUID ? (this.canOutputTo(side) ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT) : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public final TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return this.canOutputTo(side) ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }
}

