/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Event.Client.ResourceReloadEvent;
import Reika.DragonAPI.Instantiable.IO.XMLInterface;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModInteract.Power.ReikaEUHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaRFHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesFrictionHeater;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesMagnetizer;
import Reika.RotaryCraft.Base.TileEntity.EnergyToPowerBase;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.HandbookRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.Registry.PowerReceivers;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityEngineController;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityDistillery;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBorer;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityBeltHub;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityFlywheel;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public final class RotaryDescriptions {
    private static String PARENT = RotaryDescriptions.getParent();
    private static final String DESC_SUFFIX = ":desc";
    private static final String NOTE_SUFFIX = ":note";
    private static final String SUBNOTE_SUFFIX = ":sub";
    private static HashMap<HandbookRegistry, String> data = new HashMap();
    private static PluralMap<String> notes = new PluralMap(2);
    private static HashMap<MachineRegistry, Object[]> machineData = new HashMap();
    private static PluralMap<Object[]> machineNotes = new PluralMap(2);
    private static HashMap<HandbookRegistry, Object[]> miscData = new HashMap();
    private static HashMap<HandbookRegistry, Integer> lengths = new HashMap();
    private static ArrayList<HandbookRegistry> categories = new ArrayList();
    private static final boolean mustLoad = !ReikaObfuscationHelper.isDeObfEnvironment();
    private static final XMLInterface parents = new XMLInterface(RotaryCraft.class, PARENT + "categories.xml", mustLoad);
    private static final XMLInterface machines = new XMLInterface(RotaryCraft.class, PARENT + "machines.xml", mustLoad);
    private static final XMLInterface trans = new XMLInterface(RotaryCraft.class, PARENT + "trans.xml", mustLoad);
    private static final XMLInterface engines = new XMLInterface(RotaryCraft.class, PARENT + "engines.xml", mustLoad);
    private static final XMLInterface tools = new XMLInterface(RotaryCraft.class, PARENT + "tools.xml", mustLoad);
    private static final XMLInterface resources = new XMLInterface(RotaryCraft.class, PARENT + "resource.xml", mustLoad);
    private static final XMLInterface miscs = new XMLInterface(RotaryCraft.class, PARENT + "misc.xml", mustLoad);
    private static final XMLInterface infos = new XMLInterface(RotaryCraft.class, PARENT + "info.xml", mustLoad);

    public static void addCategory(HandbookRegistry h) {
        categories.add(h);
    }

    private static String getParent() {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.func_135034_a();
        if (RotaryDescriptions.hasLocalizedFor(language) && !"en_US".equals(lang)) {
            return "Resources/" + lang + "/";
        }
        return "Resources/";
    }

    private static boolean hasLocalizedFor(Language language) {
        String lang = language.func_135034_a();
        InputStream o = RotaryCraft.class.getResourceAsStream("Resources/" + lang + "/categories.xml");
        return o != null;
    }

    public static int getCategoryCount() {
        return categories.size();
    }

    public static String getTOC() {
        List<HandbookRegistry> toctabs = HandbookRegistry.getTOCTabs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toctabs.size(); ++i) {
            HandbookRegistry h = toctabs.get(i);
            sb.append("Page ");
            sb.append(h.getScreen());
            sb.append(" - ");
            sb.append(h.getTOCTitle());
            if (i >= toctabs.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void addData(MachineRegistry m, Object ... data) {
        machineData.put(m, data);
    }

    private static void addData(HandbookRegistry h, Object ... data) {
        miscData.put(h, data);
    }

    private static void addData(HandbookRegistry h, int[] data) {
        Object[] o = new Object[data.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = data[i];
        }
        miscData.put(h, o);
    }

    private static void addNotes(MachineRegistry m, Object ... data) {
        machineNotes.put((Object)data, new Object[]{m, 0});
    }

    private static void addSubNotes(MachineRegistry m, int subpage, Object ... data) {
        machineNotes.put((Object)data, new Object[]{m, subpage});
    }

    public static void reload() {
        PARENT = RotaryDescriptions.getParent();
        RotaryDescriptions.loadNumericalData();
        machines.reread();
        trans.reread();
        engines.reread();
        tools.reread();
        resources.reread();
        miscs.reread();
        infos.reread();
        parents.reread();
        RotaryDescriptions.loadData();
    }

    private static void addEntry(HandbookRegistry h, String sg) {
        data.put(h, sg);
    }

    public static void loadData() {
        String val;
        String desc;
        MachineRegistry m;
        String desc2;
        HandbookRegistry h;
        int i;
        List<HandbookRegistry> parenttabs = HandbookRegistry.getCategoryTabs();
        HandbookRegistry[] enginetabs = HandbookRegistry.getEngineTabs();
        List<HandbookRegistry> machinetabs = HandbookRegistry.getMachineTabs();
        HandbookRegistry[] transtabs = HandbookRegistry.getTransTabs();
        HandbookRegistry[] tooltabs = HandbookRegistry.getToolTabs();
        HandbookRegistry[] resourcetabs = HandbookRegistry.getResourceTabs();
        HandbookRegistry[] misctabs = HandbookRegistry.getMiscTabs();
        HandbookRegistry[] infotabs = HandbookRegistry.getInfoTabs();
        for (i = 0; i < parenttabs.size(); ++i) {
            h = parenttabs.get(i);
            desc2 = parents.getValueAtNode("categories:" + h.name().toLowerCase(Locale.ENGLISH).substring(0, h.name().length() - 4));
            RotaryDescriptions.addEntry(h, desc2);
        }
        for (i = 0; i < machinetabs.size(); ++i) {
            h = machinetabs.get(i);
            m = h.getMachine();
            desc = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
            String aux = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
            Collection sub = machines.getNodesWithin("machines:" + m.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX + SUBNOTE_SUFFIX);
            desc = String.format(desc, machineData.get((Object)m));
            aux = String.format(aux, (Object[])machineNotes.get(new Object[]{m, 0}));
            if ("#NULL!".equals(desc)) {
                desc = "There is no handbook data for this machine yet.";
            }
            if (m.isDummiedOut()) {
                desc = desc + "\nThis machine is currently unavailable.";
                if (m.getModDependency() != null && !m.getModDependency().isLoaded()) {
                    desc = desc + "\nThis machine depends on another mod.";
                }
                aux = aux + "\nNote: Dummied Out";
            }
            if (m.hasPrerequisite()) {
                aux = aux + "\nDependencies: " + m.getPrerequisite();
            }
            if (m.isIncomplete()) {
                desc = desc + "\nThis machine is incomplete. Use at your own risk.";
            }
            RotaryDescriptions.addEntry(h, desc);
            notes.put((Object)aux, new Object[]{h, 0});
            if (sub == null) continue;
            int k = 0;
            for (String s : sub) {
                String val2 = machines.getValueAtNode(s);
                val2 = String.format(val2, (Object[])machineNotes.get(new Object[]{m, k}));
                notes.put((Object)val2, new Object[]{h, k});
                lengths.put(h, ++k);
            }
        }
        for (i = 0; i < transtabs.length; ++i) {
            h = transtabs[i];
            m = h.getMachine();
            desc = trans.getValueAtNode("trans:" + h.name().toLowerCase(Locale.ENGLISH));
            Collection sub = trans.getNodesWithin("trans:" + h.name().toLowerCase(Locale.ENGLISH) + SUBNOTE_SUFFIX);
            if (sub != null && !sub.isEmpty()) {
                int k = 0;
                for (String s : sub) {
                    val = trans.getValueAtNode(s);
                    if (k == 0) {
                        val = String.format(val, machineData.get((Object)m));
                        val = String.format(val, miscData.get(h));
                        RotaryDescriptions.addEntry(h, val);
                    } else {
                        val = String.format(val, (Object[])machineNotes.get(new Object[]{m, k}));
                        notes.put((Object)val, new Object[]{h, k - 1});
                    }
                    lengths.put(h, ++k);
                }
                continue;
            }
            if ("#NULL!".equals(desc)) {
                desc = "There is no handbook data for this machine yet.";
            }
            if (machineData.containsKey((Object)m)) {
                desc = String.format(desc, machineData.get((Object)m));
            }
            if (miscData.containsKey(h)) {
                desc = String.format(desc, miscData.get(h));
            }
            RotaryDescriptions.addEntry(h, desc);
        }
        for (i = 0; i < tooltabs.length; ++i) {
            h = tooltabs[i];
            desc2 = tools.getValueAtNode("tools:" + h.name().toLowerCase(Locale.ENGLISH));
            Collection sub = tools.getNodesWithin("tools:" + h.name().toLowerCase(Locale.ENGLISH) + SUBNOTE_SUFFIX);
            if (sub != null && !sub.isEmpty()) {
                int k = 0;
                for (String s : sub) {
                    String val3 = tools.getValueAtNode(s);
                    if (k == 0) {
                        val3 = String.format(val3, miscData.get(h));
                        RotaryDescriptions.addEntry(h, val3);
                    } else {
                        notes.put((Object)val3, new Object[]{h, k - 1});
                    }
                    lengths.put(h, ++k);
                }
                continue;
            }
            RotaryDescriptions.addEntry(h, desc2);
        }
        for (i = 0; i < resourcetabs.length; ++i) {
            h = resourcetabs[i];
            desc2 = resources.getValueAtNode("resource:" + h.name().toLowerCase(Locale.ENGLISH));
            desc2 = String.format(desc2, miscData.get(h));
            RotaryDescriptions.addEntry(h, desc2);
        }
        for (i = 0; i < misctabs.length; ++i) {
            h = misctabs[i];
            desc2 = miscs.getValueAtNode("misc:" + h.name().toLowerCase(Locale.ENGLISH));
            desc2 = String.format(desc2, miscData.get(h));
            RotaryDescriptions.addEntry(h, desc2);
        }
        for (i = 0; i < infotabs.length; ++i) {
            h = infotabs[i];
            desc2 = infos.getValueAtNode("info:" + h.name().toLowerCase(Locale.ENGLISH));
            desc2 = String.format(desc2, miscData.get(h));
            RotaryDescriptions.addEntry(h, desc2);
        }
        for (i = 0; i < enginetabs.length; ++i) {
            String aux;
            h = enginetabs[i];
            Collection sub = null;
            if (i < EngineType.engineList.length) {
                EngineType e = EngineType.engineList[i];
                desc2 = engines.getValueAtNode("engines:" + e.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
                aux = engines.getValueAtNode("engines:" + e.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
                sub = engines.getNodesWithin("engines:" + e.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX + SUBNOTE_SUFFIX);
                desc2 = String.format(desc2, e.getTorque(), e.getSpeed(), e.getPowerForDisplay());
                aux = String.format(aux, e.getTorque(), e.getSpeed(), e.getPowerForDisplay());
            } else {
                desc2 = engines.getValueAtNode("engines:" + "solar".toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
                aux = engines.getValueAtNode("engines:" + "solar".toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
                desc2 = String.format(desc2, 512);
                aux = String.format(aux, 512);
            }
            data.put(h, desc2);
            notes.put((Object)aux, new Object[]{h, 0});
            if (sub == null) continue;
            int k = 0;
            for (String s : sub) {
                val = engines.getValueAtNode(s);
                if (k == 0 && i < EngineType.engineList.length) {
                    EngineType e = EngineType.engineList[i];
                    val = String.format(val, e.getTorque(), e.getSpeed(), e.getPowerForDisplay());
                }
                notes.put((Object)val, new Object[]{h, k});
                lengths.put(h, ++k);
            }
        }
    }

    public static String getData(HandbookRegistry h) {
        if (!data.containsKey(h)) {
            return "";
        }
        return data.get(h);
    }

    public static String getNotes(HandbookRegistry h, int subpage) {
        if (!notes.containsKeyV(new Object[]{h, --subpage})) {
            return "";
        }
        return (String)notes.get(new Object[]{h, subpage});
    }

    public static int getNotesLength(HandbookRegistry h) {
        return lengths.containsKey(h) ? lengths.get(h) : 1;
    }

    private static void loadNumericalData() {
        RotaryDescriptions.addData(HandbookRegistry.MATERIAL, 800.0, ReikaMathLibrary.getThousandBase((double)2.0E7), ReikaEngLibrary.getSIPrefix((double)2.0E7), ReikaMathLibrary.getThousandBase((double)1.16E7), ReikaEngLibrary.getSIPrefix((double)1.16E7), 3000.0, ReikaMathLibrary.getThousandBase((double)1.0E8), ReikaEngLibrary.getSIPrefix((double)1.0E8), ReikaMathLibrary.getThousandBase((double)4.0E7), ReikaEngLibrary.getSIPrefix((double)4.0E7), 7800.0, ReikaMathLibrary.getThousandBase((double)2.0E8), ReikaEngLibrary.getSIPrefix((double)2.0E8), ReikaMathLibrary.getThousandBase((double)1.16E8), ReikaEngLibrary.getSIPrefix((double)1.16E8), 7800.0, ReikaMathLibrary.getThousandBase((double)4.0E8), ReikaEngLibrary.getSIPrefix((double)4.0E8), ReikaMathLibrary.getThousandBase((double)2.8E8), ReikaEngLibrary.getSIPrefix((double)2.8E8), 19300.0, ReikaMathLibrary.getThousandBase((double)1.08E8), ReikaEngLibrary.getSIPrefix((double)1.08E8), ReikaMathLibrary.getThousandBase((double)6.26E7), ReikaEngLibrary.getSIPrefix((double)6.26E7), 3500.0, ReikaMathLibrary.getThousandBase((double)5.0E9), ReikaEngLibrary.getSIPrefix((double)5.0E9), ReikaMathLibrary.getThousandBase((double)2.9E9), ReikaEngLibrary.getSIPrefix((double)2.9E9));
        RotaryDescriptions.addData(HandbookRegistry.SHAFTS, MaterialRegistry.getAllLimitLoads());
        RotaryDescriptions.addData(HandbookRegistry.FLYWHEELS, TileEntityFlywheel.Flywheels.WOOD.maxSpeed, TileEntityFlywheel.Flywheels.STONE.maxSpeed, TileEntityFlywheel.Flywheels.IRON.maxSpeed, TileEntityFlywheel.Flywheels.GOLD.maxSpeed);
        RotaryDescriptions.addData(HandbookRegistry.MODINTERFACE, ReikaMathLibrary.getThousandBase((double)ReikaRFHelper.getWattsPerRF()), ReikaEngLibrary.getSIPrefix((double)ReikaRFHelper.getWattsPerRF()), 50, 80, 90);
        ArrayList<MachineRegistry> li = MachineRegistry.getEnchantableMachineList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < li.size(); ++i) {
            sb.append(li.get(i).getName());
            if (i >= li.size() - 1) continue;
            sb.append(", ");
        }
        RotaryDescriptions.addData(HandbookRegistry.ENCHANTING, sb.toString());
        RotaryDescriptions.addData(MachineRegistry.BORER, TileEntityBorer.DIGPOWER * 10, 512);
        RotaryDescriptions.addData(MachineRegistry.PILEDRIVER, 16384);
        RotaryDescriptions.addData(MachineRegistry.EXTRACTOR, PowerReceivers.EXTRACTOR.getMinTorque(0), PowerReceivers.EXTRACTOR.getMinSpeed(2));
        RotaryDescriptions.addData(MachineRegistry.RESERVOIR, 64);
        RotaryDescriptions.addData(MachineRegistry.FAN, PowerReceivers.FAN.getMinPower(), 0x200000L);
        RotaryDescriptions.addData(MachineRegistry.COMPACTOR, 550000, 800);
        RotaryDescriptions.addData(MachineRegistry.BLASTFURNACE, 600, 1000);
        RotaryDescriptions.addData(MachineRegistry.SCALECHEST, 972);
        RotaryDescriptions.addData(MachineRegistry.PURIFIER, 600);
        RotaryDescriptions.addData(MachineRegistry.GENERATOR, ReikaEUHelper.getWattsPerEU());
        RotaryDescriptions.addData(MachineRegistry.BELT, ((TileEntityBeltHub)MachineRegistry.BELT.createTEInstanceForRender(0)).getMaxTorque(), ((TileEntityBeltHub)MachineRegistry.BELT.createTEInstanceForRender(0)).getMaxSmoothSpeed());
        RotaryDescriptions.addData(MachineRegistry.CHAIN, ((TileEntityBeltHub)MachineRegistry.CHAIN.createTEInstanceForRender(0)).getMaxTorque(), ((TileEntityBeltHub)MachineRegistry.CHAIN.createTEInstanceForRender(0)).getMaxSmoothSpeed());
        RotaryDescriptions.addData(MachineRegistry.DYNAMO, 1024, 2048, 8192);
        RotaryDescriptions.addData(MachineRegistry.ITEMCANNON, 524288);
        RotaryDescriptions.addNotes(MachineRegistry.BEDROCKBREAKER, PowerReceivers.BEDROCKBREAKER.getMinPower(), PowerReceivers.BEDROCKBREAKER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FERMENTER, PowerReceivers.FERMENTER.getMinPower(), PowerReceivers.FERMENTER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.GRINDER, PowerReceivers.GRINDER.getMinPower(), PowerReceivers.GRINDER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FLOODLIGHT, PowerReceivers.FLOODLIGHT.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.HEATRAY, PowerReceivers.HEATRAY.getMinPower(), PowerReceivers.HEATRAY.getMinPower(), 256);
        RotaryDescriptions.addNotes(MachineRegistry.PILEDRIVER, 16384, PowerReceivers.PILEDRIVER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.AEROSOLIZER, PowerReceivers.AEROSOLIZER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.LIGHTBRIDGE, PowerReceivers.LIGHTBRIDGE.getMinPower(), PowerReceivers.LIGHTBRIDGE.getMinPower() / (long)ConfigRegistry.BRIDGERANGE.getValue());
        RotaryDescriptions.addNotes(MachineRegistry.EXTRACTOR, PowerReceivers.EXTRACTOR.getMinPower(0), PowerReceivers.EXTRACTOR.getMinPower(1), PowerReceivers.EXTRACTOR.getMinPower(2), PowerReceivers.EXTRACTOR.getMinPower(3), PowerReceivers.EXTRACTOR.getMinTorque(0), PowerReceivers.EXTRACTOR.getMinTorque(3), PowerReceivers.EXTRACTOR.getMinSpeed(1), PowerReceivers.EXTRACTOR.getMinSpeed(2));
        RotaryDescriptions.addNotes(MachineRegistry.PULSEJET, PowerReceivers.PULSEJET.getMinSpeed(), 1000);
        RotaryDescriptions.addNotes(MachineRegistry.PUMP, PowerReceivers.PUMP.getMinPower(), PowerReceivers.PUMP.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.RESERVOIR, 64);
        RotaryDescriptions.addNotes(MachineRegistry.FAN, PowerReceivers.FAN.getMinPower(), 1024, 512, 64);
        RotaryDescriptions.addNotes(MachineRegistry.COMPACTOR, PowerReceivers.COMPACTOR.getMinPower(), PowerReceivers.COMPACTOR.getMinTorque(), 550000, 800, 600000, 1000);
        RotaryDescriptions.addNotes(MachineRegistry.AUTOBREEDER, PowerReceivers.AUTOBREEDER.getMinPower(), PowerReceivers.AUTOBREEDER.getMinPower(), 2048);
        RotaryDescriptions.addNotes(MachineRegistry.BAITBOX, PowerReceivers.BAITBOX.getMinPower(), PowerReceivers.BAITBOX.getMinPower(), 4096);
        RotaryDescriptions.addNotes(MachineRegistry.FIREWORK, PowerReceivers.FIREWORK.getMinPower(), PowerReceivers.FIREWORK.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.FRACTIONATOR, PowerReceivers.FRACTIONATOR.getMinPower(), PowerReceivers.FRACTIONATOR.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.GPR, PowerReceivers.GPR.getMinPower(), PowerReceivers.GPR.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.HEATER, PowerReceivers.HEATER.getMinPower(), 2000);
        RotaryDescriptions.addNotes(MachineRegistry.OBSIDIAN, PowerReceivers.OBSIDIAN.getMinPower(), PowerReceivers.OBSIDIAN.getMinSpeed(), 1000, 320000);
        RotaryDescriptions.addNotes(MachineRegistry.PLAYERDETECTOR, 128, 100, 32);
        RotaryDescriptions.addNotes(MachineRegistry.SPAWNERCONTROLLER, PowerReceivers.SPAWNERCONTROLLER.getMinPower(), 800);
        RotaryDescriptions.addNotes(MachineRegistry.VACUUM, PowerReceivers.VACUUM.getMinPower(), PowerReceivers.VACUUM.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.WOODCUTTER, PowerReceivers.WOODCUTTER.getMinPower(), PowerReceivers.WOODCUTTER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.MOBRADAR, PowerReceivers.MOBRADAR.getMinPower(), PowerReceivers.MOBRADAR.getMinPower(), 1024);
        RotaryDescriptions.addNotes(MachineRegistry.TNTCANNON, PowerReceivers.TNTCANNON.getMinPower(), PowerReceivers.TNTCANNON.getMinTorque());
        int fudge = 100;
        RotaryDescriptions.addNotes(MachineRegistry.SONICWEAPON, PowerReceivers.SONICWEAPON.getMinPower(), PowerReceivers.SONICWEAPON.getMinPower(), 16384, 1807500L / (long)fudge, 3906200L / (long)fudge, 2971000L / (long)fudge, 100000000L / (long)fudge);
        RotaryDescriptions.addNotes(MachineRegistry.FORCEFIELD, PowerReceivers.FORCEFIELD.getMinPower(), PowerReceivers.FORCEFIELD.getMinPower(), 32768);
        RotaryDescriptions.addNotes(MachineRegistry.MUSICBOX, 1024);
        RotaryDescriptions.addNotes(MachineRegistry.MOBHARVESTER, PowerReceivers.MOBHARVESTER.getMinPower(), PowerReceivers.MOBHARVESTER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.PROJECTOR, PowerReceivers.PROJECTOR.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.RAILGUN, PowerReceivers.RAILGUN.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.WEATHERCONTROLLER, PowerReceivers.WEATHERCONTROLLER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.REFRESHER, PowerReceivers.REFRESHER.getMinPower(), PowerReceivers.REFRESHER.getMinPower(), 1024);
        RotaryDescriptions.addNotes(MachineRegistry.CAVESCANNER, PowerReceivers.CAVESCANNER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.SCALECHEST, PowerReceivers.SCALECHEST.getMinPower(), PowerReceivers.SCALECHEST.getMinPower(), 128, 972);
        RotaryDescriptions.addNotes(MachineRegistry.IGNITER, PowerReceivers.IGNITER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.FREEZEGUN, PowerReceivers.FREEZEGUN.getMinPower(), PowerReceivers.FREEZEGUN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.MAGNETIZER, PowerReceivers.MAGNETIZER.getMinPower(), PowerReceivers.MAGNETIZER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.CONTAINMENT, PowerReceivers.CONTAINMENT.getMinPower(), PowerReceivers.CONTAINMENT.getMinPower(), 8192, 524288, 0x200000);
        RotaryDescriptions.addNotes(MachineRegistry.SCREEN, PowerReceivers.SCREEN.getMinPower(), PowerReceivers.SCREEN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.PURIFIER, PowerReceivers.PURIFIER.getMinPower(), PowerReceivers.PURIFIER.getMinTorque(), 600);
        RotaryDescriptions.addNotes(MachineRegistry.LASERGUN, PowerReceivers.LASERGUN.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.ITEMCANNON, PowerReceivers.ITEMCANNON.getMinPower(), PowerReceivers.ITEMCANNON.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FRICTION, PowerReceivers.FRICTION.getMinPower(), PowerReceivers.FRICTION.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.BUCKETFILLER, PowerReceivers.BUCKETFILLER.getMinPower(), PowerReceivers.BUCKETFILLER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.BLOCKCANNON, PowerReceivers.BLOCKCANNON.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.COMPRESSOR, 1000);
        RotaryDescriptions.addNotes(MachineRegistry.LAMP, 12);
        RotaryDescriptions.addNotes(MachineRegistry.ECU, TileEntityEngineController.getSettingsAsString());
        RotaryDescriptions.addNotes(MachineRegistry.BLASTFURNACE, Float.valueOf(0.6f));
        RotaryDescriptions.addNotes(MachineRegistry.FUELENHANCER, PowerReceivers.FUELENHANCER.getMinPower(), PowerReceivers.FUELENHANCER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.ARROWGUN, PowerReceivers.ARROWGUN.getMinPower(), PowerReceivers.ARROWGUN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FERTILIZER, PowerReceivers.FERTILIZER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.AGGREGATOR, PowerReceivers.AGGREGATOR.getMinPower(), PowerReceivers.AGGREGATOR.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.FUELENGINE, 2048, 256, 524288);
        RotaryDescriptions.addNotes(MachineRegistry.AIRGUN, PowerReceivers.AIRGUN.getMinPower(), PowerReceivers.AIRGUN.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.SONICBORER, PowerReceivers.SONICBORER.getMinPower(), PowerReceivers.SONICBORER.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.FILLINGSTATION, PowerReceivers.FILLINGSTATION.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.SORTING, PowerReceivers.SORTING.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.DEFOLIATOR, PowerReceivers.DEFOLIATOR.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.BIGFURNACE, PowerReceivers.BIGFURNACE.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.DISTILLER, TileEntityDistillery.getValidConversions());
        RotaryDescriptions.addNotes(MachineRegistry.CRYSTALLIZER, PowerReceivers.CRYSTALLIZER.getMinPower(), PowerReceivers.CRYSTALLIZER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.GRINDSTONE, PowerReceivers.GRINDSTONE.getMinPower(), PowerReceivers.GRINDSTONE.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.BLOWER, PowerReceivers.BLOWER.getMinPower(), PowerReceivers.BLOWER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.REFRIGERATOR, PowerReceivers.REFRIGERATOR.getMinPower(), PowerReceivers.REFRIGERATOR.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.COMPOSTER, 40, 70);
        RotaryDescriptions.addNotes(MachineRegistry.GASTANK, PowerReceivers.GASTANK.getMinPower(), PowerReceivers.GASTANK.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.CRAFTER, PowerReceivers.CRAFTER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.ANTIAIR, PowerReceivers.ANTIAIR.getMinPower(), PowerReceivers.ANTIAIR.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.PIPEPUMP, PowerReceivers.PIPEPUMP.getMinPower(), PowerReceivers.PIPEPUMP.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.CENTRIFUGE, PowerReceivers.CENTRIFUGE.getMinPower(), PowerReceivers.CENTRIFUGE.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.WETTER, PowerReceivers.WETTER.getMinPower(), PowerReceivers.WETTER.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.CHUNKLOADER, PowerReceivers.CHUNKLOADER.getMinSpeed(), 0, PowerReceivers.CHUNKLOADER.getMinSpeed(), 524288);
        RotaryDescriptions.addNotes(MachineRegistry.DROPS, PowerReceivers.DROPS.getMinPower(), PowerReceivers.DROPS.getMinTorque());
        RotaryDescriptions.addNotes(MachineRegistry.SPILLER, PowerReceivers.SPILLER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.FILLER, PowerReceivers.FILLER.getMinPower());
        RotaryDescriptions.addNotes(MachineRegistry.GATLING, PowerReceivers.GATLING.getMinPower(), PowerReceivers.GATLING.getMinSpeed());
        RotaryDescriptions.addNotes(MachineRegistry.MAGNETIC, 500);
        RotaryDescriptions.addNotes(MachineRegistry.PNEUENGINE, 500);
        RotaryDescriptions.addNotes(MachineRegistry.ELECTRICMOTOR, 500);
        RotaryDescriptions.addNotes(MachineRegistry.STEAMTURBINE, 500);
        RotaryDescriptions.addNotes(MachineRegistry.EMP, 4184000000L);
        RotaryDescriptions.addSubNotes(MachineRegistry.MAGNETIC, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.PNEUENGINE, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.ELECTRICMOTOR, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.STEAMTURBINE, 1, EnergyToPowerBase.getTiersAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.MAGNETIZER, 1, RecipesMagnetizer.getRecipes().getRecipesAsString());
        RotaryDescriptions.addSubNotes(MachineRegistry.ADVANCEDGEARS, 1, TileEntityAdvancedGear.getMaxStorageCapacity(false), TileEntityAdvancedGear.getMaxStorageCapacityFormatted(false), TileEntityAdvancedGear.getMaxStorageCapacity(true), TileEntityAdvancedGear.getMaxStorageCapacityFormatted(true));
        RotaryDescriptions.addSubNotes(MachineRegistry.ADVANCEDGEARS, 2, TileEntityAdvancedGear.getRequiredInputTorque(), TileEntityAdvancedGear.getRequiredInputPower());
        RotaryDescriptions.addSubNotes(MachineRegistry.ADVANCEDGEARS, 3, TileEntityAdvancedGear.getOutputCap(false), TileEntityAdvancedGear.getOutputCap(false), TileEntityAdvancedGear.getOutputCap(true), TileEntityAdvancedGear.getOutputCap(true), TileEntityAdvancedGear.getOutputFunction());
        RotaryDescriptions.addData(HandbookRegistry.TUNGSTEN, RecipesFrictionHeater.getRecipes().getRecipeByInput((ItemStack)ItemStacks.tungstenflakes).requiredTemperature);
    }

    public static String getParentPage() {
        return PARENT;
    }

    static {
        RotaryDescriptions.loadNumericalData();
        MinecraftForge.EVENT_BUS.register((Object)new ReloadListener());
    }

    public static class ReloadListener {
        @SubscribeEvent
        public void reload(ResourceReloadEvent evt) {
            RotaryDescriptions.reload();
        }
    }
}

