/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class HarvestGoddess
extends RingToggle
implements IPedestalItem {
    public HarvestGoddess() {
        super("harvest_god");
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K || par4 > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, par4, par5);
        EntityPlayer player = (EntityPlayer)entity;
        if (stack.func_77960_j() != 0) {
            double storedEmc = HarvestGoddess.getEmc(stack);
            if (storedEmc == 0.0 && !HarvestGoddess.consumeFuel(player, stack, 64.0, true)) {
                stack.func_77964_b(0);
            } else {
                WorldHelper.growNearbyRandomly(true, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, player);
                HarvestGoddess.removeEmc(stack, 0.32f);
            }
        } else {
            WorldHelper.growNearbyRandomly(false, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, player);
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (world.field_72995_K || !player.func_82247_a(x, y, z, par7, stack)) {
            return false;
        }
        if (player.func_70093_af()) {
            Object[] obj = this.getStackFromInventory(player.field_71071_by.field_70462_a, Items.field_151100_aR, 15, 4);
            if (obj == null) {
                return false;
            }
            ItemStack boneMeal = (ItemStack)obj[1];
            if (boneMeal != null && this.useBoneMeal(world, x, y, z)) {
                player.field_71071_by.func_70298_a(((Integer)obj[0]).intValue(), 4);
                player.field_71069_bz.func_75142_b();
                return true;
            }
            return false;
        }
        return this.plantSeeds(world, player, x, y, z);
    }

    private boolean useBoneMeal(World world, int xCoord, int yCoord, int zCoord) {
        boolean result = false;
        for (int x = xCoord - 15; x <= xCoord + 15; ++x) {
            for (int z = zCoord - 15; z <= zCoord + 15; ++z) {
                IGrowable growable;
                Block crop = world.func_147439_a(x, yCoord, z);
                if (!(crop instanceof IGrowable) || !(growable = (IGrowable)crop).func_149852_a(world, world.field_73012_v, x, yCoord, z)) continue;
                if (!result) {
                    result = true;
                }
                growable.func_149853_b(world, world.field_73012_v, x, yCoord, z);
            }
        }
        return result;
    }

    private boolean plantSeeds(World world, EntityPlayer player, int xCoord, int yCoord, int zCoord) {
        boolean result = false;
        List<StackWithSlot> seeds = this.getAllSeeds(player.field_71071_by.field_70462_a);
        if (seeds.isEmpty()) {
            return false;
        }
        for (int x = xCoord - 8; x <= xCoord + 8; ++x) {
            for (int z = zCoord - 8; z <= zCoord + 8; ++z) {
                Block block = player.field_70170_p.func_147439_a(x, yCoord, z);
                if (block == null || block == Blocks.field_150350_a) continue;
                for (int i = 0; i < seeds.size(); ++i) {
                    StackWithSlot s = seeds.get(i);
                    IPlantable plant = s.stack.func_77973_b() instanceof IPlantable ? (IPlantable)s.stack.func_77973_b() : (IPlantable)Block.func_149634_a((Item)s.stack.func_77973_b());
                    if (!block.canSustainPlant((IBlockAccess)world, x, yCoord, z, ForgeDirection.UP, plant) || !world.func_147437_c(x, yCoord + 1, z)) continue;
                    world.func_147449_b(x, yCoord + 1, z, plant.getPlant((IBlockAccess)world, x, yCoord + 1, z));
                    player.field_71071_by.func_70298_a(s.slot, 1);
                    player.field_71069_bz.func_75142_b();
                    --s.stack.field_77994_a;
                    if (s.stack.field_77994_a <= 0) {
                        seeds.remove(i);
                    }
                    if (result) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    private List<StackWithSlot> getAllSeeds(ItemStack[] inv) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < inv.length; ++i) {
            ItemStack stack = inv[i];
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof IPlantable) {
                result.add(new StackWithSlot(stack, i));
                continue;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block == null || !(block instanceof IPlantable)) continue;
            result.add(new StackWithSlot(stack, i));
        }
        return result;
    }

    private Object[] getStackFromInventory(ItemStack[] inv, Item item, int meta, int minAmount) {
        Object[] obj = new Object[2];
        for (int i = 0; i < inv.length; ++i) {
            ItemStack stack = inv[i];
            if (stack == null || stack.field_77994_a < minAmount || stack.func_77973_b() != item || stack.func_77960_j() != meta) continue;
            obj[0] = i;
            obj[1] = stack;
            return obj;
        }
        return null;
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            if (HarvestGoddess.getEmc(stack) != 0.0 || HarvestGoddess.consumeFuel(player, stack, 64.0, true)) {
                stack.func_77964_b(1);
            }
        } else {
            stack.func_77964_b(0);
        }
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.harvestPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() == 0) {
                WorldHelper.growNearbyRandomly(true, world, x, y, z, null);
                tile.setActivityCooldown(ProjectEConfig.harvestPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.harvestPedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.harvestgod.pedestal1"));
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.harvestgod.pedestal2"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.harvestgod.pedestal3"), MathUtils.tickToSecFormatted(ProjectEConfig.harvestPedCooldown)));
        }
        return list;
    }

    private class StackWithSlot {
        public final int slot;
        public final ItemStack stack;

        public StackWithSlot(ItemStack stack, int slot) {
            this.stack = stack.func_77946_l();
            this.slot = slot;
        }
    }
}

