/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IAlchBagItem;
import moze_intel.projecte.api.item.IAlchChestItem;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PELogger;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class GemEternalDensity
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IModeChanger,
IBauble {
    @SideOnly(value=Side.CLIENT)
    private IIcon gemOff;
    @SideOnly(value=Side.CLIENT)
    private IIcon gemOn;

    public GemEternalDensity() {
        this.func_77655_b("gem_density");
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        GemEternalDensity.condense(stack, ((EntityPlayer)entity).field_71071_by.field_70462_a);
    }

    public static boolean condense(ItemStack gem, ItemStack[] inv) {
        if (gem.func_77960_j() == 0 || ItemPE.getEmc(gem) >= 1.073741824E9) {
            return false;
        }
        boolean hasChanged = false;
        boolean isWhitelist = GemEternalDensity.isWhitelistMode(gem);
        List<ItemStack> whitelist = GemEternalDensity.getWhitelist(gem);
        ItemStack target = GemEternalDensity.getTarget(gem);
        for (int i = 0; i < inv.length; ++i) {
            ItemStack s = inv[i];
            if (s == null || !EMCHelper.doesItemHaveEmc(s) || s.func_77976_d() == 1 || EMCHelper.getEmcValue(s) >= EMCHelper.getEmcValue(target) || (!isWhitelist || !GemEternalDensity.listContains(whitelist, s)) && (isWhitelist || GemEternalDensity.listContains(whitelist, s))) continue;
            ItemStack copy = s.func_77946_l();
            copy.field_77994_a = s.field_77994_a == 1 ? 1 : s.field_77994_a / 2;
            GemEternalDensity.addToList(gem, copy);
            s.field_77994_a -= copy.field_77994_a;
            if (s.field_77994_a <= 0) {
                inv[i] = null;
            }
            ItemPE.addEmcToStack(gem, EMCHelper.getEmcValue(copy) * copy.field_77994_a);
            hasChanged = true;
            break;
        }
        int value = EMCHelper.getEmcValue(target);
        if (!EMCHelper.doesItemHaveEmc(target)) {
            return hasChanged;
        }
        while (GemEternalDensity.getEmc(gem) >= (double)value) {
            ItemStack remain = ItemHelper.pushStackInInv(inv, ItemStack.func_77944_b((ItemStack)target));
            if (remain != null) {
                return false;
            }
            ItemPE.removeEmc(gem, value);
            GemEternalDensity.setItems(gem, Lists.newArrayList());
            hasChanged = true;
        }
        return hasChanged;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                if (stack.func_77960_j() == 1) {
                    List<ItemStack> items = GemEternalDensity.getItems(stack);
                    if (!items.isEmpty()) {
                        WorldHelper.createLootDrop(items, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        GemEternalDensity.setItems(stack, new ArrayList<ItemStack>());
                        ItemPE.setEmc(stack, 0.0);
                    }
                    stack.func_77964_b(0);
                } else {
                    stack.func_77964_b(1);
                }
            } else {
                player.openGui((Object)PECore.instance, 15, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
        return stack;
    }

    private String getTargetName(ItemStack stack) {
        switch (stack.field_77990_d.func_74771_c("Target")) {
            case 0: {
                return "item.ingotIron.name";
            }
            case 1: {
                return "item.ingotGold.name";
            }
            case 2: {
                return "item.diamond.name";
            }
            case 3: {
                return "item.pe_matter_dark.name";
            }
            case 4: {
                return "item.pe_matter_red.name";
            }
        }
        return "INVALID";
    }

    private static ItemStack getTarget(ItemStack stack) {
        switch (stack.field_77990_d.func_74771_c("Target")) {
            case 0: {
                return new ItemStack(Items.field_151042_j);
            }
            case 1: {
                return new ItemStack(Items.field_151043_k);
            }
            case 2: {
                return new ItemStack(Items.field_151045_i);
            }
            case 3: {
                return new ItemStack(ObjHandler.matter, 1, 0);
            }
            case 4: {
                return new ItemStack(ObjHandler.matter, 1, 1);
            }
        }
        PELogger.logFatal("Invalid target for gem of eternal density: " + stack.field_77990_d.func_74771_c("Target"));
        return null;
    }

    private static void setItems(ItemStack stack, List<ItemStack> list) {
        NBTTagList tList = new NBTTagList();
        for (ItemStack s : list) {
            NBTTagCompound nbt = new NBTTagCompound();
            s.func_77955_b(nbt);
            tList.func_74742_a((NBTBase)nbt);
        }
        stack.field_77990_d.func_74782_a("Consumed", (NBTBase)tList);
    }

    private static List<ItemStack> getItems(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        NBTTagList tList = stack.field_77990_d.func_150295_c("Consumed", 10);
        for (int i = 0; i < tList.func_74745_c(); ++i) {
            list.add(ItemStack.func_77949_a((NBTTagCompound)tList.func_150305_b(i)));
        }
        return list;
    }

    private static void addToList(ItemStack gem, ItemStack stack) {
        List<ItemStack> list = GemEternalDensity.getItems(gem);
        GemEternalDensity.addToList(list, stack);
        GemEternalDensity.setItems(gem, list);
    }

    private static void addToList(List<ItemStack> list, ItemStack stack) {
        boolean hasFound = false;
        for (ItemStack s : list) {
            if (s.field_77994_a >= s.func_77976_d() || !ItemHelper.areItemStacksEqual(s, stack)) continue;
            int remain = s.func_77976_d() - s.field_77994_a;
            if (stack.field_77994_a <= remain) {
                s.field_77994_a += stack.field_77994_a;
                hasFound = true;
                break;
            }
            s.field_77994_a += remain;
            stack.field_77994_a -= remain;
        }
        if (!hasFound) {
            list.add(stack);
        }
    }

    private static boolean isWhitelistMode(ItemStack stack) {
        return stack.field_77990_d.func_74767_n("Whitelist");
    }

    private static List<ItemStack> getWhitelist(ItemStack stack) {
        ArrayList result = Lists.newArrayList();
        NBTTagList list = stack.field_77990_d.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            result.add(ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i)));
        }
        return result;
    }

    private static boolean listContains(List<ItemStack> list, ItemStack stack) {
        for (ItemStack s : list) {
            if (!ItemHelper.areItemStacksEqual(s, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte getMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74771_c("Target");
        }
        return 0;
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        byte oldMode = this.getMode(stack);
        if (oldMode == 4) {
            stack.field_77990_d.func_74774_a("Target", (byte)0);
        } else {
            stack.field_77990_d.func_74774_a("Target", (byte)(oldMode + 1));
        }
        player.func_146105_b(new ChatComponentTranslation("pe.gemdensity.mode_switch", new Object[0]).func_150258_a(" ").func_150257_a((IChatComponent)new ChatComponentTranslation(this.getTargetName(stack), new Object[0])));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"pe.gemdensity.tooltip1"));
        if (stack.func_77942_o()) {
            list.add(String.format(StatCollector.func_74838_a((String)"pe.gemdensity.tooltip2"), StatCollector.func_74838_a((String)this.getTargetName(stack))));
        }
        list.add(String.format(StatCollector.func_74838_a((String)"pe.gemdensity.tooltip3"), ClientKeyHelper.getKeyName(PEKeybind.MODE)));
        list.add(StatCollector.func_74838_a((String)"pe.gemdensity.tooltip4"));
        list.add(StatCollector.func_74838_a((String)"pe.gemdensity.tooltip5"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int dmg) {
        return dmg == 0 ? this.gemOff : this.gemOn;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.gemOn = register.func_94245_a(this.getTexture("dense_gem_on"));
        this.gemOff = register.func_94245_a(this.getTexture("dense_gem_off"));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInAlchChest(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77960_j() == 1) {
            AlchChestTile tile = (AlchChestTile)world.func_147438_o(x, y, z);
            GemEternalDensity.condense(stack, tile.getBackingInventoryArray());
            tile.func_70296_d();
        }
    }

    @Override
    public boolean updateInAlchBag(ItemStack[] inv, EntityPlayer player, ItemStack stack) {
        return !player.field_70170_p.field_72995_K && GemEternalDensity.condense(stack, inv);
    }
}

