/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableUUID
extends SyncableObjectBase {
    private UUID uuid;

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        long msb = stream.readLong();
        long lsb = stream.readLong();
        this.uuid = new UUID(msb, lsb);
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeLong(this.uuid.getMostSignificantBits());
        stream.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74772_a("MSB", this.uuid.getMostSignificantBits());
        result.func_74772_a("LSB", this.uuid.getLeastSignificantBits());
        nbt.func_74782_a(name, (NBTBase)result);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound data = nbt.func_74775_l(name);
        long msb = data.func_74763_f("MSB");
        long lsb = data.func_74763_f("LSB");
        this.uuid = new UUID(msb, lsb);
    }

    public void setValue(UUID value) {
        this.uuid = value;
        this.markDirty();
    }

    public UUID getValue() {
        return this.uuid;
    }
}

