/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import openmods.api.IValueProvider;
import openmods.liquids.GenericTank;
import openmods.sync.ISyncableObject;
import openmods.utils.ByteUtils;

public class SyncableTank
extends GenericTank
implements ISyncableObject,
IValueProvider<FluidStack> {
    private boolean dirty = false;

    public SyncableTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity, acceptableFluids);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        if (stream.readBoolean()) {
            int fluidId = ByteUtils.readVLI(stream);
            int fluidAmount = stream.readInt();
            NBTTagCompound tag = null;
            if (stream.readBoolean()) {
                tag = CompressedStreamTools.func_74796_a((InputStream)stream);
            }
            this.fluid = new FluidStack(fluidId, fluidAmount, tag);
        } else {
            this.fluid = null;
        }
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        if (this.fluid != null) {
            stream.writeBoolean(true);
            ByteUtils.writeVLI(stream, this.fluid.fluidID);
            stream.writeInt(this.fluid.amount);
            if (this.fluid.tag != null) {
                stream.writeBoolean(true);
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.fluid.tag, (OutputStream)stream);
            } else {
                stream.writeBoolean(false);
            }
        } else {
            stream.writeBoolean(false);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        this.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.readFromNBT(tag);
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        int filled = super.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.markDirty();
        }
        return filled;
    }

    @Override
    public FluidStack drain(FluidStack stack, boolean doDrain) {
        FluidStack drained = super.drain(stack, doDrain);
        if (doDrain && drained != null) {
            this.markDirty();
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        if (doDrain && drained != null) {
            this.markDirty();
        }
        return drained;
    }

    @Override
    public FluidStack getValue() {
        FluidStack stack = super.getFluid();
        return stack != null ? stack.copy() : null;
    }
}

