/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import openmods.Log;
import openmods.sync.DummySyncableObject;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;

public class SyncObjectScanner {
    public static final SyncObjectScanner INSTANCE = new SyncObjectScanner();
    private static final Comparator<Field> FIELD_NAME_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final Map<Class<?>, Collection<Field>> syncedFields = Maps.newIdentityHashMap();

    private static Collection<Field> scanForFields(Class<?> cls) {
        TreeSet fields = Sets.newTreeSet(FIELD_NAME_COMPARATOR);
        for (Field field : cls.getDeclaredFields()) {
            if (!ISyncableObject.class.isAssignableFrom(field.getType())) continue;
            fields.add(field);
            field.setAccessible(true);
        }
        return ImmutableList.copyOf((Collection)fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Field> getSyncedFields(Class<?> cls) {
        Collection<Field> result;
        Map<Class<?>, Collection<Field>> map = this.syncedFields;
        synchronized (map) {
            result = this.syncedFields.get(cls);
        }
        if (result == null) {
            result = SyncObjectScanner.scanForFields(cls);
            map = this.syncedFields;
            synchronized (map) {
                this.syncedFields.put(cls, result);
            }
        }
        return result;
    }

    public void registerAllFields(SyncMap<?> map, Object target) {
        for (Field field : this.getSyncedFields(target.getClass())) {
            ISyncableObject obj;
            try {
                obj = (ISyncableObject)field.get(target);
                Preconditions.checkNotNull((Object)obj, (Object)"Null field value");
            }
            catch (Exception e) {
                obj = DummySyncableObject.INSTANCE;
                Log.severe(e, "Exception while registering synced field '%s' of object '%s'", field, target);
            }
            String fieldName = field.getName();
            map.put(fieldName, obj);
        }
    }
}

