/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import openmods.structured.Command;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openmods.structured.StructuredData;

public class StructuredDataMaster<C extends IStructureContainer<E>, E extends IStructureElement>
extends StructuredData<C, E> {
    private Set<Integer> newContainers = Sets.newTreeSet();
    private Set<Integer> deletedContainers = Sets.newTreeSet();
    private Set<Integer> modifiedElements = Sets.newTreeSet();
    private byte checkCount;

    public synchronized void appendUpdateCommands(List<Command> commands) {
        boolean addCheck;
        byte by = this.checkCount;
        this.checkCount = (byte)(by + 1);
        boolean bl = addCheck = by % 10 == 0;
        if (!this.deletedContainers.isEmpty()) {
            addCheck = true;
            Command.Delete delete = new Command.Delete();
            delete.idList.addAll(this.deletedContainers);
            commands.add(delete);
            this.newContainers.removeAll(this.deletedContainers);
        }
        if (!this.newContainers.isEmpty()) {
            addCheck = true;
            Set<Integer> newElements = this.appendContainersCreate(commands, this.newContainers);
            this.modifiedElements.removeAll(newElements);
        }
        if (!this.modifiedElements.isEmpty()) {
            Command.UpdateSingle update = new Command.UpdateSingle();
            update.idList.addAll(this.modifiedElements);
            update.payload = this.createPayload(this.modifiedElements);
            commands.add(update);
        }
        if (addCheck) {
            commands.add(this.createConsistencyCheck());
        }
        this.updateVersion(commands);
        this.clearUpdates();
    }

    public synchronized void appendFullCommands(List<Command> commands) {
        commands.add(Command.RESET_INST);
        if (!this.containers.isEmpty()) {
            this.appendContainersCreate(commands, this.containers.keySet());
            commands.add(this.createConsistencyCheck());
        }
        Command.SetVersion msg = new Command.SetVersion();
        msg.version = this.version;
        commands.add(msg);
        this.updateVersion(commands);
        this.clearUpdates();
    }

    private synchronized Set<Integer> appendContainersCreate(List<Command> commands, Set<Integer> containersToSend) {
        TreeSet newElements = Sets.newTreeSet();
        Command.Create create = new Command.Create();
        for (Integer containerId : containersToSend) {
            IStructureContainer container = (IStructureContainer)this.containers.get(containerId);
            NavigableSet containerContents = this.containerToElement.get((Object)containerId);
            newElements.addAll(containerContents);
            int firstContainerElement = (Integer)containerContents.first();
            create.containers.add(new Command.ContainerInfo(containerId, container.getType(), firstContainerElement));
        }
        create.payload = this.createPayload(newElements);
        commands.add(create);
        return newElements;
    }

    private synchronized Command.ConsistencyCheck createConsistencyCheck() {
        Command.ConsistencyCheck check = new Command.ConsistencyCheck();
        check.version = this.version;
        NavigableSet containers = this.containerToElement.keySet();
        if (!containers.isEmpty()) {
            check.containerCount = containers.size();
            check.maxContainerId = (Integer)containers.last();
        }
        if (!this.elements.isEmpty()) {
            check.elementCount = this.elements.size();
            check.maxElementId = (Integer)this.elements.lastKey();
        }
        return check;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.clearUpdates();
    }

    public synchronized void removeAll() {
        this.deletedContainers.addAll(this.containers.keySet());
        this.deletedContainers.removeAll(this.newContainers);
        this.newContainers.clear();
        this.modifiedElements.clear();
        this.elements.clear();
        this.containers.clear();
        this.containerToElement.clear();
    }

    private synchronized void clearUpdates() {
        this.newContainers.clear();
        this.deletedContainers.clear();
        this.modifiedElements.clear();
    }

    public boolean hasUpdates() {
        return !this.newContainers.isEmpty() || !this.deletedContainers.isEmpty() || !this.modifiedElements.isEmpty();
    }

    public synchronized void markElementModified(int id) {
        Preconditions.checkArgument((boolean)this.elements.containsKey(id), (String)"No element with id %s", (Object[])new Object[]{id});
        this.modifiedElements.add(id);
    }

    public synchronized int addContainer(C container) {
        int containerId = this.containerCounter++;
        this.elementCounter = this.addContainer(containerId, container, this.elementCounter++);
        this.newContainers.add(containerId);
        return containerId;
    }

    @Override
    public synchronized SortedSet<Integer> removeContainer(int containerId) {
        SortedSet<Integer> removedElements = super.removeContainer(containerId);
        boolean isNewContainer = this.newContainers.remove(containerId);
        if (!isNewContainer) {
            this.deletedContainers.add(containerId);
        }
        this.modifiedElements.removeAll(removedElements);
        return removedElements;
    }

    private byte[] createPayload(Collection<Integer> ids) {
        try {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            for (Integer id : ids) {
                IStructureElement element = (IStructureElement)this.elements.get(id);
                element.writeToStream((DataOutput)output);
            }
            return output.toByteArray();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

