/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import openmods.network.rpc.NullableArg;
import openmods.utils.AnnotationMap;
import openmods.utils.ByteUtils;
import openmods.utils.io.IStreamReadable;
import openmods.utils.io.IStreamWriteable;
import openmods.utils.io.TypeRW;

public class MethodParamsCodec {
    private final Method method;
    private final MethodParam[] params;
    private static final Map<Method, MethodParamsCodec> CACHE = Maps.newHashMap();

    public MethodParamsCodec(Method method) {
        this.method = method;
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        this.params = new MethodParam[types.length];
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = new MethodParam(types[i], annotations[i]);
        }
    }

    public void writeArgs(DataOutput output, Object ... args) {
        if (args == null) {
            Preconditions.checkArgument((0 == this.params.length ? 1 : 0) != 0, (String)"Argument list length mismatch, expected %d, got 0", (Object[])new Object[]{this.params.length});
            return;
        }
        Preconditions.checkArgument((args.length == this.params.length ? 1 : 0) != 0, (String)"Argument list length mismatch, expected %d, got %d", (Object[])new Object[]{this.params.length, args.length});
        for (int i = 0; i < args.length; ++i) {
            MethodParam param = this.params[i];
            try {
                MethodParamsCodec.writeArg(output, i, param.type, param.isNullable, args[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to write argument %d from method %s", i, this.method), e);
            }
        }
    }

    private static void writeArg(DataOutput output, int argIndex, Class<?> type, boolean isNullable, Object value) throws IOException {
        if (isNullable) {
            if (value == null) {
                output.writeBoolean(false);
                return;
            }
            output.writeBoolean(true);
        } else {
            Preconditions.checkNotNull((Object)value, (Object)"Only @NullableArg arguments can be null");
        }
        if (type.isArray()) {
            MethodParamsCodec.writeArray(output, argIndex, type, isNullable, value);
        } else if (type.isEnum()) {
            MethodParamsCodec.writeEnum(output, value);
        } else {
            MethodParamsCodec.writeSingleValue(output, type, value);
        }
    }

    private static void writeEnum(DataOutput output, Object value) {
        int ord = ((Enum)value).ordinal();
        ByteUtils.writeVLI(output, ord);
    }

    private static void writeArray(DataOutput output, int argIndex, Class<?> type, boolean isNullable, Object value) throws IOException {
        int length = Array.getLength(value);
        Class<?> component = type.getComponentType();
        ByteUtils.writeVLI(output, length);
        for (int i = 0; i < length; ++i) {
            Object elem = Array.get(value, i);
            MethodParamsCodec.writeArg(output, argIndex, component, isNullable, elem);
        }
    }

    private static void writeSingleValue(DataOutput output, Class<?> type, Object value) throws IOException {
        IStreamWriteable writer = TypeRW.TYPES.get(type);
        Preconditions.checkNotNull((Object)writer, (String)"Failed to find writer for type %s", (Object[])new Object[]{type});
        writer.writeToStream(value, output);
    }

    public Object[] readArgs(DataInput input) {
        if (this.params.length == 0) {
            return null;
        }
        Object[] result = new Object[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            MethodParam param = this.params[i];
            try {
                result[i] = MethodParamsCodec.readArg(input, param.type, param.isNullable);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to read argument %d from method %s", i, this.method), e);
            }
        }
        return result;
    }

    private static Object readArg(DataInput input, Class<?> type, boolean isNullable) throws IOException {
        boolean hasValue;
        if (isNullable && !(hasValue = input.readBoolean())) {
            return null;
        }
        if (type.isArray()) {
            return MethodParamsCodec.readArray(input, type, isNullable);
        }
        if (type.isEnum()) {
            return MethodParamsCodec.readEnum(input, type);
        }
        return MethodParamsCodec.readSingleValue(input, type);
    }

    private static Object readArray(DataInput input, Class<?> type, boolean isNullable) throws IOException {
        Class<?> component = type.getComponentType();
        int length = ByteUtils.readVLI(input);
        Object result = Array.newInstance(component, length);
        for (int i = 0; i < length; ++i) {
            Object value = MethodParamsCodec.readArg(input, component, isNullable);
            Array.set(result, i, value);
        }
        return result;
    }

    private static Object readEnum(DataInput input, Class<?> type) {
        int ord = ByteUtils.readVLI(input);
        ?[] values = type.getEnumConstants();
        try {
            return values[ord];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(String.format("Failed to get enum with ordinal %d from class %s", ord, type));
        }
    }

    private static Object readSingleValue(DataInput input, Class<?> type) throws IOException {
        IStreamReadable reader = TypeRW.TYPES.get(type);
        Preconditions.checkNotNull((Object)reader, (String)"Failed to find reader for type %s", (Object[])new Object[]{type});
        return reader.readFromStream(input);
    }

    public void validate() {
        for (int i = 0; i < this.params.length; ++i) {
            try {
                this.params[i].validate();
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to validate arg %d of method %s", i, this.method), e);
            }
        }
    }

    public static synchronized MethodParamsCodec create(Method method) {
        MethodParamsCodec result = CACHE.get(method);
        if (result == null) {
            result = new MethodParamsCodec(method);
            CACHE.put(method, result);
        }
        return result;
    }

    private static class MethodParam {
        public final Class<?> type;
        public final boolean isNullable;

        public MethodParam(Class<?> type, Annotation[] annotations) {
            this.type = type;
            AnnotationMap annotationsMap = new AnnotationMap(annotations);
            this.isNullable = annotationsMap.hasAnnotation(NullableArg.class);
        }

        public void validate() {
            this.validate(this.type);
        }

        private void validate(Class<?> cls) {
            Preconditions.checkState((!cls.isPrimitive() || !this.isNullable ? 1 : 0) != 0, (Object)"Primitive types can't be nullable");
            if (this.type.isArray()) {
                this.validate(this.type.getComponentType());
            } else if (!this.type.isEnum()) {
                IStreamReadable reader = TypeRW.TYPES.get(this.type);
                Preconditions.checkNotNull((Object)reader, (String)"Failed to find reader for type %s", (Object[])new Object[]{this.type});
            }
        }

        public String toString() {
            return "MethodParam [type=" + this.type + ", nullable=" + this.isNullable + "]";
        }
    }
}

