/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component.page;

import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import openmods.gui.component.GuiComponentCraftingGrid;
import openmods.gui.component.GuiComponentItemStackSpinner;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.page.PageBase;
import openmods.utils.RecipeUtils;
import openmods.utils.render.FakeIcon;

public class StandardRecipePage
extends PageBase {
    public static IIcon iconCraftingGrid = FakeIcon.createSheetIcon(0, 180, 56, 56);
    public static IIcon iconArrow = FakeIcon.createSheetIcon(60, 198, 48, 15);
    private GuiComponentCraftingGrid craftingGrid;
    private GuiComponentSprite arrow;
    private GuiComponentLabel lblDescription;
    private GuiComponentLabel lblTitle;
    private GuiComponentItemStackSpinner outputSpinner;

    public StandardRecipePage(String title, String description, ItemStack resultingItem) {
        String translatedTitle = StatCollector.func_74838_a((String)title);
        String translatedDescription = StatCollector.func_74838_a((String)description).replaceAll("\\\\n", "\n");
        this.lblTitle = new GuiComponentLabel((this.getWidth() - Minecraft.func_71410_x().field_71466_p.func_78256_a(translatedTitle)) / 2, 12, translatedTitle);
        this.lblDescription = new GuiComponentLabel(27, 95, 340, 51, translatedDescription);
        this.arrow = new GuiComponentSprite(90, 50, iconArrow, BOOK_TEXTURE);
        this.craftingGrid = new GuiComponentCraftingGrid(25, 30, RecipeUtils.getFirstRecipeForItem(resultingItem), iconCraftingGrid, BOOK_TEXTURE);
        this.lblDescription.setScale(0.5f);
        this.lblDescription.setAdditionalLineHeight(4);
        this.outputSpinner = new GuiComponentItemStackSpinner(150, 40, resultingItem);
        this.addComponent(this.lblDescription);
        this.addComponent(this.lblTitle);
        this.addComponent(this.arrow);
        this.addComponent(this.outputSpinner);
        this.addComponent(this.craftingGrid);
    }

    public StandardRecipePage(String title, String description, String videoLink, ItemStack resultingItem) {
        this(title, description, resultingItem);
        String translatedLink = StatCollector.func_74838_a((String)videoLink);
        if (videoLink != "" && !videoLink.equals(translatedLink)) {
            this.addActionButton(25, 146, translatedLink, PageBase.ActionIcon.YOUTUBE.icon, "openblocks.gui.watch_video");
        }
    }
}

