/*
 * Decompiled with CFR 0.152.
 */
package openmods.datastore;

import java.io.DataOutput;
import java.io.IOException;
import openmods.datastore.DataStore;
import openmods.datastore.IDataVisitor;
import openmods.utils.ByteUtils;
import openmods.utils.io.IStreamWriteable;

public class DataStoreWriter<K, V> {
    private final DataStore<K, V> data;
    private final IStreamWriteable<K> keyWriter;
    private final IStreamWriteable<V> valueWriter;

    DataStoreWriter(DataStore<K, V> data, IStreamWriteable<K> keyWriter, IStreamWriteable<V> valueWriter) {
        this.data = data;
        this.keyWriter = keyWriter;
        this.valueWriter = valueWriter;
    }

    public void write(final DataOutput output) {
        this.data.visit(new IDataVisitor<K, V>(){

            @Override
            public void begin(int size) {
                ByteUtils.writeVLI(output, size);
            }

            @Override
            public void entry(K key, V value) {
                try {
                    DataStoreWriter.this.keyWriter.writeToStream(key, output);
                    DataStoreWriter.this.valueWriter.writeToStream(value, output);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void end() {
            }
        });
    }
}

