/*
 * Decompiled with CFR 0.152.
 */
package openmods.datastore;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import openmods.datastore.DataStore;
import openmods.datastore.DataStoreReader;
import openmods.datastore.DataStoreWriter;
import openmods.datastore.IDataVisitor;
import openmods.utils.io.IStreamReadable;
import openmods.utils.io.IStreamWriteable;

public class DataStoreWrapper<K, V> {
    private final DataStore<K, V> localData;
    private DataStore<K, V> activeData;
    private final Set<IDataVisitor<K, V>> visitors = Sets.newIdentityHashSet();
    private final IStreamWriteable<K> keyWriter;
    private final IStreamWriteable<V> valueWriter;
    private final IStreamReadable<K> keyReader;
    private final IStreamReadable<V> valueReader;

    DataStoreWrapper(Map<K, V> localData, IStreamWriteable<K> keyWriter, IStreamWriteable<V> valueWriter, IStreamReadable<K> keyReader, IStreamReadable<V> valueReader) {
        this.localData = new DataStore<K, V>(localData);
        this.keyWriter = keyWriter;
        this.valueWriter = valueWriter;
        this.keyReader = keyReader;
        this.valueReader = valueReader;
    }

    private void notifyVisitors() {
        for (IDataVisitor<K, V> visitor : this.visitors) {
            this.activeData.visit(visitor);
        }
    }

    public void activateData(DataStore<K, V> data) {
        this.activeData = data;
        this.notifyVisitors();
    }

    public void activateLocalData() {
        this.activeData = this.localData;
        this.notifyVisitors();
    }

    public DataStoreReader<K, V> createReader() {
        return new DataStoreReader<K, V>(this, this.keyReader, this.valueReader);
    }

    public DataStoreWriter<K, V> createWriter() {
        return new DataStoreWriter<K, V>(this.localData, this.keyWriter, this.valueWriter);
    }

    public DataStore<K, V> localData() {
        return this.localData;
    }

    public DataStore<K, V> activeData() {
        return this.activeData;
    }

    public void addVisitor(IDataVisitor<K, V> visitor) {
        this.visitors.add(visitor);
    }
}

