/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import openmods.Log;
import openmods.api.IResultListener;
import openmods.asm.MappedType;
import openmods.asm.MethodMatcher;
import openmods.asm.TransformerState;
import openmods.asm.VisitorHelper;
import openmods.config.simple.ConfigProcessor;
import openmods.context.ContextClassTransformer;
import openmods.include.IncludingClassVisitor;
import openmods.movement.MovementPatcher;
import openmods.renderer.PlayerRendererHookVisitor;
import openmods.stencil.CapabilitiesHookInjector;
import openmods.stencil.FramebufferInjector;
import openmods.utils.StateTracker;
import openmods.world.MapGenStructureVisitor;
import org.objectweb.asm.ClassVisitor;

public class OpenModsClassTransformer
implements IClassTransformer {
    private static OpenModsClassTransformer INSTANCE;
    private static final List<String> IGNORED_PREFIXES;
    private static final Multimap<String, MethodMatcher> wrapMatchers;
    private final Map<String, VisitorHelper.TransformProvider> vanillaPatches = Maps.newHashMap();
    private final StateTracker<TransformerState> states = StateTracker.create(TransformerState.DISABLED);
    private Set<String> includedClasses;
    private static final VisitorHelper.TransformProvider INCLUDING_CV;

    private static void addWrapTarget(String clsName, String methodMcpName, String methodSrgName, String methodDesc) {
        MappedType cls = MappedType.of(clsName);
        MethodMatcher matcher = new MethodMatcher(cls, methodDesc, methodMcpName, methodSrgName);
        wrapMatchers.put((Object)clsName, (Object)matcher);
    }

    private static IResultListener createResultListener(final StateTracker.StateUpdater<TransformerState> updater) {
        return new IResultListener(){

            @Override
            public void onSuccess() {
                updater.update(TransformerState.FINISHED);
            }

            @Override
            public void onFailure() {
                updater.update(TransformerState.FAILED);
            }
        };
    }

    public OpenModsClassTransformer() {
        INSTANCE = this;
    }

    public static OpenModsClassTransformer instance() {
        return INSTANCE;
    }

    public void addConfigValues(ConfigProcessor config) {
        config.addEntry("activate_movement_callback", 0, "true", new ConfigOption("movement_callback"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.client.entity.EntityPlayerSP", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.info("Trying to apply movement callback (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new MovementPatcher(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: this transformer add hook to player movement controls", "Modified class: net.minecraft.client.entity.EntityPlayerSP", "Known users: OpenBlocks elevator", "When disabled: users usually have fallbacks (elevator will use less accurate algorithm)");
        config.addEntry("activate_map_gen_fix", 0, "true", new ConfigOption("map_gen_fix"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.world.gen.structure.MapGenStructure", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.info("Trying to patch MapGenStructure (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new MapGenStructureVisitor(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: fix bug in vanilla code used to find nearby structures", "Modified class: net.minecraft.world.gen.structure.MapGenStructure", "Known users: OpenBlocks golden eye", "When disabled: features may not work (either silently fail or cause crash)");
        config.addEntry("activate_player_render_hook", 0, "true", new ConfigOption("player_render_hook"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.client.renderer.entity.RenderPlayer", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.info("Trying to patch RenderPlayer (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new PlayerRendererHookVisitor(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: add hook to player rendering code", "Modified class: net.minecraft.client.renderer.entity.RenderPlayer", "Known users: OpenBlocks hangglider", "When disabled: code may fallback to less compatible mechanism (like replacing renderer)");
        config.addEntry("activate_stencil_patches", 0, "true", new ConfigOption("stencil_patches"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.client.shader.Framebuffer", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.info("Trying to patch Framebuffer (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new FramebufferInjector(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: to re-enable stencil buffer on FBO objects. This is was disabled due to problems on some configurations", "Modified class: net.minecraft.client.shader.Framebuffer", "Known users: OpenBlocks skyblocks", "When disabled: no stencil buffer available unless unlocked with Forge flag. Mods may not use some graphic features");
        config.addEntry("activate_gl_capabilities_hook", 0, "true", new ConfigOption("gl_capabilities_hook"){

            @Override
            protected void onActivate(final StateTracker.StateUpdater<TransformerState> state) {
                OpenModsClassTransformer.this.vanillaPatches.put("net.minecraft.client.renderer.OpenGlHelper", new VisitorHelper.TransformProvider(2){

                    @Override
                    public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                        Log.info("Trying to patch OpenGlHelper (class: %s)", name);
                        state.update(TransformerState.ACTIVATED);
                        return new CapabilitiesHookInjector(name, cv, OpenModsClassTransformer.createResultListener(state));
                    }
                });
            }
        }, "Purpose: hook to get check additional OpenGL capabilities (mostly stencil buffer related)", "Modified class: net.minecraft.client.renderer.OpenGlHelper", "Known users: OpenBlocks skyblocks", "When disabled: no stencil buffer available unless unlocked with Forge flag. Mods may not use some graphic features");
    }

    public void injectAsmData(ASMDataTable table) {
        ImmutableSet.Builder includedClasses = ImmutableSet.builder();
        for (ASMDataTable.ASMData data : table.getAll("openmods.include.IncludeInterface")) {
            includedClasses.add((Object)data.getClassName());
        }
        for (ASMDataTable.ASMData data : table.getAll("openmods.include.IncludeOverride")) {
            includedClasses.add((Object)data.getClassName());
        }
        this.includedClasses = includedClasses.build();
    }

    private boolean shouldTryIncluding(String clsName) {
        if (this.includedClasses != null) {
            return this.includedClasses.contains(clsName);
        }
        for (String prefix : IGNORED_PREFIXES) {
            if (!clsName.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        bytes = this.tryApplyContextWrapper(name, transformedName, bytes);
        if (transformedName.startsWith("net.minecraft.")) {
            VisitorHelper.TransformProvider provider = this.vanillaPatches.get(transformedName);
            return provider != null ? VisitorHelper.apply(bytes, name, provider) : bytes;
        }
        if (this.shouldTryIncluding(transformedName)) {
            return this.applyIncludes(name, transformedName, bytes);
        }
        return bytes;
    }

    protected byte[] tryApplyContextWrapper(String name, String transformedName, byte[] bytes) {
        final Collection matchers = wrapMatchers.get((Object)transformedName);
        if (matchers.isEmpty()) {
            return bytes;
        }
        Log.info("Adding context wrappers to %s(%s)", name, transformedName);
        return VisitorHelper.apply(bytes, name, new VisitorHelper.TransformProvider(0){

            @Override
            public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                return new ContextClassTransformer(cv, matchers);
            }
        });
    }

    protected byte[] applyIncludes(String name, String transformedName, byte[] bytes) {
        try {
            return VisitorHelper.apply(bytes, name, INCLUDING_CV);
        }
        catch (Throwable t) {
            Log.severe(t, "Failed to apply including transformer on %s(%s)", name, transformedName);
            throw Throwables.propagate((Throwable)t);
        }
    }

    public String listStates() {
        return Joiner.on((char)',').join(Iterables.transform(this.states.states(), (Function)Functions.toStringFunction()));
    }

    static {
        IGNORED_PREFIXES = ImmutableList.of((Object)"cpw.mods.fml.", (Object)"net.minecraftforge.", (Object)"io.netty.", (Object)"gnu.trove.", (Object)"com.google.", (Object)"com.mojang.", (Object)"joptsimple.", (Object)"tv.twitch.");
        wrapMatchers = ArrayListMultimap.create();
        OpenModsClassTransformer.addWrapTarget("net.minecraft.server.management.ItemInWorldManager", "tryHarvestBlock", "func_73084_b", "(III)Z");
        INCLUDING_CV = new VisitorHelper.TransformProvider(0){

            @Override
            public ClassVisitor createVisitor(String name, ClassVisitor cv) {
                return new IncludingClassVisitor(cv);
            }
        };
    }

    private abstract class ConfigOption
    implements ConfigProcessor.UpdateListener {
        private final StateTracker.StateUpdater<TransformerState> state;

        public ConfigOption(String name) {
            this.state = OpenModsClassTransformer.this.states.register(name);
        }

        @Override
        public void valueSet(String value) {
            if ("true".equalsIgnoreCase(value)) {
                this.state.update(TransformerState.ENABLED);
                this.onActivate(this.state);
            }
        }

        protected abstract void onActivate(StateTracker.StateUpdater<TransformerState> var1);
    }
}

