/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.tileentity;

import net.malisis.core.util.MultiBlock;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.RustyHatchMovement;
import net.malisis.doors.door.sound.RustyHatchSound;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RustyHatchTileEntity
extends DoorTileEntity
implements MultiBlock.IProvider {
    private MultiBlock multiBlock;

    public RustyHatchTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(RustyHatchMovement.class));
        descriptor.setSound(DoorRegistry.getSound(RustyHatchSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(60);
        this.setDescriptor(descriptor);
    }

    private int getOriginMetadata() {
        if (this.func_145831_w() == null || this.multiBlock == null) {
            return 0;
        }
        return this.func_145831_w().func_72805_g(this.multiBlock.getX(), this.multiBlock.getY(), this.multiBlock.getZ());
    }

    @Override
    public boolean isTopBlock(int x, int y, int z) {
        return (this.getOriginMetadata() & 8) != 0;
    }

    @Override
    public int getDirection() {
        return (this.getOriginMetadata() & 3) + 2;
    }

    @Override
    public boolean isOpened() {
        return (this.getOriginMetadata() & 4) != 0;
    }

    @Override
    public boolean isReversed() {
        return (this.getOriginMetadata() & 0x10) != 0;
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    public boolean shouldLadder(int x, int y, int z) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getDirection());
        if (z == this.field_145849_e && (dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH)) {
            return false;
        }
        if (x == this.field_145851_c && (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST)) {
            return false;
        }
        return this.func_145831_w().isSideSolid(x + dir.offsetX, y, z + dir.offsetZ, dir.getOpposite());
    }

    @Override
    public void openOrCloseDoor() {
        RustyHatchTileEntity te = (RustyHatchTileEntity)MultiBlock.getOriginProvider((TileEntity)this);
        if (te == null) {
            return;
        }
        if (te != this) {
            te.openOrCloseDoor();
            return;
        }
        if (this.getState() != DoorState.CLOSED && this.getState() != DoorState.OPENED) {
            return;
        }
        super.openOrCloseDoor();
    }

    public void setMultiBlock(MultiBlock multiBlock) {
        this.multiBlock = multiBlock;
    }

    public MultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.multiBlock != null) {
            this.multiBlock.setWorld(world);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.multiBlock = new MultiBlock(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.multiBlock != null) {
            this.multiBlock.writeToNBT(tag);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.multiBlock != null) {
            return this.multiBlock.getWorldBounds();
        }
        return super.getRenderBoundingBox();
    }
}

