/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.block;

import cofh.api.block.IBlockInfo;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.interfaces.IDebugableBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.lib.api.tile.IInformationProvider;
import pl.asie.lib.block.TileEntityBase;
import pl.asie.lib.client.BlockBaseRender;
import pl.asie.lib.gui.managed.IGuiProvider;
import pl.asie.lib.integration.Integration;
import pl.asie.lib.reference.Mods;
import pl.asie.lib.tile.TileMachine;
import pl.asie.lib.util.ItemUtils;
import pl.asie.lib.util.MiscUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="gregtech.api.interfaces.IDebugableBlock", modid="gregtech"), @Optional.Interface(iface="cofh.api.block.IBlockInfo", modid="CoFHAPI|block")})
public abstract class BlockBase
extends BlockContainer
implements IBlockInfo,
IDebugableBlock {
    private Rotation rotation = Rotation.NONE;
    private final Object parent;
    private int gui = -1;
    protected IGuiProvider guiProvider;
    private static final int[] ROT_TRANSFORM4 = new int[]{2, 5, 3, 4};
    private String iconName = null;
    private IIcon icon = null;

    public BlockBase(Material material, Object parent) {
        super(material);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149711_c(2.0f);
        this.parent = parent;
    }

    @Deprecated
    public boolean emitsRedstone(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean emitsRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean receivesRedstone(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int getVanillaRedstoneValue(World world, int x, int y, int z) {
        return world.func_94577_B(x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile;
        TileEntity te;
        if (this.receivesRedstone((IBlockAccess)world, x, y, z) && (te = world.func_147438_o(x, y, z)) != null && te instanceof TileEntityBase) {
            ((TileEntityBase)te).onRedstoneSignal_internal(this.getVanillaRedstoneValue(world, x, y, z));
        }
        if (Mods.isLoaded("ProjRed|Core") && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileMachine) {
            ((TileMachine)tile).onProjectRedBundledInputChanged();
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return this.emitsRedstone(world, x, y, z, side) || this.receivesRedstone(world, x, y, z);
    }

    public int func_149709_b(IBlockAccess access, int x, int y, int z, int side) {
        if (!this.emitsRedstone(access, x, y, z, side)) {
            return 0;
        }
        TileEntity te = access.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityBase) {
            return ((TileEntityBase)te).requestCurrentRedstoneValue(side);
        }
        return 0;
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    public TileEntity createTileEntity(World world, int metadata) {
        return this.func_149915_a(world, metadata);
    }

    public int getFrontSide(int m) {
        switch (this.rotation) {
            case FOUR: {
                return (m & 3) + 2;
            }
            case SIX: {
                return (m & 7) % 6;
            }
        }
        return 2;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public int relToAbs(int side, int metadata) {
        int frontSide = this.getFrontSide(metadata);
        return MiscUtils.getAbsoluteSide(side, frontSide);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteIcon(int side, int metadata) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteIcon(World world, int x, int y, int z, int side, int metadata) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.getAbsoluteIcon(this.relToAbs(side, metadata), metadata);
    }

    public ForgeDirection getFacingDirection(World world, int x, int y, int z) {
        int m = world.func_72805_g(x, y, z);
        return ForgeDirection.getOrientation((int)this.getFrontSide(m));
    }

    @Deprecated
    public void setRotateFrontSide(boolean v) {
        this.rotation = Rotation.FOUR;
    }

    public void setRotation(Rotation v) {
        this.rotation = v;
    }

    private void setDefaultRotation(World world, int x, int y, int z) {
        if (!world.field_72995_K && this.rotation != Rotation.NONE) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int m = world.func_72805_g(x, y, z);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            } else if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            } else if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            if (this.rotation == Rotation.SIX && y > 0 && y < 255) {
                Block block4 = world.func_147439_a(x, y - 1, z);
                Block block5 = world.func_147439_a(x, y + 1, z);
                if (block4.func_149730_j() && !block5.func_149730_j()) {
                    b0 = 1;
                } else if (block5.func_149730_j() && !block4.func_149730_j()) {
                    b0 = 0;
                }
            } else {
                b0 = (byte)(b0 - 2);
            }
            world.func_72921_c(x, y, z, m | b0, 2);
        }
    }

    private int determineRotation(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (this.rotation == Rotation.NONE) {
            return 0;
        }
        if (this.rotation == Rotation.SIX && MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - (double)entity.field_70129_M;
            if (d0 - (double)y > 2.0) {
                return 1;
            }
            if ((double)y - d0 > 0.0) {
                return 0;
            }
        }
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return ROT_TRANSFORM4[l];
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int rot = this.determineRotation(world, x, y, z, entity, stack);
        int m = stack.func_77960_j();
        if (this.rotation == Rotation.SIX) {
            world.func_72921_c(x, y, z, m & 0xFFFFFFF8 | rot, 2);
        } else if (this.rotation == Rotation.FOUR) {
            world.func_72921_c(x, y, z, m & 0xFFFFFFFC | rot - 2, 2);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultRotation(world, x, y, z);
    }

    public Object getOwner() {
        return this.parent;
    }

    @Deprecated
    public void setGuiID(int gui) {
        if (gui >= 0) {
            this.gui = gui;
        }
    }

    @Deprecated
    public boolean hasGui() {
        if (this.guiProvider != null) {
            this.gui = this.guiProvider.getGuiID();
        }
        return this.guiProvider != null && this.gui >= 0;
    }

    @Deprecated
    public int getGuiID() {
        if (this.guiProvider != null) {
            this.gui = this.guiProvider.getGuiID();
        }
        return this.gui;
    }

    public boolean hasGui(World world, int x, int y, int z, EntityPlayer player, int side) {
        if (this.guiProvider != null) {
            this.gui = this.guiProvider.getGuiID();
        }
        return this.guiProvider != null && this.gui >= 0;
    }

    @Deprecated
    public int getGuiID(World world, int x, int y, int z, EntityPlayer player, int side) {
        if (this.guiProvider != null) {
            this.gui = this.guiProvider.getGuiID();
        }
        return this.gui;
    }

    public IGuiProvider getGuiProvider(World world, int x, int y, int z, EntityPlayer player, int side) {
        return this.guiProvider;
    }

    public void setGuiProvider(IGuiProvider provider) {
        this.guiProvider = provider;
        this.gui = this.guiProvider.getGuiID();
    }

    protected boolean rotate(World world, int x, int y, int z, EntityPlayer player, int side) {
        if (player.func_70093_af()) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (this.rotation == Rotation.FOUR) {
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                world.func_72921_c(x, y, z, ((meta & 3) + (meta == 0 ? 3 : (meta == 3 ? 2 : meta))) % 4, 2);
            } else {
                world.func_72921_c(x, y, z, this.getFrontSide(meta) != side ? (side >= 2 ? side - 2 : 2) : ForgeDirection.getOrientation((int)side).getOpposite().ordinal() - 2 & 3, 2);
            }
            return true;
        }
        if (this.rotation == Rotation.SIX) {
            world.func_72921_c(x, y, z, this.getFrontSide(meta) != side ? side : ForgeDirection.getOrientation((int)side).getOpposite().ordinal(), 2);
            return true;
        }
        return false;
    }

    protected boolean onToolUsed(World world, int x, int y, int z, EntityPlayer player, int side) {
        return false;
    }

    protected boolean useTool(World world, int x, int y, int z, EntityPlayer player, int side) {
        ItemStack held = player.field_71071_by.func_70448_g();
        if (held != null && held.func_77973_b() != null && Integration.isTool(held, player, x, y, z) && this.rotation != null) {
            boolean wrenched = Integration.useTool(held, player, x, y, z);
            return wrenched && (this.onToolUsed(world, x, y, z, player, side) || this.rotate(world, x, y, z, player, side));
        }
        return false;
    }

    protected boolean canUseTool(World world, int x, int y, int z, EntityPlayer player, int side) {
        return this.rotation != Rotation.NONE;
    }

    private void tryOpenOldGui(World world, int x, int y, int z, EntityPlayer player, int side) {
        int guiID = this.getGuiID(world, x, y, z, player, side);
        if (guiID >= 0) {
            player.openGui(this.parent, guiID, world, x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            if (!this.canUseTool(world, x, y, z, player, side) || !this.useTool(world, x, y, z, player, side)) {
                IGuiProvider guiProvider = this.getGuiProvider(world, x, y, z, player, side);
                if (guiProvider != null) {
                    if (guiProvider.canOpen(world, x, y, z, player, side) && this.onOpenGui(world, x, y, z, player, side)) {
                        player.openGui(this.parent, guiProvider.getGuiID(), world, x, y, z);
                        return true;
                    }
                    this.onOpenGuiDenied(world, x, y, z, player, side);
                } else {
                    this.tryOpenOldGui(world, x, y, z, player, side);
                }
            }
            return false;
        }
        return true;
    }

    protected boolean onOpenGui(World world, int x, int y, int z, EntityPlayer player, int side) {
        return true;
    }

    protected void onOpenGuiDenied(World world, int x, int y, int z, EntityPlayer player, int side) {
    }

    public void setIconName(String name) {
        this.iconName = name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        if (this.iconName != null) {
            this.icon = reg.func_94245_a(this.iconName);
        }
    }

    public void onBlockDestroyed(World world, int x, int y, int z, int meta) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            if (tileEntity instanceof TileEntityBase) {
                ((TileEntityBase)tileEntity).onBlockDestroy();
            }
            if (tileEntity instanceof IInventory) {
                ItemUtils.dropItems(world, x, y, z, (IInventory)tileEntity);
            }
            tileEntity.func_145843_s();
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        super.func_149664_b(world, x, y, z, meta);
        this.onBlockDestroyed(world, x, y, z, meta);
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        super.func_149723_a(world, x, y, z, explosion);
        this.onBlockDestroyed(world, x, y, z, 0);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.onBlockDestroyed(world, x, y, z, meta);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return BlockBaseRender.id();
    }

    @Optional.Method(modid="gregtech")
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aX, int aY, int aZ, int aLogLevel) {
        TileEntity te = aPlayer.field_70170_p.func_147438_o(aX, aY, aZ);
        ArrayList<String> data = new ArrayList<String>();
        if (te instanceof IInformationProvider) {
            ((IInformationProvider)te).getInformation(aPlayer, ForgeDirection.UNKNOWN, data, true);
        }
        return data;
    }

    @Optional.Method(modid="CoFHAPI|block")
    public void getBlockInfo(IBlockAccess world, int x, int y, int z, ForgeDirection side, EntityPlayer player, List<IChatComponent> info, boolean debug) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInformationProvider) {
            ArrayList<String> data = new ArrayList<String>();
            ((IInformationProvider)te).getInformation(player, side, data, true);
            for (String s : data) {
                info.add((IChatComponent)new ChatComponentText(s));
            }
        }
    }

    public static enum Rotation {
        NONE,
        FOUR,
        SIX;

    }
}

