/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.util.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.audio.DFPWM;

public class StreamingAudioPlayer
extends DFPWM {
    public int lastPacketId = -9000;
    private int receivedPackets = 0;
    private boolean isInitializedClient = false;
    private IntBuffer source;
    private ArrayList<IntBuffer> buffersPlayed;
    private int SAMPLE_RATE;
    private final int BUFFER_PACKETS;
    private final int FORMAT;
    private float volume = 1.0f;
    private float distance = 24.0f;

    public StreamingAudioPlayer(int sampleRate, boolean sixteenBit, boolean stereo, int bufferPackets) {
        this.BUFFER_PACKETS = bufferPackets;
        this.SAMPLE_RATE = sampleRate;
        this.FORMAT = sixteenBit ? (stereo ? 4355 : 4353) : (stereo ? 4354 : 4352);
    }

    public void setDistance(float dist) {
        this.distance = dist;
    }

    public void setVolume(float vol) {
        this.volume = vol;
    }

    public void setSampleRate(int rate) {
        this.SAMPLE_RATE = rate;
    }

    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.buffersPlayed = new ArrayList();
        this.lastPacketId = -9000;
        this.receivedPackets = 0;
        if (this.source != null) {
            this.stopClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean initClient() {
        this.source = BufferUtils.createIntBuffer((int)1);
        AL10.alGenSources((IntBuffer)this.source);
        if (AL10.alGetError() != 0) {
            return false;
        }
        this.isInitializedClient = true;
        return AL10.alGetError() == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public float getDistance(int x, int y, int z) {
        Vec3 pos = Minecraft.func_71410_x().field_71439_g.func_70666_h(1.0f);
        double dx = pos.field_72450_a - (double)x;
        double dy = pos.field_72448_b - (double)y;
        double dz = pos.field_72449_c - (double)z;
        float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        return distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void playPacket(byte[] data, int x, int y, int z) {
        IntBuffer buffer;
        if (!this.isInitializedClient || this.source == null) {
            this.reset();
            this.initClient();
        }
        FloatBuffer sourcePos = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{x, y, z}).rewind();
        FloatBuffer sourceVel = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f}).rewind();
        int processed = AL10.alGetSourcei((int)this.source.get(0), (int)4118);
        if (processed > 0) {
            buffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)buffer);
            AL10.alSourceUnqueueBuffers((int)this.source.get(0), (IntBuffer)buffer);
        } else {
            buffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)buffer);
        }
        float distance = this.getDistance(x, y, z);
        float gain = distance >= 20.0f ? 0.0f : (distance <= 4.0f ? 1.0f : 1.0f - (distance - 4.0f) / 16.0f);
        AL10.alSourcei((int)this.source.get(0), (int)4103, (int)0);
        AL10.alSourcef((int)this.source.get(0), (int)4099, (float)1.0f);
        AL10.alSourcef((int)this.source.get(0), (int)4106, (float)(gain *= Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS)));
        AL10.alSource((int)this.source.get(0), (int)4100, (FloatBuffer)sourcePos);
        AL10.alSource((int)this.source.get(0), (int)4102, (FloatBuffer)sourceVel);
        AL10.alSourcef((int)this.source.get(0), (int)4129, (float)0.0f);
        AL10.alBufferData((int)buffer.get(0), (int)this.FORMAT, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)data.length).put(data).flip()), (int)this.SAMPLE_RATE);
        AL10.alSourceQueueBuffers((int)this.source.get(0), (IntBuffer)buffer);
        int state = AL10.alGetSourcei((int)this.source.get(0), (int)4112);
        if (this.receivedPackets > this.BUFFER_PACKETS && state != 4114) {
            AL10.alSourcePlay((int)this.source.get(0));
        } else if (this.receivedPackets <= this.BUFFER_PACKETS) {
            AL10.alSourcePause((int)this.source.get(0));
        }
        ++this.receivedPackets;
        ArrayList<IntBuffer> arrayList = this.buffersPlayed;
        synchronized (arrayList) {
            this.buffersPlayed.add(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void stopClient() {
        AL10.alSourceStop((int)this.source.get(0));
        AL10.alDeleteSources((IntBuffer)this.source);
        int count = 0;
        if (this.buffersPlayed != null) {
            ArrayList<IntBuffer> arrayList = this.buffersPlayed;
            synchronized (arrayList) {
                for (IntBuffer b : this.buffersPlayed) {
                    b.rewind();
                    for (int i = 0; i < b.limit(); ++i) {
                        int buffer = b.get(i);
                        if (!AL10.alIsBuffer((int)buffer)) continue;
                        AL10.alDeleteBuffers((int)buffer);
                        ++count;
                    }
                }
                this.buffersPlayed.clear();
                AsieLibMod.log.debug("Cleaned " + count + " buffers.");
            }
        }
    }

    public void stop() {
        if (this.source != null) {
            this.stopClient();
        }
        this.isInitializedClient = false;
    }
}

