/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.ic2;

import ic2.api.item.IC2Items;
import ic2.api.tile.IEnergyStorage;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.crossmod.EnergyStorageData;

public class CrossIndustrialCraft2 {
    private int _IC2WrenchId;
    private int _IC2ElectricWrenchId;
    private Method _getMaxDamageEx;
    private Method _getDamageOfStack;
    private Class _gradItemInt;
    private boolean _isApiAvailable = false;
    private boolean _isIdInitialized = false;
    private int[] _fuelIds = null;

    private void initIds() {
        if (!this._isApiAvailable || this._isIdInitialized) {
            return;
        }
        this._fuelIds = new int[6];
        this._fuelIds[0] = Item.func_150891_b((Item)IC2Items.getItem((String)"reactorUraniumSimple").func_77973_b());
        this._fuelIds[1] = Item.func_150891_b((Item)IC2Items.getItem((String)"reactorUraniumDual").func_77973_b());
        this._fuelIds[2] = Item.func_150891_b((Item)IC2Items.getItem((String)"reactorUraniumQuad").func_77973_b());
        this._fuelIds[3] = Item.func_150891_b((Item)IC2Items.getItem((String)"reactorMOXSimple").func_77973_b());
        this._fuelIds[4] = Item.func_150891_b((Item)IC2Items.getItem((String)"reactorMOXDual").func_77973_b());
        this._fuelIds[5] = Item.func_150891_b((Item)IC2Items.getItem((String)"reactorMOXQuad").func_77973_b());
        Arrays.sort(this._fuelIds);
        this._IC2WrenchId = Item.func_150891_b((Item)IC2Items.getItem((String)"wrench").func_77973_b());
        this._IC2ElectricWrenchId = Item.func_150891_b((Item)IC2Items.getItem((String)"electricWrench").func_77973_b());
        this._isIdInitialized = true;
    }

    public boolean isApiAvailable() {
        return this._isApiAvailable;
    }

    public boolean isWrench(ItemStack itemStack) {
        this.initIds();
        return this._isApiAvailable && (Item.func_150891_b((Item)itemStack.func_77973_b()) == this._IC2WrenchId || Item.func_150891_b((Item)itemStack.func_77973_b()) == this._IC2ElectricWrenchId);
    }

    public CrossIndustrialCraft2() {
        try {
            Class.forName("ic2.api.tile.IEnergyStorage", false, this.getClass().getClassLoader());
            this._gradItemInt = Class.forName("ic2.core.item.ItemGradualInt", false, this.getClass().getClassLoader());
            this._getMaxDamageEx = this._gradItemInt.getMethod("getMaxCustomDamage", ItemStack.class);
            try {
                this._getDamageOfStack = this._gradItemInt.getMethod("getCustomDamage", ItemStack.class);
            }
            catch (NoSuchMethodException e) {
                this._getDamageOfStack = this._gradItemInt.getMethod("getControlTagOfStack", ItemStack.class);
            }
            this._isApiAvailable = true;
        }
        catch (Exception e) {
            this._isApiAvailable = false;
            e.printStackTrace();
        }
    }

    public EnergyStorageData getStorageData(TileEntity target) {
        if (!this._isApiAvailable || target == null) {
            return null;
        }
        if (target instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)target;
            EnergyStorageData result = new EnergyStorageData();
            result.capacity = storage.getCapacity();
            result.stored = storage.getStored();
            result.units = "EU";
            result.type = 0;
            return result;
        }
        return null;
    }

    public int getNuclearCellTimeLeft(ItemStack stack) {
        if (!this._isApiAvailable || stack == null) {
            return -1;
        }
        this.initIds();
        if (Arrays.binarySearch(this._fuelIds, Item.func_150891_b((Item)stack.func_77973_b())) >= 0) {
            int delta;
            try {
                int maxDamage = (Integer)this._getMaxDamageEx.invoke((Object)stack.func_77973_b(), new Object[0]);
                int damage = (Integer)this._getDamageOfStack.invoke((Object)stack.func_77973_b(), stack);
                delta = maxDamage - damage;
            }
            catch (Exception e) {
                delta = stack.func_77958_k() - stack.func_77960_j();
            }
            return delta;
        }
        return -1;
    }
}

