/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.CTMData;
import mekanism.common.CommonProxy;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBlockCTM;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.ISpecialBounds;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.multiblock.IMultiblock;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGenerator
extends BlockContainer
implements ISpecialBounds,
IBlockCTM {
    public IIcon[][] icons = new IIcon[16][16];
    public CTMData[] ctms = new CTMData[16];
    public IIcon BASE_ICON;
    public Random machineRand = new Random();

    public BlockGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a((CreativeTabs)Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.BASE_ICON = register.func_94245_a("mekanism:SteelCasing");
        this.ctms[9] = new CTMData("ctm/ElectromagneticCoil", (Block)this, Arrays.asList(9)).registerIcons(register);
        this.ctms[10] = new CTMData("ctm/TurbineCasing", (Block)this, Arrays.asList(10, 11, 12)).registerIcons(register);
        this.ctms[11] = new CTMData("ctm/TurbineValve", (Block)this, Arrays.asList(10, 11, 12)).registerIcons(register);
        this.ctms[12] = new CTMData("ctm/TurbineVent", (Block)this, Arrays.asList(10, 11, 12)).registerIcons(register);
        this.ctms[13] = new CTMData("ctm/SaturatingCondenser", (Block)this, Arrays.asList(13)).registerIcons(register);
        this.icons[7][0] = register.func_94245_a("mekanism:TurbineRod");
        this.icons[8][0] = register.func_94245_a("mekanism:RotationalComplexSide");
        this.icons[8][1] = register.func_94245_a("mekanism:RotationalComplexTop");
        this.icons[9][0] = this.ctms[9].mainTextureData.icon;
        this.icons[10][0] = this.ctms[10].mainTextureData.icon;
        this.icons[11][0] = this.ctms[11].mainTextureData.icon;
        this.icons[12][0] = this.ctms[12].mainTextureData.icon;
        this.icons[13][0] = this.ctms[13].mainTextureData.icon;
    }

    public CTMData getCTMData(IBlockAccess world, int x, int y, int z, int meta) {
        return this.ctms[meta];
    }

    public boolean shouldRenderBlock(IBlockAccess world, int x, int y, int z, int meta) {
        return !GeneratorType.getFromMetadata((int)meta).hasModel;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        GeneratorType type = GeneratorType.getFromMetadata(meta);
        if (type == GeneratorType.ROTATIONAL_COMPLEX) {
            if (side != 0 && side != 1) {
                return this.icons[meta][0];
            }
            return this.icons[meta][1];
        }
        if (!type.hasModel) {
            return this.icons[meta][0];
        }
        return this.BASE_ICON;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        return this.func_149691_a(side, meta);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IMultiblock) {
                ((IMultiblock)tileEntity).update();
            }
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (!GeneratorType.getFromMetadata((int)world.func_72805_g((int)x, (int)y, (int)z)).hasModel && tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        tileEntity.setFacing((short)change);
        tileEntity.redstone = world.func_72864_z(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onPlace();
        }
        if (!world.field_72995_K && tileEntity instanceof IMultiblock) {
            ((IMultiblock)tileEntity).update();
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity;
        if (MekanismConfig.client.enableAmbientLighting && (tileEntity = world.func_147438_o(x, y, z)) instanceof IActiveState && !(tileEntity instanceof TileEntitySolarGenerator) && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return MekanismConfig.client.ambientLightingLevel;
        }
        return 0;
    }

    public int func_149692_a(int i) {
        return i;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return SecurityUtils.canAccess((EntityPlayer)player, (TileEntity)tile) ? super.func_149737_a(player, world, x, y, z) : 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item i, CreativeTabs creativetabs, List list) {
        for (GeneratorType type : GeneratorType.values()) {
            list.add(new ItemStack(i, 1, type.meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        if (MekanismUtils.isActive((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            float xRandom = (float)x + 0.5f;
            float yRandom = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)z + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            if (tileEntity.facing == 4) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom - iRandom), (double)yRandom + 0.5, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom - iRandom), (double)yRandom + 0.5, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.25, (double)y + 0.2, (double)z + 0.5, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            } else if (tileEntity.facing == 5) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom + iRandom), (double)yRandom + 0.5, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom + iRandom), (double)yRandom + 0.5, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.75, (double)y + 0.2, (double)z + 0.5, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            } else if (tileEntity.facing == 2) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.5, (double)y + 0.2, (double)z + 0.25, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            } else if (tileEntity.facing == 3) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom - jRandom), (double)yRandom + 0.5, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.5, (double)y + 0.2, (double)z + 0.75, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == GeneratorType.ADVANCED_SOLAR_GENERATOR.meta) {
            boolean canPlace = super.func_149742_c(world, x, y, z);
            boolean nonAir = false;
            nonAir |= world.func_147437_c(x, y, z);
            nonAir |= world.func_147437_c(x, y + 1, x);
            for (int xPos = -1; xPos <= 1; ++xPos) {
                for (int zPos = -1; zPos <= 1; ++zPos) {
                    nonAir |= world.func_147437_c(x + xPos, y + 2, z + zPos);
                }
            }
            return !nonAir && canPlace;
        }
        if (world.func_72805_g(x, y, z) == GeneratorType.WIND_GENERATOR.meta) {
            boolean canPlace = super.func_149742_c(world, x, y, z);
            boolean nonAir = false;
            for (int yPos = y + 1; yPos <= y + 4; ++yPos) {
                nonAir |= world.func_147437_c(x, yPos, z);
            }
            return !nonAir && canPlace;
        }
        return super.func_149742_c(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        int amount;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityTurbineRotor && (amount = ((TileEntityTurbineRotor)tileEntity).getHousedBlades()) > 0) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, new ItemStack(GeneratorsItems.TurbineBlade, amount));
            world.func_72838_d((Entity)entityItem);
        }
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onBreak();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float playerX, float playerY, float playerZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null) {
            Item tool = entityplayer.func_71045_bC().func_77973_b();
            if (MekanismUtils.hasUsableWrench((EntityPlayer)entityplayer, (int)x, (int)y, (int)z)) {
                if (SecurityUtils.canAccess((EntityPlayer)entityplayer, (TileEntity)tileEntity)) {
                    if (entityplayer.func_70093_af()) {
                        this.dismantleBlock(world, x, y, z, false);
                        return true;
                    }
                    if (MekanismUtils.isBCWrench((Item)tool)) {
                        ((IToolWrench)tool).wrenchUsed(entityplayer, x, y, z);
                    }
                    int change = ForgeDirection.ROTATION_MATRIX[ForgeDirection.UP.ordinal()][tileEntity.facing];
                    tileEntity.setFacing((short)change);
                    world.func_147459_d(x, y, z, (Block)this);
                } else {
                    SecurityUtils.displayNoAccess((EntityPlayer)entityplayer);
                }
                return true;
            }
        }
        if (metadata == GeneratorType.TURBINE_CASING.meta || metadata == GeneratorType.TURBINE_VALVE.meta || metadata == GeneratorType.TURBINE_VENT.meta) {
            return ((IMultiblock)world.func_147438_o(x, y, z)).onActivate(entityplayer);
        }
        if (metadata == GeneratorType.TURBINE_ROTOR.meta) {
            TileEntityTurbineRotor rod = (TileEntityTurbineRotor)tileEntity;
            if (!entityplayer.func_70093_af()) {
                if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() == GeneratorsItems.TurbineBlade) {
                    if (!world.field_72995_K && rod.editBlade(true) && !entityplayer.field_71075_bZ.field_75098_d) {
                        --entityplayer.func_71045_bC().field_77994_a;
                        if (entityplayer.func_71045_bC().field_77994_a == 0) {
                            entityplayer.func_70062_b(0, null);
                        }
                    }
                    return true;
                }
            } else {
                if (!world.field_72995_K) {
                    if (entityplayer.func_71045_bC() == null) {
                        if (rod.editBlade(false) && !entityplayer.field_71075_bZ.field_75098_d) {
                            entityplayer.func_70062_b(0, new ItemStack(GeneratorsItems.TurbineBlade));
                            entityplayer.field_71071_by.func_70296_d();
                        }
                    } else if (entityplayer.func_71045_bC().func_77973_b() == GeneratorsItems.TurbineBlade && entityplayer.func_71045_bC().field_77994_a < entityplayer.func_71045_bC().func_77976_d() && rod.editBlade(false) && !entityplayer.field_71075_bZ.field_75098_d) {
                        ++entityplayer.func_71045_bC().field_77994_a;
                        entityplayer.field_71071_by.func_70296_d();
                    }
                }
                return true;
            }
            return false;
        }
        int guiId = GeneratorType.getFromMetadata((int)metadata).guiId;
        if (guiId != -1 && tileEntity != null && !entityplayer.func_70093_af()) {
            if (SecurityUtils.canAccess((EntityPlayer)entityplayer, (TileEntity)tileEntity)) {
                entityplayer.openGui((Object)MekanismGenerators.instance, guiId, world, x, y, z);
            } else {
                SecurityUtils.displayNoAccess((EntityPlayer)entityplayer);
            }
            return true;
        }
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        GeneratorType type = GeneratorType.getFromMetadata(metadata);
        if (type != null) {
            return type.create();
        }
        return null;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return CommonProxy.CTM_RENDER_ID;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == GeneratorType.SOLAR_GENERATOR.meta) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.7f, 1.0f);
        } else if (metadata == GeneratorType.TURBINE_ROTOR.meta) {
            this.func_149676_a(0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onAdded();
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_147468_f(x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ISecurityItem securityItem;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        ItemStack itemStack = new ItemStack(GeneratorsBlocks.Generator, 1, world.func_72805_g(x, y, z));
        if (itemStack.field_77990_d == null && !(tileEntity instanceof TileEntityMultiblock)) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity == null) {
            return null;
        }
        if (tileEntity instanceof ISecurityTile && (securityItem = (ISecurityItem)itemStack.func_77973_b()).hasSecurity(itemStack)) {
            securityItem.setOwner(itemStack, ((ISecurityTile)tileEntity).getSecurity().getOwner());
            securityItem.setSecurity(itemStack, ((ISecurityTile)tileEntity).getSecurity().getMode());
        }
        if (tileEntity instanceof TileEntityElectricBlock) {
            IEnergizedItem electricItem = (IEnergizedItem)itemStack.func_77973_b();
            electricItem.setEnergy(itemStack, ((TileEntityElectricBlock)tileEntity).electricityStored);
        }
        if (tileEntity instanceof TileEntityContainerBlock && ((TileEntityContainerBlock)tileEntity).handleInventory()) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(((TileEntityContainerBlock)tileEntity).getInventory(new Object[0]), new Object[]{itemStack});
        }
        if (tileEntity instanceof ISustainedData) {
            ((ISustainedData)tileEntity).writeSustainedData(itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(new Object[]{itemStack}) && tileEntity instanceof ISustainedTank && ((ISustainedTank)tileEntity).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(((ISustainedTank)tileEntity).getFluidStack(new Object[0]), new Object[]{itemStack});
        }
        return itemStack;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z, null);
        world.func_147468_f(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata != GeneratorType.SOLAR_GENERATOR.meta && metadata != GeneratorType.ADVANCED_SOLAR_GENERATOR.meta && metadata != GeneratorType.WIND_GENERATOR.meta && metadata != GeneratorType.TURBINE_ROTOR.meta;
    }

    public void setRenderBounds(Block block, int metadata) {
        if (metadata == GeneratorType.SOLAR_GENERATOR.meta) {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.7f, 1.0f);
        } else if (metadata == GeneratorType.TURBINE_ROTOR.meta) {
            block.func_149676_a(0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f);
        } else {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean doDefaultBoundSetting(int metadata) {
        return true;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ForgeDirection[] valid = new ForgeDirection[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    public static enum GeneratorType {
        HEAT_GENERATOR(0, "HeatGenerator", 0, 160000.0, TileEntityHeatGenerator.class, true),
        SOLAR_GENERATOR(1, "SolarGenerator", 1, 96000.0, TileEntitySolarGenerator.class, true),
        GAS_GENERATOR(3, "GasGenerator", 3, MekanismConfig.general.FROM_H2 * 100.0, TileEntityGasGenerator.class, true),
        BIO_GENERATOR(4, "BioGenerator", 4, 160000.0, TileEntityBioGenerator.class, true),
        ADVANCED_SOLAR_GENERATOR(5, "AdvancedSolarGenerator", 1, 200000.0, TileEntityAdvancedSolarGenerator.class, true),
        WIND_GENERATOR(6, "WindGenerator", 5, 200000.0, TileEntityWindGenerator.class, true),
        TURBINE_ROTOR(7, "TurbineRotor", -1, -1.0, TileEntityTurbineRotor.class, false),
        ROTATIONAL_COMPLEX(8, "RotationalComplex", -1, -1.0, TileEntityRotationalComplex.class, false),
        ELECTROMAGNETIC_COIL(9, "ElectromagneticCoil", -1, -1.0, TileEntityElectromagneticCoil.class, false),
        TURBINE_CASING(10, "TurbineCasing", -1, -1.0, TileEntityTurbineCasing.class, false),
        TURBINE_VALVE(11, "TurbineValve", -1, -1.0, TileEntityTurbineValve.class, false),
        TURBINE_VENT(12, "TurbineVent", -1, -1.0, TileEntityTurbineVent.class, false),
        SATURATING_CONDENSER(13, "SaturatingCondenser", -1, -1.0, TileEntitySaturatingCondenser.class, false);

        public int meta;
        public String name;
        public int guiId;
        public double maxEnergy;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean hasModel;

        private GeneratorType(int i, String s, int j, double k, Class<? extends TileEntity> tileClass, boolean model) {
            this.meta = i;
            this.name = s;
            this.guiId = j;
            this.maxEnergy = k;
            this.tileEntityClass = tileClass;
            this.hasModel = model;
        }

        public static GeneratorType getFromMetadata(int meta) {
            for (GeneratorType type : GeneratorType.values()) {
                if (type.meta != meta) continue;
                return type;
            }
            return null;
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String getDescription() {
            return LangUtils.localize((String)("tooltip." + this.name));
        }

        public ItemStack getStack() {
            return new ItemStack(GeneratorsBlocks.Generator, 1, this.meta);
        }

        public String toString() {
            return Integer.toString(this.meta);
        }
    }
}

