/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.items.IBoundItem;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.texture.ResourceManager;
import am2.utility.InventoryUtilities;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemBoundAxe
extends ItemAxe
implements IBoundItem {
    public ItemBoundAxe(Item.ToolMaterial par2ToolMaterial) {
        super(par2ToolMaterial);
        this.func_77656_e(0);
    }

    public ItemBoundAxe setUnlocalizedAndTextureName(String name) {
        this.func_77655_b(name);
        this.func_111206_d(name);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = ResourceManager.RegisterTexture("bound_axe", par1IconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        this.UnbindItem(item, player, player.field_71071_by.field_70461_c);
        return false;
    }

    @Override
    public float maintainCost() {
        if (this.field_77862_b == Item.ToolMaterial.STONE) {
            return 0.1f;
        }
        if (this.field_77862_b == Item.ToolMaterial.IRON) {
            return 0.4f;
        }
        if (this.field_77862_b == Item.ToolMaterial.EMERALD) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int slotIndex, boolean par5) {
        if (par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)player);
            if (props.getCurrentMana() + props.getBonusCurrentMana() < this.maintainCost()) {
                this.UnbindItem(par1ItemStack, (EntityPlayer)par3Entity, slotIndex);
                return;
            }
            props.deductMana(this.maintainCost());
            if (par1ItemStack.func_77960_j() > 0) {
                par1ItemStack.func_77972_a(-1, (EntityLivingBase)par3Entity);
            }
        }
    }

    @Override
    public void UnbindItem(ItemStack itemstack, EntityPlayer player, int inventoryIndex) {
        itemstack = InventoryUtilities.replaceItem(itemstack, ItemsCommonProxy.spell);
        player.field_71071_by.func_70299_a(inventoryIndex, itemstack);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        MovingObjectPosition mop = this.func_77621_a(player.field_70170_p, player, false);
        if (mop != null) {
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            itemstack.field_77990_d.func_74768_a("block_break_face", mop.field_72310_e);
        } else {
            itemstack.field_77990_d.func_74768_a("block_break_face", 0);
        }
        return super.onBlockStartBreak(itemstack, X, Y, Z, player);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop = ItemsCommonProxy.spell.getMovingObjectPosition((EntityLivingBase)player, world, 4.0, true, false);
        if (mop != null && stack.func_77942_o()) {
            ItemStack castStack = this.getApplicationStack(stack);
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                SpellHelper.instance.applyStackStage(castStack, (EntityLivingBase)player, null, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, mop.field_72310_e, world, true, true, 0);
            } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g instanceof EntityLivingBase) {
                SpellHelper.instance.applyStackStage(castStack, (EntityLivingBase)player, (EntityLivingBase)mop.field_72308_g, mop.field_72308_g.field_70165_t, mop.field_72308_g.field_70163_u, mop.field_72308_g.field_70161_v, mop.field_72310_e, world, true, true, 0);
            }
        }
        return super.func_77659_a(stack, world, player);
    }

    private ItemStack getApplicationStack(ItemStack boundStack) {
        ItemStack castStack = SpellUtils.instance.constructSpellStack(boundStack.func_77946_l());
        castStack = SpellUtils.instance.popStackStage(castStack);
        castStack = InventoryUtilities.replaceItem(castStack, ItemsCommonProxy.spell);
        return castStack;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if (!living.func_70093_af() && this.getDigSpeed(stack, block, world.func_72805_g(x, y, z)) == this.field_77864_a) {
            ItemStack castStack = this.getApplicationStack(stack);
            SpellHelper.instance.applyStackStage(castStack, living, null, x, y, z, stack.field_77990_d.func_74762_e("block_break_face"), world, true, true, 0);
        }
        return super.func_150894_a(stack, world, block, x, y, z, living);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        set.add("axe");
        return set;
    }
}

