/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.renderers;

import am2.blocks.tileentities.TileEntityBlackAurem;
import am2.blocks.tileentities.TileEntityCelestialPrism;
import am2.blocks.tileentities.TileEntityObelisk;
import am2.texture.ResourceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class EssenceGeneratorRenderer
extends TileEntitySpecialRenderer {
    private ResourceLocation rLoc_obelisk = new ResourceLocation("arsmagica2", ResourceManager.getCustomBlockTexturePath("obelisk.png"));
    private ResourceLocation rLoc_obelisk_active = new ResourceLocation("arsmagica2", ResourceManager.getCustomBlockTexturePath("obelisk_active.png"));
    private ResourceLocation rLoc_obelisk_active_highpower = new ResourceLocation("arsmagica2", ResourceManager.getCustomBlockTexturePath("obelisk_active_highpower.png"));
    private ResourceLocation rLoc_obelisk_runes = new ResourceLocation("arsmagica2", ResourceManager.getCustomBlockTexturePath("obelisk_runes.png"));
    private ResourceLocation rLoc_celestial = new ResourceLocation("arsmagica2", ResourceManager.getCustomBlockTexturePath("celestial_prism.png"));
    private ResourceLocation rLoc_black = new ResourceLocation("arsmagica2", ResourceManager.getCustomBlockTexturePath("black_aurem.png"));
    private final WavefrontObject model_obelisk = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)ResourceManager.getOBJFilePath("Obelisk.obj"));
    private final WavefrontObject model_celestial = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)ResourceManager.getOBJFilePath("celestial_prism.obj"));

    public void renderAModelAt(TileEntityObelisk tile, double d, double d1, double d2, float f) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)278784);
        if (tile instanceof TileEntityCelestialPrism) {
            this.renderCelestial((TileEntityCelestialPrism)tile, d, d1, d2, f);
        } else if (tile instanceof TileEntityBlackAurem) {
            this.renderBlackAurem((TileEntityBlackAurem)tile, d, d1, d2, f);
        } else {
            this.renderObelisk(tile, d, d1, d2, f);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderObelisk(TileEntityObelisk tile, double d, double d1, double d2, float f) {
        if (tile.field_145851_c == 0 && tile.field_145848_d == 0 && tile.field_145849_e == 0) {
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
        }
        int i = 2;
        if (tile.func_145831_w() != null) {
            i = tile.func_145832_p();
        }
        int j = i * 90;
        GL11.glTranslated((double)(d + 0.5), (double)d1, (double)(d2 + 0.5));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        if (tile.isHighPowerActive()) {
            this.func_147499_a(this.rLoc_obelisk_active_highpower);
        } else if (tile.isActive()) {
            this.func_147499_a(this.rLoc_obelisk_active);
        } else {
            this.func_147499_a(this.rLoc_obelisk);
        }
        GL11.glRotatef((float)j, (float)0.0f, (float)1.0f, (float)0.0f);
        try {
            this.model_obelisk.renderAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tile.isActive()) {
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            this.func_147499_a(this.rLoc_obelisk_runes);
            float normx = (float)(System.currentTimeMillis() % 32000L) / 32000.0f;
            float normy = (float)(System.currentTimeMillis() % 28000L) / 28000.0f;
            GL11.glTranslatef((float)normx, (float)normy, (float)0.0f);
            float transp = (float)Math.abs(Math.sin((double)System.currentTimeMillis() / 1000.0));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)transp);
            try {
                this.model_obelisk.renderAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
    }

    private void renderCelestial(TileEntityCelestialPrism tile, double d, double d1, double d2, float f) {
        this.func_147499_a(this.rLoc_celestial);
        if (tile.field_145851_c != 0 && tile.field_145848_d != 0 && tile.field_145849_e != 0) {
            GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1), (float)((float)d2 + 0.5f));
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        } else {
            GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1 - 0.3f), (float)((float)d2 + 0.5f));
            GL11.glScalef((float)1.75f, (float)1.75f, (float)1.75f);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        RenderHelper.func_74518_a();
        Tessellator tessellator = Tessellator.field_78398_a;
        try {
            this.model_celestial.renderAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    private void renderBlackAurem(TileEntityBlackAurem tile, double d, double d1, double d2, float f) {
        GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1 + 1.0f), (float)((float)d2 + 0.5f));
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74518_a();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.renderArsMagicaEffect(tessellator, tile.field_145851_c + tile.field_145848_d + tile.field_145849_e, 1.0f);
        RenderHelper.func_74519_b();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private void renderArsMagicaEffect(Tessellator tessellator, float offset, float scale) {
        if (offset != 0.0f) {
            GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.rLoc_black);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glRotatef((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)(scale * 2.0f), (float)(scale * 2.0f), (float)(scale * 2.0f));
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        this.renderSprite(tessellator);
    }

    private void renderSprite(Tessellator tessellator) {
        float TLX = 0.0f;
        float BRX = 1.0f;
        float TLY = 0.0f;
        float BRY = 1.0f;
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        try {
            tessellator.func_78382_b();
            tessellator.func_78380_c(0xF000DF);
            tessellator.func_78374_a((double)(0.0f - f5), (double)(0.0f - f6), 0.0, (double)TLX, (double)BRY);
            tessellator.func_78374_a((double)(f4 - f5), (double)(0.0f - f6), 0.0, (double)BRX, (double)BRY);
            tessellator.func_78374_a((double)(f4 - f5), (double)(f4 - f6), 0.0, (double)BRX, (double)TLY);
            tessellator.func_78374_a((double)(0.0f - f5), (double)(f4 - f6), 0.0, (double)TLX, (double)TLY);
            tessellator.func_78381_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        this.renderAModelAt((TileEntityObelisk)tileentity, d, d1, d2, f);
    }
}

