/*
 * Decompiled with CFR 0.152.
 */
package am2.api.math;

import am2.api.math.AMVector3;

public class AMPlane {
    AMVector3[] planeDef;

    public AMPlane(AMVector3 ... plane) {
        this.planeDef = plane;
    }

    private AMVector3 planeNormal() {
        AMVector3 vVector1 = new AMVector3(this.planeDef[2], this.planeDef[0]);
        AMVector3 vVector2 = new AMVector3(this.planeDef[1], this.planeDef[0]);
        AMVector3 vNormal = AMVector3.crossProduct(vVector1, vVector2);
        vNormal.normalize();
        return vNormal;
    }

    private float planeDistance(AMVector3 normal, AMVector3 point) {
        float distance = 0.0f;
        distance = -(normal.x * point.x + normal.y * point.y + normal.z * point.z);
        return distance;
    }

    public boolean lineSegmentCrosses(AMVector3 p1, AMVector3 p2) {
        float distance1 = 0.0f;
        float distance2 = 0.0f;
        AMVector3 vNormal = this.planeNormal();
        float originDistance = this.planeDistance(vNormal, this.planeDef[0]);
        distance1 = vNormal.x * p1.x + vNormal.y * p1.y + vNormal.z * p1.z + originDistance;
        return !(distance1 * (distance2 = vNormal.x * p2.x + vNormal.y * p2.y + vNormal.z * p2.z + originDistance) >= 0.0f);
    }
}

