/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.mcdiscord.discord.api.http;

import com.google.gson.Gson;
import cpw.mods.fml.common.FMLLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import net.technicpack.mcdiscord.discord.api.IAuthedDiscordApi;
import net.technicpack.mcdiscord.discord.callback.DiscordCallback;
import net.technicpack.mcdiscord.discord.callback.DiscordResponseHandler;
import net.technicpack.mcdiscord.discord.io.auth.AuthRequest;
import net.technicpack.mcdiscord.discord.io.auth.AuthResponse;
import net.technicpack.mcdiscord.discord.io.server.Server;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class HttpDiscordApi
implements IAuthedDiscordApi {
    private String url;
    private DiscordResponseHandler responseHandler;
    private boolean isAuthed;
    private String authToken;
    private static final Gson gson = new Gson();

    HttpDiscordApi(String url, DiscordResponseHandler responseHandler) {
        this.url = url;
        this.isAuthed = false;
        this.responseHandler = responseHandler;
    }

    private HttpDiscordApi(String url, DiscordResponseHandler responseHandler, String token) {
        this.url = url;
        this.authToken = token;
        this.isAuthed = true;
        this.responseHandler = responseHandler;
    }

    @Override
    public void getServer(final String serverId, final DiscordCallback<Server> callback) {
        if (serverId == null || serverId.isEmpty()) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                HttpDiscordApi.this.synchronousGetServer(serverId, callback);
            }
        }).start();
    }

    @Override
    public void authenticate(final AuthRequest request, final DiscordCallback<IAuthedDiscordApi> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                HttpDiscordApi.this.synchronousAuthenticate(request, callback);
            }
        }).start();
    }

    protected void synchronousGetServer(String serverId, DiscordCallback<Server> callback) {
        String serverUrl = this.url + "servers/" + serverId + "/widget.json";
        Server server = null;
        try {
            server = HttpDiscordApi.getRestObject(Server.class, serverUrl);
        }
        catch (IOException ex) {
            FMLLog.getLogger().error("Error pulling server from Discord.", (Throwable)ex);
        }
        this.postCallback(server, callback);
    }

    protected void synchronousAuthenticate(AuthRequest request, DiscordCallback<IAuthedDiscordApi> callback) {
        if (this.isAuthed) {
            this.postCallback(this, callback);
            return;
        }
        AuthResponse response = null;
        try {
            String authUrl = this.url + "auth/login";
            response = HttpDiscordApi.postRestObject(AuthResponse.class, request, authUrl);
        }
        catch (IOException ex) {
            FMLLog.getLogger().error("Error authenticating with Discord.", (Throwable)ex);
        }
        if (response == null) {
            FMLLog.severe((String)"Discord returned a null auth response with no error message.", (Object[])new Object[0]);
        } else {
            for (String error : response.getUsernameErrors()) {
                FMLLog.severe((String)"Discord had a problem with the username: %s", (Object[])new Object[]{error});
            }
            for (String error : response.getPasswordErrors()) {
                FMLLog.severe((String)"Discord has a problem with the password: %s", (Object[])new Object[]{error});
            }
            if (response.getPasswordErrors().size() == 0 && response.getUsernameErrors().size() == 0) {
                if (response.getToken() == null || response.getToken().isEmpty()) {
                    FMLLog.severe((String)"Discord returned an auth response with no errors, but also no auth token.", (Object[])new Object[0]);
                }
                this.postCallback(new HttpDiscordApi(this.url, this.responseHandler, response.getToken()), callback);
                return;
            }
        }
        this.postCallback(null, callback);
    }

    protected <T> void postCallback(T callbackData, DiscordCallback<T> callback) {
        callback.setValue(callbackData);
        this.responseHandler.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T postRestObject(Class<T> restObject, Object postData, String url) throws IOException {
        Object object;
        InputStream stream = null;
        String postObj = gson.toJson(postData);
        try {
            Object result;
            URLConnection conn = new URL(url).openConnection();
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            OutputStream outputStream = null;
            try {
                outputStream = conn.getOutputStream();
                PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
                writer.write(postObj);
                writer.flush();
                outputStream.close();
            }
            finally {
                if (outputStream != null) {
                    IOUtils.closeQuietly((OutputStream)outputStream);
                }
            }
            stream = conn.getInputStream();
            String data = IOUtils.toString((InputStream)stream, (Charset)Charsets.UTF_8);
            object = result = gson.fromJson(data, restObject);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return (T)object;
    }

    public static <T> T getRestObject(Class<T> restObject, String url) throws IOException {
        return HttpDiscordApi.getRestObject(restObject, url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getRestObject(Class<T> restObject, String url, String token) throws IOException {
        Object object;
        InputStream stream = null;
        try {
            Object result;
            URLConnection conn = new URL(url).openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
            if (token != null) {
                conn.setRequestProperty("authorization", token);
            }
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            stream = conn.getInputStream();
            String data = IOUtils.toString((InputStream)stream, (Charset)Charsets.UTF_8);
            object = result = gson.fromJson(data, restObject);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return (T)object;
    }
}

