/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.mcdiscord.data;

import net.technicpack.mcdiscord.discord.io.server.Server;
import net.technicpack.mcdiscord.network.packet.UpdateServerPacket;

public class ServerModel {
    private String serverId;
    private int discordPlayerCount;
    private String inviteLink;

    public String getServerId() {
        return this.serverId;
    }

    public int getDiscordPlayerCount() {
        return this.discordPlayerCount;
    }

    public String getInviteLink() {
        return this.inviteLink;
    }

    public ServerModel(String serverId) {
        this.serverId = serverId;
    }

    public boolean equals(Server server) {
        if (server == null) {
            return false;
        }
        if (this.serverId == null != (server.getId() == null)) {
            return false;
        }
        if (this.serverId != null && !this.serverId.equals(server.getId())) {
            return false;
        }
        if (this.discordPlayerCount != server.getMemberCount()) {
            return false;
        }
        if (this.inviteLink == null != (server.getInviteLink() == null)) {
            return false;
        }
        return this.inviteLink == null || this.inviteLink.equals(server.getInviteLink());
    }

    public void updateServer(Server server) {
        this.serverId = server.getId();
        this.discordPlayerCount = server.getMemberCount();
        this.inviteLink = server.getInviteLink();
    }

    public void updateServer(UpdateServerPacket packet) {
        this.serverId = packet.getServerId();
        this.discordPlayerCount = packet.getMemberCount();
        this.inviteLink = packet.getChannelInvite();
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
        this.discordPlayerCount = 0;
        this.inviteLink = null;
    }
}

