/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.forestry;

import codechicken.nei.PositionedStack;
import forestry.core.utils.ShapedRecipeCustom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerShapedCustom
extends RecipeHandlerBase {
    @Override
    public String getRecipeID() {
        return "crafting";
    }

    public String getRecipeName() {
        return Utils.translate("handler.forestry.shaped");
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(84, 23, 24, 18);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public String getOverlayIdentifier() {
        return this.getRecipeID();
    }

    @Override
    public void loadAllRecipes() {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof ShapedRecipeCustom)) continue;
            this.arecipes.add(new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof ShapedRecipeCustom) || !Utils.areStacksSameTypeCraftingSafe(((ShapedRecipeCustom)recipe).func_77571_b(), result)) continue;
            this.arecipes.add(new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof ShapedRecipeCustom)) continue;
            CachedShapedCustomRecipe crecipe = new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe);
            if (crecipe.inputs == null || !crecipe.contains(crecipe.inputs, ingredient)) continue;
            crecipe.setIngredientPermutationNBT(crecipe.inputs, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    public class CachedShapedCustomRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;

        public CachedShapedCustomRecipe(ShapedRecipeCustom recipe) {
            if (recipe.getIngredients() != null && recipe.getIngredients().length > 0) {
                this.setIngredients(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients());
            }
            if (recipe.func_77571_b() != null) {
                this.output = new PositionedStack((Object)recipe.func_77571_b(), 119, 24);
            }
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Object item;
                    if (items.length <= y * width + x || (item = items[y * width + x]) == null || item instanceof ItemStack[] && ((ItemStack[])item).length == 0 || item instanceof List && ((List)item).size() == 0) continue;
                    PositionedStack stack = new PositionedStack(item, 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerShapedCustom.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

